<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');
define('MIN_ACCESS_LEVEL', 10); // allow moderators
// make sure we have the comment to edit
if(!isset($_REQUEST['gViewReportId']))
{
    $result = array();
    $result['error'] = true;
    $result['msg'] = 'Report ID not found.';
    echo json_encode($result);
    exit;
}

// load all reports
$reportId = (int) $_REQUEST['gViewReportId'];
$report = $db->getRows("SELECT users.username, file.originalFilename AS of, plugin_comments.*, plugin_comments_reports.id AS rid, plugin_comments_reports.comId AS rcomid, plugin_comments_reports.reportedBy AS rby, plugin_comments_reports.reportDate AS rdate, plugin_comments_reports.ipAddress AS rip FROM plugin_comments_reports LEFT JOIN users ON plugin_comments_reports.reportedBy = users.id LEFT JOIN plugin_comments ON plugin_comments_reports.comId = plugin_comments.id LEFT JOIN file ON plugin_comments.fileId = file.id WHERE plugin_comments_reports.comId = '" . (int) $reportId . "' ORDER BY rdate");

if(!$report)
{
    $result = array();
    $result['error'] = true;
    $result['msg'] = 'Report ID not found.';
    echo json_encode($result);
    exit;
}

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';

$result['html'] = '<p style="padding-bottom: 4px;"></p>
					<span id="popupMessageContainer"></span>
					<form id="viewReportForm" class="form-horizontal form-label-left input_mask">
                                        <input type="hidden" name="comId" id="comId" value="' . $report[0]['id'] . '"/>';

$result['html'] .= '<table class="table table-data-list" style="margin-top: 0px;"><tbody>';

foreach($report AS $rep)
{
    $result['html'] .= '<tr>
                            <td>Filename:</td>
                            <td>' . validation::safeOutputToScreen(strlen($rep['of'])?$rep['of']:'[unavailable]') . '</td>';
    $result['html'] .= '</tr>';

    $result['html'] .= '<tr>
                            <td>Reported By:</td>
                            <td><a href="' . ADMIN_WEB_ROOT . '/user_edit.php?id=' . $rep['rby'] . '" target="_blank">' . validation::safeOutputToScreen($rep['username']) . '</a>&nbsp;&nbsp;(Logged IP: ' . validation::safeOutputToScreen($rep['rip']) . ')</td>
                        </tr>';

    $result['html'] .= '<tr>
                            <td>Date:</td>
                            <td>' . coreFunctions::formatDate($rep['rdate']) . '</td>
                        </tr>';

    $result['html'] .= '</tbody></table>';
    
    $result['html'] .= '<div class="form">';
    $result['html'] .= '<div class="form-group">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12">Reported Comment:';
    if(COUNT($result) > 1)
    {
        $result['html'] .= '<br/><input type="checkbox" name="rSelect[]" id="rSelect[]" value="' . $rep['rid'] . '"/>';
    }
    $result['html'] .= '</label>
                            <div class="col-md-9 col-sm-9 col-xs-12">
                                <textarea name="editedComment" id="editedComment" class="form-control" rows="5" readonly>' . validation::safeOutputToScreen($rep['content']) . '</textarea>
                            </div>
                        </div>';
    $result['html'] .= '</div>';
    $result['html'] .= '</div>';

    if(COUNT($result) > 1)
    {
        $result['html'] .= '<br/>';
    }
}
$result['html'] .= '</form>';

echo json_encode($result);
exit;
