<?php

include_once('../../../../core/includes/master.inc.php');

// Set up the logs
log::setContext('plugin_comments_new_comment_log');

// Get the plugin settings
$pluginConfig	= pluginHelper::pluginSpecificConfiguration('comments');
$pluginSettings = json_decode($pluginConfig['data']['plugin_settings'], true);
if ($pluginSettings)
{
    if($pluginSettings['autoApprove'] == 0)
	{
		$status = 'pending';
	}
	else
	{
		$status = 'active';
	}
}

$pluginObj  = pluginHelper::getInstance('comments');
$captcha    = $_REQUEST['captcha'];
$comment    = trim($_REQUEST['comment']);
//$comment    = str_replace(array("\n", "\r", "\t"), " ", $comment);
$comment    = nl2br($comment);
$fileId     = (int) $_REQUEST['fileId'];
$userId     = (int) $Auth->id;
$ipAddress	= coreFunctions::getUsersIPAddress();

// Prepare result
$result = array();
$result['error'] = false;
$result['msg']   = '';

if(strlen($comment) == 0)
{
    $result['error'] = true;
    $result['msg']   = t('plugin_comments_invalid_comment_length', 'You didn\'t enter a comment.');
	log::info('Zero Comment Length');
}
// Do we need to check for captcha?
if($pluginSettings['enabled_non_user'] == 1 && $pluginSettings['enableCaptcha'] == 1 && $Auth->level_id == 0)
{
    $rs = coreFunctions::captchaCheck($captcha);
    if (!$rs)
    {
        $result['error'] = true;
        $result['msg']   = t('invalid_captcha');
		log::info('Invalid Captcha');
    }
}

// Clean the input
$comment = $pluginObj->cleanInput($comment);

// Check if the user has posted within the last xx seconds/minutes/hours depending on the floodControl settings in the admin area.
if((int)$pluginSettings['floodControl'] != 0)
{
	if($Auth->level_id != 0)
	{
		$userPosted = $db->getRow("SELECT id FROM plugin_comments WHERE userId = '".(int)$userId."' AND dateAdded > DATE_SUB(NOW(), INTERVAL ".$pluginSettings['floodControl'].") LIMIT 1");
	}
	elseif($pluginSettings['enabled_non_user'] == 1 && $Auth->level_id == 0)
	{
		$userPosted = $db->getRow("SELECT id FROM plugin_comments WHERE ipAddress = '".$db->quote($ipAddress)."' AND dateAdded > DATE_SUB(NOW(), INTERVAL ".(int)$pluginSettings['floodControl'].") LIMIT 1");
	}
	if($userPosted)
	{
		$result['error'] = true;
		$result['msg']   = t('plugin_comments_comment_spam_prevention_timed', 'Sorry, you can only make a comment every [[[FLOODTIMER]]]s.', array('FLOODTIMER' => strtolower($pluginSettings['floodControl'])));
		log::error('Flood Prevention'. print_r($userPosted, true));
	}
}

// No errors then its all good
if($result['error'] === false)
{
	$sql = "INSERT INTO plugin_comments (fileId, userId, dateAdded, ipAddress, content, status, rating) VALUES ('".(int)$fileId."', '".(int)$userId."', NOW(), ".$db->quote($ipAddress).", ".$db->quote($comment).", ".$db->quote($status).", '0')";
	log::info('Comment Query: '.$sql);
	$insert = $db->query($sql);
    
    if($insert)
    {
        if($pluginSettings['autoApprove'] == 1)
        {
            $result['error'] = false;
            $result['msg']   = t('plugin_comments_comment_added', 'Your comment was added successfully');
			log::info('Comment Added - Auto Approved.');
        }
        else
        {
            $result['error'] = false;
            $result['msg']   = t('plugin_comments_comment_sent_pending_approval', 'Your comment has been sent and is pending approval in the moderation queue.');
			log::info('Comment Added - Pending Approval.');
        }
    }
    else
    {
        $result['error'] = true;
        $result['msg']   = t('plugin_comments_comment_not_added', 'Sorry, there was an error adding your comment, please try again.');
		log::info('Error adding the comment.');
    } 
}
log::breakInLogFile();
echo json_encode($result);
exit;