<?php
// available params
// $params['file']
// $params['Auth']

// ignore if we don't have the file data
if($params['file'] != null)
{
    // check this is an image
    if ($params['file']->isImage())
    {
        // load plugin details
        $pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
        $pluginConfig   = $pluginDetails['config'];
        $pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);
    
        // only for active files
        if($params['file']->statusId == 1)
        {
            $imageLink = file::getIconPreviewImageUrl((array)$params['file'], false, 160, false, PluginImageviewer::OG_THUMB_SIZE, PluginImageviewer::OG_THUMB_SIZE);
            ?>
            <meta property="og:image" content="<?php echo $imageLink; ?>" />
            <meta property="og:description" content="<?php echo validation::safeOutputToScreen(t('view_image_on', 'View image on')); ?> <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>" />
            <meta property="og:url" content="<?php echo validation::safeOutputToScreen($params['file']->getFullShortUrl()); ?>" />
            <meta property="og:title" content="<?php echo validation::safeOutputToScreen($params['file']->originalFilename); ?>" />

            <?php
            // output size if we have it so it renders quicker
            $size = @getimagesize($imageLink);
            if($size)
            {
                if((int) $size[0] && (int) $size[1])
                {
                    $width = (int) $size[0];
                    $height = (int) $size[1];
                    ?>
                    <meta property="og:image:width" content="<?php echo validation::safeOutputToScreen($width); ?>" />
                    <meta property="og:image:height" content="<?php echo validation::safeOutputToScreen($height); ?>" />
                    <?php
                }
            }
        }
    }
}