CREATE TABLE IF NOT EXISTS `plugin_imageviewer_embed_token` (
  `token` varchar(32) COLLATE utf8_bin NOT NULL,
  `date_added` datetime NOT NULL,
  `file_id` int(11) NOT NULL,
  UNIQUE KEY `token` (`token`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE `plugin_imageviewer_watermark` (`id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY, `file_name` VARCHAR(255) NOT NULL, `image_content` BLOB NOT NULL) ENGINE = MyISAM;

CREATE TABLE IF NOT EXISTS `plugin_imageviewer_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `width` int(8) NOT NULL,
  `height` int(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1 ;

ALTER TABLE `plugin_imageviewer_embed_token` ADD `ip_address` VARCHAR( 15 ) NULL;
ALTER TABLE `plugin_imageviewer_meta` ADD `raw_data` TEXT NULL;

ALTER TABLE  `plugin_imageviewer_meta` ADD  `date_taken` DATETIME NULL;

CREATE TABLE IF NOT EXISTS `plugin_imageviewer_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) COLLATE utf8_bin NOT NULL,
  `key` varchar(255) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`),
  KEY `label` (`label`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=15 ;

INSERT INTO `plugin_imageviewer_category` (`id`, `label`, `key`) VALUES
(1, 'Just For Fun', 'just-for-fun'),
(2, 'Scenes', 'scenes'),
(3, 'Work', 'work'),
(4, 'Sports', 'sports'),
(5, 'Music', 'music'),
(6, 'Colorful', 'colorful'),
(7, 'Nature', 'nature'),
(8, 'Travel', 'travel'),
(9, 'Weddings', 'weddings'),
(10, 'Animals', 'animals'),
(11, 'Illustrations', 'illustrations'),
(12, 'Cars', 'cars'),
(13, 'Art', 'art'),
(14, 'Other', 'other');

CREATE TABLE IF NOT EXISTS `plugin_imageviewer_category_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_id` (`file_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;

CREATE TABLE  `plugin_imageviewer_image_like` (
`id` INT( 11 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`file_id` INT( 11 ) NOT NULL ,
`user_id` INT( 11 ) NOT NULL ,
`created` DATETIME NOT NULL ,
INDEX (  `file_id` ,  `user_id` ,  `created` )
) ENGINE = MYISAM ;

ALTER TABLE  `plugin_imageviewer_category` ADD  `display_order` INT( 3 ) NULL;

ALTER TABLE `plugin_imageviewer_meta`  ADD `image_colors` VARCHAR(100) NULL DEFAULT NULL,  ADD `image_bg_color` VARCHAR(7) NULL DEFAULT NULL,  ADD INDEX (`image_bg_color`) ,  ADD FULLTEXT (`image_colors`);

CREATE TABLE `plugin_imageviewer_background_thumb` (
`id` INT( 11 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`file_id` INT( 11 ) NOT NULL ,
`thumb_status` ENUM(  'processing',  'failed',  'created' ) NOT NULL ,
`date_added` DATETIME NOT NULL
) ENGINE = MYISAM;
ALTER TABLE  `plugin_imageviewer_background_thumb` CHANGE  `thumb_status`  `thumb_status` ENUM(  'processing',  'failed',  'created',  'nonimage' ) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL;
ALTER TABLE  `plugin_imageviewer_background_thumb` ADD INDEX (  `file_id` );
ALTER TABLE  `plugin_imageviewer_background_thumb` ADD  `processing_time` DECIMAL( 5, 2 ) NULL;

