<?php

// setup includes
require_once('../../../core/includes/master.inc.php');

// constants
define('SUCCESS_THUMB_WIDTH', '200');
define('SUCCESS_THUMB_HEIGHT', '200');

// load image viewer plugin details
$pluginObj      = pluginHelper::getInstance('imageviewer');
$pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// do not allow if embed options are disabled
if ((int) $pluginSettings['show_embedding'] == 0)
{
    // embedding disabled
    coreFunctions::output404();
}

// validation
$shortUrl = trim($_REQUEST['s']);
$f        = 0;
if (isset($_REQUEST['f']))
{
    $f = trim($_REQUEST['f']);
}

// try to load the file object
$file = null;
if ($shortUrl)
{
    $file = file::loadByShortUrl($shortUrl);
}

// load file details
if (!$file)
{
    // no file found
    coreFunctions::output404();
}

// file must be active
if ($file->statusId != 1)
{
    coreFunctions::output404();
}

// check file permissions, allow owners, non user uploads and admin/mods
if($file->userId != null)
{
	if((($file->userId != $Auth->id) && ($Auth->level_id < 10)))
	{
		// if this is a private file
		if(coreFunctions::getOverallPublicStatus($file->userId, $file->folderId, $file->id) == false)
		{
			header('HTTP/1.0 401 Unauthorized');
			exit;
		}
	}
}

// check if file needs a password
$album = null;
if($Auth->id != $file->userId)
{
	if($file->folderId !== NULL)
	{
		$album = $file->getFolderData();
	}
	if(($album) && (strlen($album->accessPassword) > 0))
	{
		// see if we have it in the session already
		$askPassword = true;
		if(!isset($_SESSION['folderPassword']))
		{
			$_SESSION['folderPassword'] = array();
		}
		elseif(isset($_SESSION['folderPassword'][$album->id]))
		{
			if($_SESSION['folderPassword'][$album->id] == $album->accessPassword)
			{
				$askPassword = false;
			}
		}
		
		if($askPassword)
		{
			// redirect to main page which requests for a password
			coreFunctions::redirect(file::getFileUrl($file->id));
		}
	}
}

// cache paths
$uniqueHash = $file->getFileHash();
if ((int) $pluginSettings['caching'] == 1)
{
    $cacheFilePath = '../../../core/cache/plugins/imageviewer/';
    $cacheFilePath .= $file->id . '/';
	if($uniqueHash != null)
	{
		$cacheFilePath .= $uniqueHash . '/';
	}
    if (!file_exists($cacheFilePath))
    {
        mkdir($cacheFilePath, 0777, true);
    }
    $cacheFileName = (int) $pluginSettings['thumb_size_w'] . 'x' . (int) $pluginSettings['thumb_size_h'] . '_' . $pluginSettings['thumb_resize_method'] . '.jpg';
    if ($f == 1)
    {
        $cacheFileName = (int) SUCCESS_THUMB_WIDTH . 'x' . (int) SUCCESS_THUMB_HEIGHT . '_' . $pluginSettings['thumb_resize_method'] . '.jpg';
    }
    $fullCachePath = $cacheFilePath . $cacheFileName;
}

// check for cache
if (((int) $pluginSettings['caching'] == 0) || (!file_exists($fullCachePath)))
{
    // create embed token
    $embedToken           = md5(microtime());
    $dbInsert             = new DBObject("plugin_imageviewer_embed_token", array("token", "date_added", "file_id"));
    $dbInsert->token      = $embedToken;
    $dbInsert->date_added = coreFunctions::sqlDateTime();
    $dbInsert->file_id    = $file->id;
    $dbInsert->insert();

    // get image contents
    header('Content-Type: image/jpeg');
	
	// create holding cache, if it doesn't already exist
	$pluginObj->setupImageMetaAndCache($file);

    // get holding cache if it exists, saves loading from main image
	$contents = '';
    if(($width <= $pluginObj->getHoldingCacheSize()) && ($height <= $pluginObj->getHoldingCacheSize()))
    {
        $contents = $pluginObj->getHoldingCache($file);
    }
	if(!strlen($contents))
    {
        // use original image
        $contents = $file->download(false);
    }

    // load into memory
    $im = imagecreatefromstring($contents);
    if ($im === false)
    {
        // failed reading image
        coreFunctions::output404();
    }

    // get image size
    $imageWidth  = imagesx($im);
    $imageHeight = imagesy($im);

    $w = (int) $pluginSettings['thumb_size_w'];
    if ($f == 1)
    {
        $w = (int) SUCCESS_THUMB_WIDTH;
    }
    $newwidth  = $w;
    $newheight = ($imageHeight / $imageWidth) * $newwidth;
    if ($newwidth > $imageWidth)
    {
        $newwidth = $imageWidth;
    }
    if ($newheight > $imageHeight)
    {
        $newheight = $imageHeight;
    }
    $tmp  = imagecreatetruecolor($newwidth, $newheight);
    $tmpH = imagesy($tmp);

    // set background to white for transparent images
    $back = imagecolorallocate($tmp, 255, 255, 255);
    imagefilledrectangle($tmp, 0, 0, $newwidth, $newheight, $back);

    // check height max
    $h = $pluginSettings['thumb_size_h'];
    if ($f == 1)
    {
        $h = (int) SUCCESS_THUMB_HEIGHT;
    }
    if ($tmpH > (int) $h)
    {
        $newheight = (int) $h;
        $newwidth  = ($imageWidth / $imageHeight) * $newheight;
        $tmp       = imagecreatetruecolor($newwidth, $newheight);
    }

    // preserve transparency in gifs
    if ($file->extension == 'gif')
    {
        imagecolortransparent($tmp, imagecolorallocatealpha($tmp, 0, 0, 0, 127));
        imagealphablending($tmp, false);
        imagesavealpha($tmp, true);
    }

    // this line actually does the image resizing, copying from the original
    // image into the $tmp image
    imagecopyresampled($tmp, $im, 0, 0, 0, 0, $newwidth, $newheight, $imageWidth, $imageHeight);

    // add white padding
    if ($pluginSettings['thumb_resize_method'] == 'padded')
    {
        // create base image
        $bgImg = imagecreatetruecolor((int) $w, (int) $h);

        // set background white
        $background = imagecolorallocate($bgImg, 255, 255, 255);  // white
        //$background = imagecolorallocate($bgImg, 0, 0, 0);  // black
        imagefill($bgImg, 0, 0, $background);

        // add on the resized image
        imagecopyresampled($bgImg, $tmp, ((int) $w / 2) - ($newwidth / 2), ((int) $h / 2) - ($newheight / 2), 0, 0, $newwidth, $newheight, $newwidth, $newheight);

        // reassign variable so the image is output below
        imagedestroy($tmp);
        $tmp = $bgImg;
    }

    // save image
    $rs = false;
    if ((int) $pluginSettings['caching'] == 1)
    {
        // save image
        ob_start();
        imagejpeg($tmp, null, $pluginObj->getThumbnailImageQuality());
        $imageContent = ob_get_clean();
        $rs           = cache::saveCacheToFile('plugins/imageviewer/' . $file->id . '/' . ($uniqueHash!=null?($uniqueHash.'/'):'') . $cacheFileName, $imageContent);
    }

    if (!$rs)
    {
        // failed saving cache (or caching disabled), just output
        header('Content-Type: image/jpeg');
        imagejpeg($tmp, null, $pluginObj->getThumbnailImageQuality());
        exit;
    }

    // cleanup memory
    imagedestroy($tmp);
}

header('Content-Type: image/jpeg');
echo cache::getCacheFromFile('plugins/imageviewer/' . $file->id . '/' . ($uniqueHash!=null?($uniqueHash.'/'):'') . $cacheFileName);
