<?php

// initial constants
define('ADMIN_PAGE_TITLE', 'Manage Categories');
define('ADMIN_SELECTED_PAGE', 'image_categories');
define('ADMIN_SELECTED_SUB_PAGE', 'image_categories_manage');

// includes and security
include_once ('../../../core/includes/master.inc.php');
include_once (DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');                 

// page header
include_once (ADMIN_ROOT . '/_header.inc.php');

?>

<!-- Load jQuery build -->
<script type="text/javascript">
    oTable = null;
    gRemoveCategoryId = null;
    gTableLoaded = false;
	gEditCategoryId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/category_manage.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 2, "asc" ]],
            "aoColumns" : [   
                { bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide" },
                { sName: 'label' },
                { sName: 'key', sWidth: '25%', sClass: "adminResponsiveHide" },
                { sName: 'total_images', sWidth: '15%', sClass: "center adminResponsiveHide" },
                { bSortable: false, sWidth: '20%', sClass: "center" }
            ],                                
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": sSource,
                    "data": aoData,
                    "success": fnCallback
                });
                gTableLoaded = true;
            },
            "fnDrawCallback": function (oSettings) {
                postDatatableRender();
            },
            dom: "lBfrtip",
            buttons: [
              {
                extend: "copy",
                className: "btn-sm"
              },
              {
                extend: "csv",
                className: "btn-sm"
              },
              {
                extend: "excel",
                className: "btn-sm"
              },
              {
                extend: "pdfHtml5",
                className: "btn-sm"
              },
              {
                extend: "print",
                className: "btn-sm"
              }
            ],
            "oLanguage": {
                "oPaginate": {
                    "sFirst": "<?php

echo t('datatable_first', 'First');

?>",
                    "sPrevious": "<?php

echo t('datatable_previous', 'Previous');

?>",
                    "sNext": "<?php

echo t('datatable_next', 'Next');

?>",
                    "sLast": "<?php

echo t('datatable_last', 'Last');

?>"
                },
                "sEmptyTable": "<?php

echo t('plugin_torrentdownload_datatable_no_matching_records_found',
    'No torrents found in current search filter.');

?>",
                "sInfo": "<?php

echo t('datatable_showing_x_to_x_of_total_entries',
    'Showing _START_ to _END_ of _TOTAL_ entries');

?>",
                "sInfoEmpty": "<?php

echo t('datatable_no_data', 'No data');

?>",
                "sLengthMenu": "<?php

echo t('datatable_show_menu_entries', 'Show _MENU_ entries');

?>",
                "sProcessing": "<?php

echo t('datatable_loading_please_wait', 'Loading, please wait...');

?>",
                "sInfoFiltered": "<?php

echo t('datatable_base_filtered', ' (filtered)');

?>",
                "sSearch": "<?php

echo t('datatable_search_text', 'Search:');

?>",
                "sZeroRecords": "<?php

echo t('plugin_torrentdownload_datatable_no_matching_records_found',
    'No torrents found in current search filter.');

?>"
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
		
        <?php if(isset($_REQUEST['add'])): ?>
        addCategory();
        <?php endif; ?>
    });

    function reloadTable()
    {
        oTable.fnDraw();
    }

    function confirmRemoveCategory(categoryId)
    {
        gRemoveCategoryId = categoryId;
        showBasicModal('<p>Are you sure you want to remove this category? Any images will remain active however they will no longer be associated with this category.</p>', 'Confirm Removal', '<button type="button" class="btn btn-primary" onClick="removeCategory(); return false;">Remove Category</button>');        
    }
    
    function removeCategory()
    {
        $.ajax({
            type: "POST",
            url: "ajax/category_manage_remove.ajax.php",
            data: { gRemoveCategoryId: gRemoveCategoryId },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable();
                    hideModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
	
    function addCategory()
    {
        gEditCategoryId = null;
        showBasicModal('Loading...', 'Add Category', '<button type="button" class="btn btn-primary" onClick="processEditCategory(); return false;">Add Category</button>');
        loadEditCategoryForm();
    }
	
    function editCategory(categoryId)
    {
        gEditCategoryId = categoryId;
        showBasicModal('Loading...', 'Edit Category', '<button type="button" class="btn btn-primary" onClick="processEditCategory(); return false;">Update Category</button>');
        loadEditCategoryForm();
    }
    
    function loadEditCategoryForm()
    {
        $.ajax({
            type: "POST",
            url: "ajax/category_manage_edit_form.ajax.php",
            data: {gEditCategoryId: gEditCategoryId},
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    setBasicModalContent(json.msg);
                }
                else
                {
                    setBasicModalContent(json.html);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                setBasicModalContent(XMLHttpRequest.responseText);
            }
        });
    }
	
    function processEditCategory()
    {
        // get data
        label = $('#label').val();
        key = $('#key').val();
        existing_category_id = gEditCategoryId;

        $.ajax({
            type: "POST",
            url: "ajax/category_manage_edit_process.ajax.php",
            data: {existing_category_id: existing_category_id, label: label, key: key},
            dataType: 'json',
            success: function(json) {
                if (json.error == true)
                {
                    showError(json.msg, 'popupMessageContainer');
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable();
                    hideModal();
                }

            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                showError(textStatus+': '+errorThrown, 'popupMessageContainer');
            }
        });

    }
</script>

<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        
<div class="row clearfix">
    <div class="x_panel">
        <div class="x_title"><h2>Categories</h2><div class="clearfix"></div></div>
        <div class="x_content responsiveTable">
            <?php

echo adminFunctions::compileNotifications();

?>
            <div class="col_12">
                <table id='fileTable' class='table table-striped table-only-border dtLoading bulk_action'>
                    <thead>
                        <tr>
                            <th></th>
                            <th class="align-left">Category Name</th>
                            <th class="align-left">Url Part</th>
                            <th class="align-left">Total Images</th>
                            <th class="align-left">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <div class="clear"></div>
        
        </div>
    </div>
    <div class="x_panel">
        <div class="btn-group">
            <a href="#" type="button" class="btn btn-default" onClick="addCategory(); return false;">Add Category</a>
        </div>
    </div>
</div>

    </div>
</div>



<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        Filter Results:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable(); return false;" class="form-control"/>
    </label>
</div>

<div id="editCategoryForm" title="Edit Category">
    <span id="editCategoryFormInner"></span>
</div>

<?php

include_once (ADMIN_ROOT . '/_footer.inc.php');

?>