<?php

// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

// setup database
$db = Database::getDatabase(true);

// load folder structure as array
$folderListing = fileFolder::loadAllForSelect($Auth->id);

// initial parent folder
$parentId = '-1';
if(isset($_REQUEST['parentId']))
{
    $parentId = (int)$_REQUEST['parentId'];
}

// defaults
$isPublic = 2;
$editFolderId = null;
$accessPassword = null;
$coverImageId = null;
$coverImageUrl = '';
if((int)$_REQUEST['editFolderId'])
{
    // load existing folder data
    $fileFolder = fileFolder::loadById((int)$_REQUEST['editFolderId']);
    if ($fileFolder)
    {
		// load the album url
		$pageUrl = $fileFolder->getAlbumUrl();
		
        // check current user has permission to edit the fileFolder
        if ($fileFolder->userId == $Auth->id)
        {
            // setup edit folder
            $editFolderId = $fileFolder->id;
            $folderName = $fileFolder->folderName;
            $parentId = $fileFolder->parentId;
            $isPublic = $fileFolder->isPublic;
            $accessPassword = $fileFolder->accessPassword;
			$coverImageId = (int)$fileFolder->coverImageId;
			if($coverImageId)
			{
				$coverImageFile = file::loadById($coverImageId);
				if(($coverImageFile) && ($coverImageFile->statusId == 1))
				{
					$coverImageUrl = $coverImageFile->getFullShortUrl();
				}
			}
        }
    }
}

$userIsPublic   = 1;
$folderIsPublic = 1;
$globalPublic   = 1;

if(coreFunctions::getUserPublicStatus($Auth->id) === false)
{
    $userIsPublic = 0;
}

if(corefunctions::getUserFoldersPublicStatus($editFolderId) === false || corefunctions::getUserFoldersPublicStatus($parentId) === false)
{
    $folderIsPublic = 0;
}

if(corefunctions::getOverallSitePrivacyStatus() === false)
{
    $globalPublic = 0;
}

?>

<form action="<?php echo WEB_ROOT; ?>/ajax/_account_add_edit_folder.process.ajax.php" autocomplete="off">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title"><?php echo $editFolderId==null?t("add_album", "add album"):(t("edit_existing_album", "Edit Existing Album").' ('.validation::safeOutputToScreen($fileFolder->folderName).')'); ?></h4>
    </div>

    <div class="modal-body">
        
        <?php if($editFolderId !== null): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="folderName" class="control-label"><?php echo t('edit_folder_sharing_url', 'Sharing Url:'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" value="<?php echo validation::safeOutputToScreen($pageUrl); ?>" readonly/>
                        <span class="input-group-btn">
                            <button type="button" class="btn btn-primary" onClick="window.open('<?php echo validation::safeOutputToScreen($pageUrl); ?>'); return false;"><i class="entypo-link"></i></button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="folderName" class="control-label"><?php echo t("edit_album_name", "Album Name:"); ?></label>
                    <input type="text" class="form-control" name="folderName" id="folderName" value="<?php echo isset($folderName) ? validation::safeOutputToScreen($folderName) : ''; ?>"/>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="parentId" class="control-label"><?php echo t('edit_folder_parent_album', 'Parent Album:'); ?></label>
                    <select class="form-control" name="parentId" id="parentId">
                        <option value="-1"><?php echo t('_none_', '- none -'); ?></option>
                        <?php
                        $currentFolderStr = $editFolderId!==null?$folderListing[$editFolderId]:0;
                        foreach ($folderListing AS $k => $folderListingItem)
                        {
                            if($editFolderId !== null)
                            {
                                // ignore this folder and any children
                                if(substr($folderListingItem, 0, strlen($currentFolderStr)) == $currentFolderStr)
                                {
                                    continue;
                                }
                            }
                            
                            echo '<option value="' . (int) $k . '"';
                            if ($parentId == (int) $k)
                            {
                                echo ' SELECTED';
                            }
                            echo '>' . validation::safeOutputToScreen($folderListingItem) . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
        </div>
		
		<div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="coverImageUrl" class="control-label"><?php echo t("edit_album_cover_image_description", "Cover Image: (Url of the Image in Your Account)"); ?></label>
					<div class="input-group">
						<input type="text" class="form-control" name="coverImageUrl" id="coverImageUrl" value="<?php echo strlen($coverImageUrl) ? validation::safeOutputToScreen($coverImageUrl) : ''; ?>"/>
						<span class="input-group-btn">
                            <button type="button" class="btn btn-primary" onClick="if($('#coverImageUrl').val().length > 0) { window.open($('#coverImageUrl').val()); } return false;"><i class="entypo-search"></i></button>
                        </span>
					 </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="isPublic" class="control-label"><?php echo t('edit_album_privacy', 'Album Privacy:'); ?></label>
                    <?php if($userIsPublic == 0): ?>
                    <select class="form-control" name="isPublic" id="isPublic" disabled="disabled">
                    <?php else: ?>                    
                    <select class="form-control" name="isPublic" id="isPublic">
                    <?php endif; ?>
						<option value="1" <?php echo ($folderIsPublic == 1) ? 'SELECTED' : ''; ?>><?php echo t('privacy_public_limited_access', 'Public Limited - access only if users know the sharing link.'); ?></option>
                        <option value="2" <?php echo $isPublic == 2 ? 'SELECTED' : ''; ?>><?php echo t('privacy_yes_allow_public', 'Public - listed on the site and within search results.'); ?></option>
                        <option value="0" <?php echo (($folderIsPublic == 0 || ($userIsPublic == 0 && $folderIsPublic == 1)) ? ' selected' : '') ? 'SELECTED' : ''; ?>><?php echo t('privacy_private_no_access', 'Private - no access outside of your account.'); ?></option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="accessPassword" class="control-label"><?php echo t("edit_album_optional_password", "Optional Password:"); ?></label>
                    <div class="row">
                        <div class="col-md-2 inline-checkbox">
                            <input type="checkbox" name="enablePassword" id="enablePassword" value="1" <?php echo strlen($accessPassword)?'CHECKED':''; ?> onClick="toggleFolderPasswordField();">
                        </div>
                        <div class="col-md-10">
                            <input type="password" class="form-control" name="password" id="password" autocomplete="off"<?php echo strlen($accessPassword)?' value="**********"':''; ?> <?php echo strlen($accessPassword)?'':'READONLY'; ?>/>
                        </div>
                    </div>
                </div>
            </div>
			
			<?php if($userIsPublic == 0): ?>
			<div class="col-md-12">
                <div class="form-group">
                    <p>
                    <?php
                     echo t('edit_album_privacy_notice_note', 'Note: You can not update this album privacy settings as your account settings are set to make all files private, or the parent folder is set to private.');
                    ?>
					</p>
                </div>
            </div>
			<?php endif; ?>
        </div>
    </div>

    <div class="modal-footer">
        <input type="hidden" name="submitme" id="submitme" value="1"/>
        <?php if($editFolderId !== null): ?>
        <input type="hidden" value="<?php echo (int) $editFolderId; ?>" name="editFolderId"/>
        <?php endif; ?>
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo t("cancel", "cancel"); ?></button>
        <button type="button" class="btn btn-info" onClick="processAjaxForm(this, function(data) { <?php if($editFolderId == null): ?>setUploaderFolderList(data['folder_listing_html']);loadImages(data['folder_id']);<?php endif; ?>refreshFolderListing(); $('.modal').modal('hide'); updateStatsViaAjax(); }); return false;"><?php echo $editFolderId==null?t("add_album", "add album"):t("update_album", "update album"); ?> <i class="entypo-check"></i></button>
    </div>
</form>