<?php
// load script options
define('PRE_CACHE_NEXT_IMAGE', true);
define('PRE_CACHE_PREV_IMAGE', true);

// for failed auth
$javascript = '';

// load file
$userOwnsFile = false;
$album = null;
if(isset($_REQUEST['u']))
{
    $file = file::loadById($_REQUEST['u']);
    if(!$file)
    {
        // failed lookup of file
        $returnJson = array();
        $returnJson['html'] = 'File not found.';
        $returnJson['javascript'] = 'window.location = "' . WEB_ROOT . '";';
        echo json_encode($returnJson);
        exit;
    }

    // load album for later
    if($file->folderId !== NULL)
    {
        $album = $file->getFolderData();
    }

    // check current user has permission to view the image
    if(($file->userId != $Auth->id) && ($Auth->level_id < 10))
    {
        // if this is a private file
        if(coreFunctions::getOverallPublicStatus($file->userId, $file->folderId, $file->id) == false)
        {
            // output response
            $returnJson['html'] = '<div class="ajax-error-image"><!-- --></div>';
            $returnJson['page_title'] = UCWords(t('error', 'Error'));
            $returnJson['page_url'] = '';
            $returnJson['javascript'] = 'showErrorNotification("' . str_replace("\"", "'", UCWords(t('error', 'Error'))) . '", "' . str_replace("\"", "'", t('image_is_not_publicly_shared_please_contact', 'Image is not publicly shared. Please contact the owner and request they update the privacy settings.')) . '");';
            echo json_encode($returnJson);
            exit;
        }

        // check if album needs a password
        if(($album) && (strlen($album->accessPassword) > 0))
        {
            // see if we have it in the session already
            $askPassword = true;
            if(!isset($_SESSION['folderPassword']))
            {
                $_SESSION['folderPassword'] = array();
            }
            elseif(isset($_SESSION['folderPassword'][$album->id]))
            {
                if($_SESSION['folderPassword'][$album->id] == $album->accessPassword)
                {
                    $askPassword = false;
                }
            }

            if($askPassword == true)
            {
                // output response
                $returnJson['html'] = '<div class="ajax-error-image"><!-- --></div><div id="albumPasswordModel" data-backdrop="static" data-keyboard="false" class="albumPasswordModel modal fade custom-width general-modal"><div class="modal-dialog"><div class="modal-content"><form id="folderPasswordForm" action="' . WEB_ROOT . '/ajax/_album_password.process.ajax.php" autocomplete="off" onSubmit="$(\'#password-submit-btn\').click(); return false;"><div class="modal-body">';

                $returnJson['html'] .= '<div class="row">';
                $returnJson['html'] .= '	<div class="col-md-4">';
                $returnJson['html'] .= '		<div class="tile-title tile-orange"> <div class="icon"> <i class="glyphicon glyphicon-lock"></i> </div> <div class="title"> <h3>' . t('password_protected', 'Password Protected') . '</h3> <p></p> </div> </div>';
                $returnJson['html'] .= '	</div>';
                $returnJson['html'] .= '	<div class="col-md-8">';
                $returnJson['html'] .= '		<h4>' . t('password_required', 'Password Required') . '</h4><hr style="margin-top: 5px;"/>';
                $returnJson['html'] .= '		<div class="form-group">';
                $returnJson['html'] .= '			<p>' . t('this_folder_has_a_password_set', 'This folder requires a password to gain access. Use the form below to enter the password, then click "unlock".') . '</p>';
                $returnJson['html'] .= '		</div>';

                $returnJson['html'] .= '		<div class="form-group">';
                $returnJson['html'] .= '			<label for="folderName" class="control-label">' . UCWords(t('access_password', 'Access Password')) . ':</label>';
                $returnJson['html'] .= '			<div class="input-grsoup">';
                $returnJson['html'] .= '				<input type="password" name="folderPassword" id="folderPassword" class="form-control" placeholder="************"/>';
                $returnJson['html'] .= '			</div>';
                $returnJson['html'] .= '		</div>';
                $returnJson['html'] .= '	</div>';
                $returnJson['html'] .= '</div>';

                $returnJson['html'] .= '</div><div class="modal-footer" style="margin-top: 0px;">';
                $returnJson['html'] .= '<input type="hidden" value="' . (int) $album->id . '" id="folderId" name="folderId"/>';
                $returnJson['html'] .= '<input type="hidden" value="1" id="submitme" name="submitme"/>';
                $returnJson['html'] .= '<button type="button" class="btn btn-default" data-dismiss="modal">' . t('cancel', 'Cancel') . '</button>';
                $returnJson['html'] .= '<button type="button" class="btn btn-info" id="password-submit-btn" onClick="processAjaxForm(this, function() { $(\'.modal\').modal(\'hide\'); $(\'.modal-backdrop\').remove(); showImage(' . (int) $file->id . '); }); return false;">' . t('unlock', 'Unlock') . ' <i class="entypo-check"></i></button>';
                $returnJson['html'] .= '</div></form></div></div></div>';
                $returnJson['javascript'] = "jQuery('.albumPasswordModel').modal('show');";
                $returnJson['page_title'] = $pageTitle;
                $returnJson['page_url'] = $pageUrl;
                echo json_encode($returnJson);
                exit;
            }
        }
    }
    else
    {
        if($Auth->loggedIn() && $file->userId == $Auth->id)
        {
            $userOwnsFile = true;
        }
    }
}
else
{
    $returnJson = array();
    $returnJson['html'] = 'No access.';
    $returnJson['javascript'] = 'window.location = "' . WEB_ROOT . '";';
    echo json_encode($returnJson);
    exit;
}

// update stats
$rs = Stats::track($file, $file->id);
if($rs)
{
    $file->updateLastAccessed();
}

// load image meta data
$imageWidth = 0;
$imageHeight = 0;
$imageRawData = '';
$imageDateTaken = $file->uploadedDate;
$foundMeta = false;
$imageData = $db->getRow('SELECT width, height, raw_data, date_taken FROM plugin_imageviewer_meta WHERE file_id = ' . (int) $file->id . ' LIMIT 1');
if($imageData)
{
    $imageWidth = (int) $imageData['width'];
    $imageHeight = (int) $imageData['height'];
    $imageRawData = trim($imageData['raw_data']);
    $imageDateTaken = $imageData['date_taken'];
    $foundMeta = true;
}

// setup max sizes
$maxImagePreviewWidth = 1100;
$maxImagePreviewHeight = 1100;
if(($imageWidth > 0) && ($imageWidth < $maxImagePreviewWidth))
{
    $maxImagePreviewWidth = $imageWidth;
}
if(($imageHeight > 0) && ($imageHeight < $maxImagePreviewHeight))
{
    $maxImagePreviewHeight = $imageHeight;
}

$imageRawDataArr = array();
if(strlen($imageRawData))
{
    $imageRawDataArr = json_decode($imageRawData, true);
    if(!$imageRawDataArr)
    {
        $imageRawDataArr = array();
    }
}

// get image viewer & comment object
$imageViewerObj = pluginHelper::getInstance('imageviewer');
$commentObj = pluginHelper::getInstance('comments');

// load image viewer plugin details
$pluginDetails = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginConfig = $pluginDetails['config'];
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// get image colors
$imageColorsArr = $imageViewerObj->getImageColors($file->id);

// get album details
$coverId = null;
if($album)
{
    $coverData = fileFolder::getFolderCoverData($album->id);
    $coverId = $coverData['file_id'];
    $coverUniqueHash = $coverData['unique_hash'];
}

// get owner details
$owner = null;
if((int) $file->userId)
{
    $owner = UserPeer::loadUserById($file->userId);
}

// check whether the current logged in user has liked this file
$isLiked = false;
if($Auth->loggedIn())
{
    $isLiked = (bool) $db->getValue('SELECT COUNT(id) AS total FROM plugin_imageviewer_image_like WHERE file_id = ' . (int) $file->id . ' AND user_id = ' . (int) $Auth->id . ' LIMIT 1');
}

// get next and previous file
$themeObj = themeHelper::getLoadedInstance();
$similarImages = $themeObj->getSimilarImages($file);
$totalImages = COUNT($similarImages);
$prev = null;
$next = null;
if($totalImages)
{
    // find index of currently selected
    $selectedIndex = null;
    foreach($similarImages AS $k => $similarImage)
    {
        if($similarImage->id == $file->id)
        {
            $selectedIndex = $k;
        }
    }

    if((int) $selectedIndex >= 1)
    {
        $prev = $similarImages[$selectedIndex - 1]->id;
    }

    if((int) $selectedIndex < ($totalImages - 1))
    {
        $next = $similarImages[$selectedIndex + 1]->id;
    }
}

// public status
$isPublic = 1;
if(coreFunctions::getOverallPublicStatus($file->userId, $file->folderId, $file->id) == false)
{
    $isPublic = 0;
}

// load public category
$imageCategory = $db->getRow('SELECT label, `key` FROM plugin_imageviewer_category WHERE id IN (SELECT category_id FROM plugin_imageviewer_category_file WHERE file_id = ' . (int) $file->id . ') LIMIT 1');

// do PPV logging, if enabled
pluginHelper::includeAppends('class_inline_file_count_ppd.php', array('fileOwnerUserId' => $Auth->id, 'userLevelId' => $Auth->level_id, 'file' => $file));
?>

<?php
ob_start();
?>

<div class="file-browse-container-wrapper">
    <div class="file-preview-wrapper">
        <div class="row">
            <div class="col-md-9">
                <?php if($file->statusId == 1): ?>
                    <div class="section-wrapper image-preview-wrapper">
                        <?php if($prev !== null): ?>
                            <a href="#" class="prev-link" onClick="showImage(<?php echo (int) $prev; ?>); return false;"><i class="entypo-left-open-big"></i></a>
                        <?php endif; ?>

                        <?php if($next !== null): ?>
                            <a href="#" class="next-link" onClick="showImage(<?php echo (int) $next; ?>); return false;"><i class="entypo-right-open-big"></i></a>
                        <?php endif; ?>

                        <?php
                        $imageLink = file::getIconPreviewImageUrl((array) $file, false, 160, false, 1100, 1100, 'cropped');
                        $fullScreenWidth = 1100;
                        $fullScreenHeight = 1100;
                        if(($imageWidth == 0) || ($imageHeight == 0))
                        {
                            if($foundMeta == true)
                            {
                                $size = @getimagesize($imageLink);
                                if($size)
                                {
                                    if((int) $size[0] && (int) $size[1])
                                    {
                                        $fullScreenWidth = (int) $size[0];
                                        $fullScreenHeight = (int) $size[1];

                                        // update size value in the database for next time
                                        $imageData = $db->query('UPDATE plugin_imageviewer_meta SET width = ' . (int) $fullScreenWidth . ', height = ' . (int) $fullScreenHeight . ' WHERE file_id = ' . (int) $file->id . ' LIMIT 1');
                                    }
                                }
                            }
                        }
                        else
                        {
                            $fullScreenWidth = $imageWidth;
                            $fullScreenHeight = $imageHeight;
                        }
                        ?>
                        <div class="image">
                            <div class="image-fullscreen-link">
                                <a href="#" onClick="showFullScreen('<?php echo $imageLink; ?>', <?php echo (int) $fullScreenWidth; ?>, <?php echo (int) $fullScreenHeight; ?>); return false;"><i class="entypo-resize-full"></i></a>
                            </div>
                            <img src="<?php echo $imageLink; ?>" class="image-preview"/>
                        </div>
                    </div>
                    <div class="clear"></div>
                <?php endif; ?>

                <div class="section-wrapper">
                    <?php if($isPublic == true): ?>
                        <div class="image-social-sharing">
                            <div class="row mobile-social-share">
                                <div id="socialHolder">
                                    <div id="socialShare" class="btn-group share-group">
                                        <a data-toggle="dropdown" class="btn btn-info">
                                            <i class="entypo-share"></i>
                                        </a>
                                        <button href="#" data-toggle="dropdown" class="btn btn-info dropdown-toggle share">
                                            <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a href="https://twitter.com/intent/tweet?url=<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>&text=<?php echo validation::safeOutputToScreen($file->originalFilename); ?>" data-original-title="Twitter" data-toggle="tooltip" href="#" class="btn btn-twitter" data-placement="left" target="_blank">
                                                    <i class="fa fa-twitter"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>" data-original-title="Facebook" data-toggle="tooltip" href="#" class="btn btn-facebook" data-placement="left" target="_blank">
                                                    <i class="fa fa-facebook"></i>
                                                </a>
                                            </li>					
                                            <li>
                                                <a href="https://plus.google.com/share?url=<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>" data-original-title="Google+" data-toggle="tooltip" href="#" class="btn btn-google" data-placement="left" target="_blank">
                                                    <i class="fa fa-google-plus"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>" data-original-title="LinkedIn" data-toggle="tooltip" href="#" class="btn btn-linkedin" data-placement="left" target="_blank">
                                                    <i class="fa fa-linkedin"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="http://pinterest.com/pin/create/button/?url=<?php echo validation::safeOutputToScreen($file->getFullShortUrl()); ?>" data-original-title="Pinterest" data-toggle="tooltip" class="btn btn-pinterest" data-placement="left" target="_blank">
                                                    <i class="fa fa-pinterest"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="image-name-title">
                        <?php echo validation::safeOutputToScreen($file->originalFilename); ?>
                    </div>
                    <div class="clear"></div>
                    <div class="similar-images"><!-- --></div>
                </div>

                <div class="section-wrapper">
                    <?php pluginHelper::includeAppends('file_download_bottom_extra_image_hosting.php', array('file' => $file)); ?>
                </div>
            </div>
            <div class="col-md-3">
                <?php if($owner !== null): ?>
                    <div class="section-wrapper">
                        <?php if($coverId): ?>
                            <?php
                            $albumCoverFile = file::loadById($coverId);
                            $albumCoverLink = file::getIconPreviewImageUrl((array) $albumCoverFile, false, 64, false, 280, 280, 'middle');
                            ?>
                            <a href="#" onClick="loadImages(<?php echo (int) $album->id; ?>); return false;"><img width="60" height="60" class="img-rounded" alt="<?php echo validation::safeOutputToScreen($owner->getAccountScreenName()); ?>" src="<?php echo $albumCoverLink; ?>"/></a>
                            <span class="text-section">
                                <a href="#" class="text-section-1" onClick="loadImages(<?php echo (int) $album->id; ?>); return false;"><?php echo validation::safeOutputToScreen($album->folderName); ?></a>
                                <?php echo t('profile_by', 'by'); ?>
                                <a href="<?php echo validation::safeOutputToScreen($owner->getProfileUrl()); ?>" class="text-section-2"><?php echo validation::safeOutputToScreen($owner->getAccountScreenName()); ?></a>
                            </span>
                        <?php else: ?>
                            <a href="#" onClick="loadImages(<?php echo (int) $album->id; ?>); return false;"><img width="60" class="img-rounded" alt="<?php echo validation::safeOutputToScreen($owner->getAccountScreenName()); ?>" src="<?php echo WEB_ROOT; ?>/page/view_avatar.php?id=<?php echo (int) $file->userId; ?>&width=60&height=60"/></a>
                            <span class="text-section">
                                <a href="<?php echo validation::safeOutputToScreen($owner->getProfileUrl()); ?>" class="text-section-2"><?php echo validation::safeOutputToScreen($owner->getAccountScreenName()); ?>
                                </a>
                            </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="section-wrapper">
                    <table class="table table-bordered table-striped file-details-properties">
                        <tbody>
                            <?php if(strlen($file->description)): ?>
                            <tr>
                                <td class="view-file-details-first-row">
                                    <?php echo UCWords(t('description', 'description')); ?>:
                                </td>
                                <td class="responsiveTable">
                                    <?php echo validation::safeOutputToScreen($file->description); ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td class="view-file-details-first-row">
                                    <?php echo UCWords(t('uploaded', 'uploaded')); ?>:
                                </td>
                                <td class="responsiveTable">
                                    <?php echo coreFunctions::formatDate($file->uploadedDate); ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="view-file-details-first-row">
                                    <?php echo UCWords(t('filesize', 'filesize')); ?>:
                                </td>
                                <td class="responsiveTable">
                                    <?php echo coreFunctions::formatSize($file->fileSize); ?>
                                </td>
                            </tr>
                            
                            <?php
                            $keywords = $file->getKeywordArray();
                            if(COUNT($keywords)):
                            ?>
                            <tr>
                                <td class="view-file-details-first-row">
                                    <?php echo UCWords(t('keywords', 'keywords')); ?>:
                                </td>
                                <td class="responsiveTable">
                                    <?php
                                    foreach($keywords AS $keyword)
                                    {
                                        echo '<a class="badge" href="'.WEB_ROOT.'/search/?s=image&filterImagesAll=true&filterUploadedDateRange=&t='.validation::safeOutputToScreen($keyword).'">';
                                        echo validation::safeOutputToScreen($keyword);
                                        echo '</a>';
                                    }
                                    ?>
                                </td>
                            </tr>
                            <?php
                            endif;
                            ?>

                            <?php if($imageCategory): ?>
                                <tr>
                                    <td class="view-file-details-first-row">
                                        <?php echo UCWords(t('public_category', 'public category')); ?>:
                                    </td>
                                    <td class="responsiveTable">
                                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/<?php echo validation::safeOutputToScreen($imageCategory['key']); ?>"><?php echo validation::safeOutputToScreen($imageCategory['label']); ?></a>
                                    </td>
                                </tr>
                            <?php endif; ?>

                            <?php if($userOwnsFile == true): ?>
                                <tr>
                                    <td class="view-file-details-first-row">
                                        <?php echo UCWords(t('sharing', 'Sharing')); ?>:
                                    </td>
                                    <td class="responsiveTable">
                                        <?php echo ($isPublic == true) ? '<i class="entypo-lock-open"></i>' : '<i class="entypo-lock"></i>'; ?>
                                        <?php echo ($isPublic == true) ? t('public_file', 'Public File - Can be Shared') : t('private_file', 'Private File - Only Available via Your Account'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>

                            <?php if($file->statusId != 1): ?>
                                <tr>
                                    <td class="view-file-details-first-row">
                                        <?php echo UCWords(t('status', 'status')); ?>:
                                    </td>
                                    <td class="responsiveTable">
                                        <?php echo validation::safeOutputToScreen(UCWords(file::getStatusLabel($file->statusId))); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>

                            <?php if(COUNT($imageColorsArr)): ?>
                                <tr>
                                    <td class="view-file-details-first-row">
                                        <?php echo UCWords(t('color_palette', 'Color Palette')); ?>:
                                    </td>
                                    <td class="responsiveTable">
                                        <div class="image-colors-wrapper">
                                            <?php
                                            foreach($imageColorsArr AS $imageColorsArrItem)
                                            {
                                                echo '<div style="background-color: ' . validation::safeOutputToScreen($imageColorsArrItem) . '" data-original-title="' . validation::safeOutputToScreen($imageColorsArrItem) . '" data-placement="bottom" data-toggle="tooltip"></div>';
                                            }
                                            ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php
                // links
                $links = array();
                if($userOwnsFile == true)
                {
                    if($file->statusId == 1)
                    {
                        $links[] = '<button type="button" class="btn btn-default" data-dismiss="modal" onClick="showEditFileForm(' . (int) $file->id . '); return false;" title="" data-original-title="' . addslashes(UCWords(t('account_file_details_edit_image', 'Edit Image'))) . '" data-placement="bottom" data-toggle="tooltip"><i class="entypo-pencil"></i></button>';
                        $links[] = '<button type="button" class="btn btn-default" data-dismiss="modal" onClick="deleteFile(' . (int) $file->id . '); return false;" title="" data-original-title="' . addslashes(UCWords(t('account_file_details_delete_image', 'Delete Image'))) . '" data-placement="bottom" data-toggle="tooltip"><i class="entypo-trash"></i></button>';
                    }
                }

                // make sure user is permitted to view stats
                if($file->canViewStats() == true)
                {
                    $links[] = '<button type="button" class="btn btn-default" onClick="openUrl(\'' . validation::safeOutputToScreen($file->getStatisticsUrl()) . '\'); return false;" title="" data-original-title="' . addslashes(UCWords(t('account_file_details_image_stats', 'Image Stats'))) . '" data-placement="bottom" data-toggle="tooltip"><i class="entypo-chart-line"></i></button>';
                }

                if(($userOwnsFile == true) || ((int) $pluginSettings['show_download_link'] == 1))
                {
                    if($file->statusId == 1)
                    {
                        // whether to allow downloads or not if the user is not logged in
                        if((!$Auth->loggedIn()) && (SITE_CONFIG_REQUIRE_USER_ACCOUNT_DOWNLOAD == 'yes'))
                        {
                            $downloadLinks = '<button type="button" class="btn btn-info" onClick="alert(\'' . t('register_for_an_account_to_download', 'Please register for an account to download this file.') . '\');">' . addslashes(UCWords(t('account_file_details_download', 'Download'))) . '&nbsp;&nbsp;<i class="entypo-down"></i> </button>';
                        }
                        else
                        {
                            $downloadLinks = '<button type="button" class="btn btn-info" data-toggle="dropdown">' . addslashes(UCWords(t('account_file_details_download', 'Download'))) . '</button> <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"> <i class="entypo-down"></i> </button>';
                            $downloadLinks .= '<ul class="dropdown-menu dropdown-info account-dropdown-resize-menu" role="menu">';
                            $downloadLinks .= '<li><a href="#" onClick="triggerFileDownload(' . (int) $file->id . ', \'' . $file->getFileHash() . '\'); return false;"><i class="entypo-right"></i>' . strtoupper($file->extension) . ' ' . t('account_file_details_original', 'Original') . '</a> </li>';

                            // add jpg version if the original isn't jpg
                            //if($file->extension != 'jpg')
                            //{
                            //$downloadLinks .= '<li><a href="'.$file->getFileServerPath() . '/' . PLUGIN_DIRECTORY_NAME.'/imageviewer/site/resize_image.php?uh='.$file->getFileHash().'&f='.(int) $file->id.'&w=1100&h=1100"><i class="entypo-right"></i>JPG '.t('account_file_details_version', 'Version').'</a> </li>';
                            //}
                            // add resize links
                            if((int) $pluginSettings['show_download_sizes'] == 1)
                            {
                                // skip if we don't have the image dimentions
                                if(($imageWidth > 0) && ($imageHeight > 0))
                                {
                                    $downloadLinks .= '<li class="divider"></li>';
                                    rsort($pluginConfig['scaledPercentages']);
                                    foreach($pluginConfig['scaledPercentages'] AS $percentage)
                                    {
                                        $linkWidth = ceil(($imageWidth / 100) * $percentage);
                                        $linkHeight = ceil(($imageHeight / 100) * $percentage);

                                        if(($linkWidth <= PluginImageviewer::HOLDING_CACHE_SIZE) && ($linkHeight <= PluginImageviewer::HOLDING_CACHE_SIZE))
                                        {
                                            $downloadLinks .= '<li><a href="' . $file->getFileServerPath() . '/' . PLUGIN_DIRECTORY_NAME . '/imageviewer/site/resize_image.php?uh=' . $file->getFileHash() . '&f=' . (int) $file->id . '&w=' . $linkWidth . '&h=' . $linkHeight . '"><i class="entypo-right"></i>JPG ' . $linkWidth . ' x ' . $linkHeight . ' px</a> </li>';
                                        }
                                    }
                                }
                            }
                            $downloadLinks .= '</ul>';
                        }

                        $links[] = $downloadLinks;
                    }
                }

                if($album != null)
                {
                    $links[] = '<button type="button" class="btn btn-default" onClick="openUrl(\'' . validation::safeOutputToScreen(coreFunctions::getCoreSitePath() . '/slideshow/' . (int) $album->id . '/' . $album->getSafeFoldernameForUrl()) . '\', true); return false;" title="" data-original-title="' . addslashes(UCWords(t('account_file_play_slideshow', 'Play Slideshow'))) . '" data-placement="bottom" data-toggle="tooltip"><i class="entypo-play"></i></button>';
                }
                ?>

                <div class="section-wrapper">
                    <div class="button-wrapper responsiveMobileAlign">
                        <div class="first-row">
                            <a href="#" onClick="scrollToComments(); return false;" class="btn btn-default" data-original-title="<?php echo addslashes(UCWords(t('account_file_details_view_comments', 'Click to view comments'))); ?>" data-placement="bottom" data-toggle="tooltip"><i class="entypo-chat"></i> <?php echo UCWords(t('comments', 'comments')); ?> (<?php echo (int) $commentObj->getTotalActiveComments($file); ?>)</a>
                            <a href="<?php echo ($file->canViewStats() == true) ? (validation::safeOutputToScreen($file->getStatisticsUrl()) . '" target="_blank"') : '#"'; ?> data-original-title="<?php echo ($file->lastAccessed != null) ? ('(' . UCWords(t('last_accessed', 'last accessed')) . ': ' . coreFunctions::formatDate($file->lastAccessed) . ')') : ''; ?>" class="btn btn-default" data-placement="bottom" data-toggle="tooltip"><?php echo validation::safeOutputToScreen($file->visits); ?> <?php echo UCWords(t('views', 'views')); ?></a>
                            <a href="#" onClick="likeImage(<?php echo (int) $file->id; ?>); return false;" class="btn btn-default like-btn<?php echo $isLiked ? ' image-liked' : ''; ?>" data-original-title="<?php echo addslashes(UCWords(t('account_file_details_likes', 'Like this image'))); ?>" data-placement="bottom" data-toggle="tooltip"><i class="entypo-heart"></i> <span id="likeCount"><?php echo (int) $imageViewerObj->getTotalLikes($file); ?></span> <?php echo UCWords(t('likes', 'likes')); ?></a>
                        </div>

<?php if(COUNT($links)): ?>
                            <?php foreach($links AS $link): ?>
                                <div class="btn-group responsiveMobileMargin">
                                <?php echo $link; ?>
                                </div>
                                <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

<?php if($file->statusId == 1): ?>
                    <div role="tabpanel">
                        <ul class="nav nav-tabs file-info-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#details" aria-controls="details" role="tab" data-toggle="tab"><i class="entypo-share"></i><span> <?php echo UCWords(t("sharing_code", "sharing code")); ?></span></a></li>
                            <li role="presentation"><a href="#send-via-email" aria-controls="send-via-email" role="tab" data-toggle="tab"><i class="entypo-mail"></i><span> <?php echo UCWords(t("email", "email")); ?></span></a></li>
    <?php if(COUNT($imageRawDataArr)): ?>
                                <li role="presentation"><a href="#image-data" aria-controls="image-data" role="tab" data-toggle="tab"><i class="entypo-info-circled"></i><span> <?php echo UCWords(t("meta", "Meta")); ?></span></a></li>
                            <?php endif; ?>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="details">
                                <h4><strong><?php echo t('image_page_link', 'Image Page Link'); ?></strong></h4>
                                <pre><section onClick="selectAllText(this); return false;"><?php echo $file->getFullShortUrl(); ?></section></pre>

    <?php if((int) $pluginSettings['show_embedding'] != 1): ?>
                                    <h4><strong><?php echo t('html_code', 'HTML Code'); ?></strong></h4>
                                    <pre><section onClick="selectAllText(this); return false;"><?php echo $file->getHtmlLinkCode(); ?></section></pre>

                                    <h4><strong><?php echo UCWords(t('forum_code', 'forum code')); ?></strong></h4>
                                    <pre><section onClick="selectAllText(this); return false;"><?php echo $file->getForumLinkCode(); ?></section></pre>
    <?php else: ?>
                                    <h4><strong><?php echo UCWords(t('html_code', 'HTML Code')); ?></strong></h4>
                                    <pre><section onClick="selectAllText(this); return false;">&lt;a href=&quot;<?php echo $file->getFullShortUrl(); ?>&quot; target=&quot;_blank&quot; title=&quot;<?php echo t('view_on', 'View on'); ?> <?php echo SITE_CONFIG_SITE_NAME; ?>&quot;&gt;&lt;img src=&quot;<?php echo $file->getFileServerPath(); ?>/plugins/imageviewer/site/thumb.php?s=<?php echo $file->shortUrl; ?>&amp;/<?php echo $file->getSafeFilenameForUrl(); ?>&quot;/&gt;&lt;/a&gt;</section></pre>

                                    <h4><strong><?php echo UCWords(t('forum_code', 'Forum Code')); ?></strong></h4>
                                    <pre><section onClick="selectAllText(this); return false;">[URL=<?php echo $file->getFullShortUrl(); ?>][IMG]<?php echo $file->getFileServerPath(); ?>/plugins/imageviewer/site/thumb.php?s=<?php echo $file->shortUrl; ?>&/<?php echo $file->getSafeFilenameForUrl(); ?>[/IMG][/URL]</section></pre>
    <?php endif; ?>

                                <?php if((int) $pluginSettings['show_direct_link'] == 1): ?>
                                    <h4><strong><?php echo UCWords(t('direct_image_link', 'Direct Image Link')); ?></strong></h4>
                                    <pre><section onClick="selectAllText(this); return false;"><?php echo $file->getFileServerPath(); ?>/plugins/imageviewer/site/direct.php?s=<?php echo $file->shortUrl; ?>&/<?php echo $file->getSafeFilenameForUrl(); ?></section></pre>
    <?php endif; ?>
                            </div>

                            <div role="tabpanel" class="tab-pane" id="send-via-email">
                                <div class="row">
                                    <form action="<?php echo WEB_ROOT; ?>/ajax/_account_file_details_send_email.process.ajax.php" autocomplete="off">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <p><?php echo t('account_file_details_intro_user_the_form_below_send_email', 'Use the form below to share this file via email. The recipient will receive a link to download the file.'); ?></p>
    <?php if($isPublic == false): ?>
                                                    <div class="alert alert-danger"><?php echo t('account_file_details_album_not_publicly_shared', 'This image is not publicly shared. You will need to make it public before the recipient can view it.'); ?></div>
                                                <?php endif; ?>
                                            </div>

                                            <div class="form-group">
                                                <label class="control-label" for="shareRecipientName"><?php echo UCWords(t("recipient_name", "recipient full name")); ?>:</label>
                                                <input type="text" id="shareRecipientName" name="shareRecipientName" class="form-control"/>
                                            </div>

                                            <div class="form-group">
                                                <label class="control-label" for="shareEmailAddress"><?php echo UCWords(t("recipient_email_address", "recipient email address")); ?>:</label>
                                                <input type="text" id="shareEmailAddress" name="shareEmailAddress" class="form-control"/>
                                            </div>

                                            <div class="form-group">
                                                <label class="control-label" for="shareExtraMessage"><?php echo UCWords(t("extra_message", "extra message")); ?>:</label>
                                                <textarea id="shareExtraMessage" name="shareExtraMessage" class="form-control"></textarea>
                                            </div>

                                            <div class="form-group">
                                                <input type="hidden" name="submitme" id="submitme" value="1"/>
                                                <input type="hidden" value="<?php echo (int) $file->id; ?>" name="fileId"/>
                                                <button type="button" class="btn btn-info" onClick="processAjaxForm(this, function () {
                                                                                                        $('#shareRecipientName').val('');
                                                                                                        $('#shareEmailAddress').val('');
                                                                                                        $('#shareExtraMessage').val('');
                                                                                                    });
                                                                                                    return false;"><?php echo UCWords(t("send_email", "send email")); ?> <i class="entypo-mail"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

    <?php if(COUNT($imageRawDataArr)): ?>
                                <div class="tab-pane image-data" id="image-data">
                                    <table class="table table-bordered table-striped">
                                        <tbody>
        <?php
        foreach($imageRawDataArr AS $k => $imageRawDataItem)
        {
            ?> 
                                                <tr>
                                                    <td class="view-file-details-first-row">
            <?php echo $imageViewerObj->formatExifName($k); ?>:
                                                    </td>
                                                    <td>
            <?php echo $imageRawDataItem; ?>
                                                    </td>
                                                </tr>
            <?php
        }
        ?>
                                        </tbody>
                                    </table>
                                </div>
    <?php endif; ?>
                        </div>
                    </div>
<?php endif; ?>

            </div>
        </div>
    </div>

    <!-- pre cache next and previous images -->
    <div class="pre-image-cache-wrapper">
<?php
if(($next !== null) && (PRE_CACHE_NEXT_IMAGE == true))
{
    $fileNext = file::loadById($next);
    if($fileNext)
    {
        $imageLink = file::getIconPreviewImageUrl((array) $fileNext, false, 160, false, 1100, 1100, 'cropped');
        echo '<img src="' . $imageLink . '"/>';
    }
}
if(($prev !== null) && (PRE_CACHE_PREV_IMAGE == true))
{
    $filePrev = file::loadById($prev);
    if($filePrev)
    {
        $imageLink = file::getIconPreviewImageUrl((array) $filePrev, false, 160, false, 1100, 1100, 'cropped');
        echo '<img src="' . $imageLink . '"/>';
    }
}
?>
    </div>
</div>

<?php
$html = ob_get_contents();
ob_end_clean();

// prepare result
$returnJson = array();
$returnJson['success'] = true;
$returnJson['html'] = $html;
$returnJson['page_title'] = $file->originalFilename;
$returnJson['page_url'] = $file->getFullShortUrl();
$returnJson['javascript'] = $javascript;

echo json_encode($returnJson);
