<?php

// some initial headers
header("HTTP/1.0 200 OK");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Pragma: no-cache");

// per page options
$perPageOptions = array(12, 20, 40, 100);
$defaultPerPage = 20;

// sorting options
$sortingOptions = array();
$sortingOptions['order_by_album_asc'] = 'Album Name ASC';
$sortingOptions['order_by_album_desc'] = 'Album Name DESC';
$sortingOptions['order_by_downloads_asc'] = 'Downloads ASC';
$sortingOptions['order_by_downloads_desc'] = 'Downloads DESC';
$sortingOptions['order_by_last_added_date_asc'] = 'Added ASC';
$sortingOptions['order_by_last_added_date_desc'] = 'Added DESC';
$sortingOptions['order_by_last_updated_date_asc'] = 'Updated ASC';
$sortingOptions['order_by_last_updated_date_desc'] = 'Updated DESC';
$defaultSorting = 'order_by_last_added_date_desc';

// setup initial params
if(!isset($_SESSION['browse']['perPage']) || (int)$_SESSION['browse']['perPage'] == 0)
{
	$_SESSION['browse']['perPage'] = $defaultPerPage;
}
if((!isset($_SESSION['browse']['filterOrderBy'])) || (strlen($_SESSION['browse']['filterOrderBy']) == 0))
{
	$_SESSION['browse']['filterOrderBy'] = $defaultSorting;
}

$pageStart = (int)$_REQUEST['pageStart'];
$perPage = (int)$_REQUEST['perPage']>0?(int)$_REQUEST['perPage']:$_SESSION['browse']['perPage'];
$filterOrderBy = strlen($_REQUEST['filterOrderBy'])?$_REQUEST['filterOrderBy']:$_SESSION['browse']['filterOrderBy'];
$userId = isset($_REQUEST['userId'])?(int)$_REQUEST['userId']:null;

// advanced filters
$advFilters = isset($_REQUEST['advFilters'])?$_REQUEST['advFilters']:array();
$filterImagesAll = (isset($advFilters['filterImagesAll']) && ($advFilters['filterImagesAll'] == 'false'))?false:true;
$filterUploadedDateRange = (isset($advFilters['filterUploadedDateRange']) && strlen($advFilters['filterUploadedDateRange']))?$advFilters['filterUploadedDateRange']:null;

// image extensions
$imageExtArr = file::getImageExtStringForSql();

// save session params
$_SESSION['browse']['perPage'] = $perPage;
$_SESSION['browse']['filterOrderBy'] = $filterOrderBy;

// sorting
$sortColName = 'folderName';
$sortDir = 'asc';
switch($_SESSION['browse']['filterOrderBy'])
{
    case 'order_by_album_asc':
        $sortColName = 'folderName';
        $sortDir = 'asc';
        break;
    case 'order_by_album_desc':
        $sortColName = 'folderName';
        $sortDir = 'desc';
        break;
	case 'order_by_downloads_asc':
        $sortColName = '(SELECT SUM(file.visits) FROM file WHERE file.folderId = file_folder.id AND file.statusId = 1)';
        $sortDir = 'asc';
        break;
    case 'order_by_downloads_desc':
        $sortColName = '(SELECT SUM(file.visits) FROM file WHERE file.folderId = file_folder.id AND file.statusId = 1)';
        $sortDir = 'desc';
        break;
	case 'order_by_last_added_date_asc':
        $sortColName = 'date_added';
        $sortDir = 'asc';
        break;
    case 'order_by_last_added_date_desc':
        $sortColName = 'date_added';
        $sortDir = 'desc';
        break;
	case 'order_by_last_updated_date_asc':
        $sortColName = 'date_updated';
        $sortDir = 'asc';
        break;
    case 'order_by_last_updated_date_desc':
        $sortColName = 'date_updated';
        $sortDir = 'desc';
        break;
}


// setup initial params
$searchTerm = trim($_REQUEST['searchFilter']);
$commentObj = pluginHelper::getInstance('comments');

$db = Database::getDatabase();

// if this is a search
$addClause = '';
if(strlen($searchTerm))
{
	$addClause = ' AND (file_folder.folderName LIKE "%'.$db->escape($searchTerm).'%")';
}

// add user id
if($userId)
{
	$addClause = ' AND (file_folder.userId = '.(int)$userId.')';
}

// just searching owned images
if($filterImagesAll == false)
{
	$filesClause .= " AND file_folder.userId = " . (int)$Auth->id;
}

// filter by date range
if($filterUploadedDateRange !== null)
{
    // validate date
    $expDate = explode('|', $filterUploadedDateRange);
    if(COUNT($expDate) == 2)
    {
        $startDate = $expDate[0];
        $endDate = $expDate[1];
    }
    else
    {
        $startDate = $expDate[0];
        $endDate = $expDate[0];
    }

    if((validation::validDate($startDate, 'Y-m-d')) && (validation::validDate($endDate, 'Y-m-d')))
    {
        // dates are valid
        $addClause .= " AND (UNIX_TIMESTAMP(file_folder.date_updated) >= ".coreFunctions::convertDateToTimestamp($startDate, 'Y-m-d')." AND UNIX_TIMESTAMP(file_folder.date_updated) <= ".(coreFunctions::convertDateToTimestamp($endDate, 'Y-m-d')+(60*60*24)-1).")";
    }
}

// get total
$totalFolders = (int)$db->getValue('SELECT COUNT(file_folder.id) FROM file_folder WHERE file_folder.isPublic = 2 AND file_folder.accessPassword IS NULL AND (SELECT COUNT(file.id) FROM file WHERE file.folderId = file_folder.id AND isPublic != 0) > 0'.$addClause);

// load limited page filtered
$folders = $db->getRows('SELECT file_folder.id, file_folder.userId, file_folder.parentId, file_folder.folderName, file_folder.accessPassword, file_folder.coverImageId, (SELECT COUNT(file.id) FROM file WHERE file.folderId = file_folder.id AND file.statusId = 1) AS total_images, (SELECT file.id FROM file WHERE file.folderId = file_folder.id AND file_folder.isPublic = 2 AND file.statusId = 1 AND extension IN('.$imageExtArr.') LIMIT 1) AS coverImageIdBackup FROM file_folder WHERE file_folder.isPublic = 2 AND file_folder.accessPassword IS NULL AND (SELECT COUNT(file.id) FROM file WHERE file.folderId = file_folder.id AND isPublic != 0) > 0'.$addClause.' ORDER BY '.$sortColName.' '.$sortDir.' LIMIT '.(($pageStart - 1) * (int)$_SESSION['browse']['perPage']) .','.$_SESSION['browse']['perPage']);

// breadcumbs
$breadcrumbs = array();
if(strlen($searchTerm))
{
	$breadcrumbs[] = '<li><a href="'.WEB_ROOT.'/browse/"><i class="entypo-picture"></i>'.t('search_albums_results', 'Album Search Results').'</a></li>';
}
else
{
	$breadcrumbs[] = '<li><a href="'.WEB_ROOT.'/browse/"><i class="entypo-picture"></i>'.t('browse_albums', 'Browse Albums').'</a></li>';
}
$breadcrumbs[] = '<li>'.(int)$totalFolders.' '.t('albums', 'albums').'</li>';

$returnJson['html'] = '';
$returnJson['html'] .= '<div class="gallery-env"><div class="row">';
if ($folders)
{
	$returnJson['html'] .= '<div class="toolbar-container">
		<!-- toolbar -->
		<div class="col-md-6 col-sm-8 clearfix">
			<!-- breadcrumbs -->
			<div class="row breadcrumbs-container">
				<div class="col-md-12 col-sm-12 clearfix">
					<ol id="folderBreadcrumbs" class="breadcrumb bc-3 pull-left">'.implode('', $breadcrumbs).'</ol>
				</div>
			</div>
		</div>';

	$returnJson['html'] .= '
		<div class="col-md-6 col-sm-4 clearfix hidden-xs right-toolbar-options">
			<div class="list-inline pull-right responsiveHide">
				<div class="btn-toolbar pull-right" role="toolbar">
					<div class="btn-group">
						<button class="btn btn-white" type="button" title="" data-original-title="Fullscreen" data-placement="bottom" data-toggle="tooltip" onclick="toggleFullScreenMode();
								return false;"><i class="entypo-resize-full"></i></button>
					</div>

					<div class="btn-group">
						<div class="btn-group">
							<button id="filterButton" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
								'.validation::safeOutputToScreen($sortingOptions{$_SESSION['browse']['filterOrderBy']}).' <i class="entypo-arrow-combo"></i>
							</button>
							<ul role="menu" class="dropdown-menu dropdown-white pull-right">
								<li class="disabled"><a href="#">Sort By</a></li>';
								foreach($sortingOptions AS $k=>$v)
								{
									$returnJson['html'] .= '<li><a href="#" onclick="updateBrowseSorting(\''.$k.'\', \''.$v.'\', this); return false;">'.$v.'</a></li>';
								}
                            $returnJson['html'] .= '</ul>
							<input name="filterOrderBy" id="filterOrderBy" value="'.validation::safeOutputToScreen($_SESSION['browse']['filterOrderBy']).'" type="hidden">
						</div>

						<div class="btn-group">
							<button id="perPageButton" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
								'.(int)$_SESSION['browse']['perPage'].' <i class="entypo-arrow-combo"></i>
							</button>
							<ul role="menu" class="dropdown-menu dropdown-white pull-right per-page-menu">
								<li class="disabled"><a href="#">Per Page:</a></li>';
								foreach($perPageOptions AS $perPageOption)
								{
									$returnJson['html'] .= '<li><a href="#" onclick="updateBrowsePerPage(\''.(int)$perPageOption.'\', \''.(int)$perPageOption.'\', this); return false;">'.(int)$perPageOption.'</a></li>';
								}
                            $returnJson['html'] .= '</ul>
							<input name="perPageElement" id="perPageElement" value="100" type="hidden">
						</div>
					</div>
				</div>
				<ol id="folderBreadcrumbs2" class="breadcrumb bc-3 pull-right">
					<li class="active">
						<span id="statusText"></span>
					</li>
				</ol>
			</div>
		</div>';


$returnJson['html'] .= '
		<!-- /.navbar-collapse -->
	</div>';

	
    // output albums
	$returnJson['html'] .= '<div class="album-listing-wrapper">';
	$counter = 1;
    foreach ($folders AS $folder)
    {
        $folderObj = fileFolder::hydrate($folder);
		
		// prepare cover image
		$coverData = $folderObj->getCoverData();
		$coverId = (int)$coverData['file_id'];
		$coverUniqueHash = $coverData['unique_hash'];
		
		// get owner object
		$ownerObj = $folderObj->getOwner();
		
		// get sub images
		$subImageArr = array(0 => 0, 1 => 0, 2 => 0);
		$sQL = 'SELECT file.id, file.unique_hash FROM file WHERE file.folderId = '.(int)$folder['id'].' AND file.statusId = 1 AND file.id != '.(int)$coverId.' ORDER BY uploadedDate DESC LIMIT 3';
		$childImages = $db->getRows($sQL);
		if($childImages)
		{
			foreach($childImages AS $k=>$childImage)
			{
				// make sure we have the file hash
				$uniqueHash = $childImage['unique_hash'];
				if(strlen($uniqueHash) == 0)
				{
					$uniqueHash = file::createUniqueFileHash($childImage['id']);

				}
				$subImageArr[$k] = array('file_id'=>$childImage['id'], 'unique_hash'=>$uniqueHash);
			}
		}
		
        $returnJson['html'] .= '<div class="col-sm-3">';
		$returnJson['html'] .= '<article class="album">';
		$returnJson['html'] .= '<header class="images">';
		$returnJson['html'] .= '<a href="#" onClick="loadImages('.(int)$folder['id'].'); return false;" class="image-1"><img src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$coverId.'/'.$coverUniqueHash.'/303x195_middle.jpg"></a>';
		
		$returnJson['html'] .= '<div class="sub-images">';
		$returnJson['html'] .= '<div class="col-sm-4">';
		if((int)$subImageArr[0]['file_id']) $returnJson['html'] .= '	<a href="#" onClick="showImage('.(int)$subImageArr[0]['file_id'].'); return false;" class="image-2">';
		$returnJson['html'] .= '	<img src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$subImageArr[0]['file_id'].'/'.$subImageArr[0]['unique_hash'].'/100x73_middle.jpg" title="'.$folder['sub_images'].'">';
		if((int)$subImageArr[0]['file_id']) $returnJson['html'] .= '	</a>';
		$returnJson['html'] .= '</div>';
		$returnJson['html'] .= '<div class="col-sm-4">';
		if((int)$subImageArr[1]['file_id']) $returnJson['html'] .= '	<a href="#" onClick="showImage('.(int)$subImageArr[1]['file_id'].'); return false;" class="image-3">';
		$returnJson['html'] .= '	<img src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$subImageArr[1]['file_id'].'/'.$subImageArr[1]['unique_hash'].'/100x73_middle.jpg">';
		if((int)$subImageArr[1]['file_id']) $returnJson['html'] .= '	</a>';
		$returnJson['html'] .= '</div>';
		$returnJson['html'] .= '<div class="col-sm-4">';
		if((int)$subImageArr[2]['file_id']) $returnJson['html'] .= '	<a href="#" onClick="showImage('.(int)$subImageArr[2]['file_id'].'); return false;" class="image-4">';
		$returnJson['html'] .= '	<img src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$subImageArr[2]['file_id'].'/'.$subImageArr[2]['unique_hash'].'/100x73_middle.jpg">';
		if((int)$subImageArr[2]['file_id']) $returnJson['html'] .= '	</a>';
		$returnJson['html'] .= '</div>';
		$returnJson['html'] .= '</div>';
		$returnJson['html'] .= '<div class="clear"></div>';
		$returnJson['html'] .= '</header>';
		
		$returnJson['html'] .= '<section class="album-info">';
		$returnJson['html'] .= '<a href="'.validation::safeOutputToScreen($ownerObj->getProfileUrl()).'"><img width="72" class="img-circle" alt="'.validation::safeOutputToScreen($ownerObj->getAccountScreenName()).'" src="'.WEB_ROOT.'/page/view_avatar.php?id='.(int)$ownerObj->id.'&width=72&height=72"/></a>';
		
		$returnJson['html'] .= '<span class="text-section">';
		$returnJson['html'] .= '	<h3><a href="#" onClick="loadImages('.(int)$folder['id'].'); return false;">'.str_replace(' ', '&nbsp;', validation::safeOutputToScreen($folder['folderName'])).'</a></h3>';
		$returnJson['html'] .= '	'.t('album_by', 'By').' <a href="'.validation::safeOutputToScreen($ownerObj->getProfileUrl()).'" class="text-section-2">'.validation::safeOutputToScreen($ownerObj->getAccountScreenName()).'</a>';
		
		$returnJson['html'] .= '<div class="album-image-overview-stats">';
		$returnJson['html'] .= '	<div title="'.validation::safeOutputToScreen(t('album_total_images', 'Total Images')).'" data-original-title="'.validation::safeOutputToScreen(t('album_total_images', 'Total Images')).'" data-placement="bottom" data-toggle="tooltip"> <i class="entypo-picture"></i>'.validation::safeOutputToScreen($folder['total_images']).'</div>';
		$returnJson['html'] .= '	<div title="'.validation::safeOutputToScreen(t('album_total_likes', 'Total Likes')).'" data-original-title="'.validation::safeOutputToScreen(t('album_total_likes', 'Total Likes')).'" data-placement="bottom" data-toggle="tooltip"> <i class="entypo-thumbs-up"></i>'.$folderObj->getTotalLikes().'</div>';
		$returnJson['html'] .= '	<div title="'.validation::safeOutputToScreen(t('album_total_comments', 'Total Comments')).'" data-original-title="'.validation::safeOutputToScreen(t('album_total_comments', 'Total Comments')).'" data-placement="bottom" data-toggle="tooltip"> <i class="entypo-comment"></i>'.$commentObj->getTotalActiveAlbumComments($folderObj).'</div>';
		$returnJson['html'] .= '	<div title="'.validation::safeOutputToScreen(t('album_total_views', 'Total Views')).'" data-original-title="'.validation::safeOutputToScreen(t('album_total_views', 'Total Views')).'" data-placement="bottom" data-toggle="tooltip"> <i class="entypo-eye"></i>'.$folderObj->getTotalViews().'</div>';
		
		$returnJson['html'] .= '<div class="share-wrapper"><input type="checkbox" class="checkbox" id="share-'.(int)$folder['id'].'"/><label for="share-'.(int)$folder['id'].'" class="label entypo-export" title="'.validation::safeOutputToScreen(t('album_share', 'Share')).'" data-original-title="'.validation::safeOutputToScreen(t('album_share', 'Share')).'" data-placement="bottom" data-toggle="tooltip"> </label><div class="social"><ul>';
		$returnJson['html'] .= '<a target="_blank" href="https://twitter.com/share?url='.$folderObj->getAlbumUrl().'"><li class="entypo-twitter"></li></a>';
		$returnJson['html'] .= '<a target="_blank" href="http://www.facebook.com/sharer/sharer.php?u='.$folderObj->getAlbumUrl().'"><li class="entypo-facebook"></li></a>';
		$returnJson['html'] .= '<a target="_blank" href="https://plus.google.com/share?url='.$folderObj->getAlbumUrl().'"><li class="entypo-gplus"></li></a>';
		$returnJson['html'] .= '</ul></div></div>';
		
		$returnJson['html'] .= '</div>';
		
		$returnJson['html'] .= '</span>';
		$returnJson['html'] .= '</section>';
		
		$returnJson['html'] .= '</article>';
		$returnJson['html'] .= '</div>';
		
		if($counter % 4 == 0)
		{
			$returnJson['html'] .= '<div class="clear"></div>';
		}
		$counter++;
    }
	$returnJson['html'] .= '</div>';

	$returnJson['html'] .= '</div>';
	
	$pagingJsFunction = 'loadBrowsePageAlbums(currentSearchFilter';
	if($userId)
	{
		$pagingJsFunction = 'loadAlbumsByUserId(currentUserId';
	}
	$currentPage = $pageStart;
	$totalPages = ceil((int)$totalFolders/(int)$_SESSION['browse']['perPage']);
	$pagingHtml .= '<div class="paginationRow row">';
	$pagingHtml .= '	<div id="pagination" class="paginationWrapper col-md-12 responsiveAlign">';
	$pagingHtml .= '		<ul class="pagination">';
	$pagingHtml .= '			<li class="'.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?$pagingJsFunction.');':'').' return false;"><i class="entypo-left-thin"></i> '.UCWords(t('first', 'first')).'</a></li>';
	$pagingHtml .= '			<li class="'.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?$pagingJsFunction.', '.((int)$currentPage-1).');':'').' return false;"><i class="entypo-left-thin"></i> '.UCWords(t('previous', 'previous')).'</a></li>';
	
	// calculate numbers before and after
	$startPager = $currentPage - 3;
	if($startPager < 1)
	{
		$startPager = 1;
	}
	
	for($i=0; $i<=6; $i++)
	{
		$currentPager = $startPager + $i;
		if($currentPager > $totalPages)
		{
			continue;
		}
		$pagingHtml .= '		<li class="'.(($currentPager == $currentPage)?'active':'').'"><a href="#" onclick="'.$pagingJsFunction.', '.(int)$currentPager.'); return false;">'.(int)$currentPager.'</a></li>';
	}

	$pagingHtml .= '			<li class="'.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?$pagingJsFunction.', '.((int)$currentPage+1).');':'').' return false;">'.UCWords(t('next', 'next')).' <i class="entypo-right-thin"></i></a></li>';
	$pagingHtml .= '			<li class="'.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?$pagingJsFunction.', '.((int)$totalPages).');':'').' return false;">'.UCWords(t('last', 'last')).' <i class="entypo-right-thin"></i></a></li>';
	$pagingHtml .= '		</ul>';
	$pagingHtml .= '	</div>';
	
	$pagingHtml .= '</div>';
	
	$returnJson['html'] .= $pagingHtml;
}
else
{	
	$returnJson['html'] .= '<div class="toolbar-container">
		<!-- toolbar -->
		<div class="col-md-6 col-sm-8 clearfix">
			<!-- breadcrumbs -->
			<div class="row breadcrumbs-container">
				<div class="col-md-12 col-sm-12 clearfix">
					<ol id="folderBreadcrumbs" class="breadcrumb bc-3 pull-left">'.implode('', $breadcrumbs).'</ol>
				</div>
			</div>
		</div>
	</div>';

	$returnJson['html'] .= '<div class="no-results-wrapper">';
    $returnJson['html'] .= '<div class="alert alert-warning"><i class="entypo-attention"></i> '.t('there_are_no_album_results_search', 'There are no albums given the current search criteria.').'</div>';
	$returnJson['html'] .= '</div>';
}

$returnJson['html'] .= '</div>';

// output response
echo json_encode($returnJson);
