<?php

// some initial headers
header("HTTP/1.0 200 OK");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Pragma: no-cache");

// per page options
$perPageOptions = array(12, 20, 40, 100);
$defaultPerPage = 20;

// sorting options
$sortingOptions = array();
$sortingOptions['order_by_album_asc'] = 'Album Name ASC';
$sortingOptions['order_by_album_desc'] = 'Album Name DESC';
$sortingOptions['order_by_downloads_asc'] = 'Downloads ASC';
$sortingOptions['order_by_downloads_desc'] = 'Downloads DESC';
$sortingOptions['order_by_last_added_date_asc'] = 'Added ASC';
$sortingOptions['order_by_last_added_date_desc'] = 'Added DESC';
$sortingOptions['order_by_last_updated_date_asc'] = 'Updated ASC';
$sortingOptions['order_by_last_updated_date_desc'] = 'Updated DESC';
$defaultSorting = 'order_by_last_added_date_desc';

// setup initial params
if(!isset($_SESSION['browse']['perPage']) || (int)$_SESSION['browse']['perPage'] == 0)
{
	$_SESSION['browse']['perPage'] = $defaultPerPage;
}
if((!isset($_SESSION['browse']['filterOrderBy'])) || (strlen($_SESSION['browse']['filterOrderBy']) == 0))
{
	$_SESSION['browse']['filterOrderBy'] = $defaultSorting;
}

$pageStart = (int)$_REQUEST['pageStart'];
$perPage = (int)$_REQUEST['perPage']>0?(int)$_REQUEST['perPage']:$_SESSION['browse']['perPage'];
$filterOrderBy = strlen($_REQUEST['filterOrderBy'])?$_REQUEST['filterOrderBy']:$_SESSION['browse']['filterOrderBy'];

// image extensions
$imageExtArr = file::getImageExtStringForSql();

// save session params
$_SESSION['browse']['perPage'] = $perPage;
$_SESSION['browse']['filterOrderBy'] = $filterOrderBy;

// sorting
$sortColName = 'folderName';
$sortDir = 'asc';
switch($_SESSION['browse']['filterOrderBy'])
{
    case 'order_by_album_asc':
        $sortColName = 'folderName';
        $sortDir = 'asc';
        break;
    case 'order_by_album_desc':
        $sortColName = 'folderName';
        $sortDir = 'desc';
        break;
	case 'order_by_downloads_asc':
        $sortColName = '(SELECT SUM(file.visits) FROM file WHERE file.folderId = file_folder.id AND file.statusId = 1)';
        $sortDir = 'asc';
        break;
    case 'order_by_downloads_desc':
        $sortColName = '(SELECT SUM(file.visits) FROM file WHERE file.folderId = file_folder.id AND file.statusId = 1)';
        $sortDir = 'desc';
        break;
	case 'order_by_last_added_date_asc':
        $sortColName = 'date_added';
        $sortDir = 'asc';
        break;
    case 'order_by_last_added_date_desc':
        $sortColName = 'date_added';
        $sortDir = 'desc';
        break;
	case 'order_by_last_updated_date_asc':
        $sortColName = 'date_updated';
        $sortDir = 'asc';
        break;
    case 'order_by_last_updated_date_desc':
        $sortColName = 'date_updated';
        $sortDir = 'desc';
        break;
}

// setup initial params
$searchFilter = trim($_REQUEST['searchFilter']);
$commentObj = pluginHelper::getInstance('comments');
$imageViewerObj = pluginHelper::getInstance('imageviewer');

$db = Database::getDatabase();

// get categories
$categories = $imageViewerObj->getImageCategories();

// breadcumbs
$breadcrumbs = array();
$breadcrumbs[] = '<li><a href="'.WEB_ROOT.'/browse/category/"><i class="entypo-archive"></i>'.t('browse_categories', 'Browse Categories').'</a></li>';
$breadcrumbs[] = '<li>'.t('category_listing', 'Category Listing').'</li>';

$returnJson['html'] = '';
if ($categories)
{
	$returnJson['html'] .= '<div class="gallery-env browse-category"><div class="row">';
	$returnJson['html'] .= '<div class="toolbar-container">
		<!-- toolbar -->
		<div class="col-md-6 col-sm-8 clearfix">
			<!-- breadcrumbs -->
			<div class="row breadcrumbs-container">
				<div class="col-md-12 col-sm-12 clearfix">
					<ol id="folderBreadcrumbs" class="breadcrumb bc-3 pull-left">'.implode('', $breadcrumbs).'</ol>
				</div>
			</div>
		</div>';
	$returnJson['html'] .= '
		<!-- /.navbar-collapse -->
	</div>';

	
    // output categories
    foreach ($categories AS $category)
    {
		// total image count
		$totalImages = $db->getValue('SELECT COUNT(file.id) FROM file LEFT JOIN file_folder ON file.folderId = file_folder.id WHERE (file_folder.isPublic = 2 OR file.userId IS NULL) AND file_folder.accessPassword IS NULL AND file.id IN (SELECT file_id FROM plugin_imageviewer_category_file WHERE category_id = '.(int)$category['id'].')');
		
		// load most recent images within each category, only ones set as public or ones uploaded without an account
		$images = $db->getRows('SELECT file.* FROM file LEFT JOIN file_folder ON file.folderId = file_folder.id WHERE (file_folder.isPublic = 2 OR file.userId IS NULL) AND file_folder.accessPassword IS NULL AND file.id IN (SELECT file_id FROM plugin_imageviewer_category_file WHERE category_id = '.(int)$category['id'].') ORDER BY file.uploadedDate DESC LIMIT 12');
		
		if($images)
		{
			// category section
			$returnJson['html'] .= '
				<div class="col-md-12 category-section">
					<div class="panel panel-primary">
					<div class="panel-heading"><div class="panel-title"><a href="'.coreFunctions::getCoreSitePath().'/browse/category/'.validation::safeOutputToScreen($category['key']).'"><h4><strong>'.validation::safeOutputToScreen($category['label']).' ('.(int)$totalImages.')</strong> <span style="float: right;">view more</span></a></h4></div></div>';
			$returnJson['html'] .= '<div class="panel-body"><div class="row basic-image-layout">';
			foreach($images AS $image)
			{
				// get file object
				$imageObj = file::hydrate($image);
				
				$returnJson['html'] .= '<div class="col-sm-2 col-xs-4 image-thumb">';
				$returnJson['html'] .= '<article>';
				$returnJson['html'] .= '<a href="#" onClick="showImage('.(int)$imageObj->id.'); return false;"><img src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$imageObj->id.'/'.$imageObj->getFileHash().'/200x200_middle.jpg" class="responsive-thumb"/></a>';
				$returnJson['html'] .= '</article>';
				$returnJson['html'] .= '</div>';
			}
			$returnJson['html'] .= '</div></div></div>
					</div>';
			$returnJson['html'] .= '<div class="clear"></div>';
		}
    }
	
	$returnJson['html'] .= '</div>';
	$returnJson['html'] .= '</div>';
}
else
{
    $returnJson['html'] .= '<div class="alert alert-default"><i class="entypo-attention"></i> '.t('there_are_no_categories_setup', 'There are no categories setup.').'</div>';
}

// output response
echo json_encode($returnJson);
