<?php

// setup result array
$rs = array();

// get variables
$rs = array();
$type = $_REQUEST["type"];
$query = $_REQUEST["query"];
if(strlen($query) == 0)
{
	echo json_encode($rs);
	exit;
}

// only images
$imageExtArr = file::getImageExtStringForSql();

switch($type)
{
	case 'images':
		// lookup images
		$images = $db->getRows('SELECT file.*, users.username FROM file LEFT JOIN users ON file.userId = users.id WHERE (file.originalFilename LIKE "%'.$db->escape($query).'%" OR file.shortUrl LIKE "%'.$db->escape($query).'%") AND file.statusId = 1 AND file.isPublic > 0 ORDER BY uploadedDate DESC LIMIT 10');
		if($images)
		{
			foreach($images AS $image)
			{
				// hydrate so we have access to the file object
				$fileObj = file::hydrate($image);

				// prepare data
				$lRs = array();
				$lRs['id'] = $image['id'];
				$lRs['title'] = $image['originalFilename'];
				$lRs['url'] = $fileObj->getFullShortUrl();
				$lRs['thumbnail'] = file::getIconPreviewImageUrl($image, false, 48, false, 100, 100, 'middle');
				$lRs['owner'] = strlen($image['username'])?$image['username']:t('guest_user', 'Guest User');
				$lRs['uploaded_date'] = coreFunctions::formatDate($image['uploadedDate']);
				$lRs['none'] = '';
				
				// add to overall array
				$rs[] = $lRs;
			}
		}
		break;
	
	case 'albums':
		// lookup albums
		$albums = $db->getRows('SELECT file_folder.id, file_folder.userId, users.username, file_folder.parentId, file_folder.folderName, file_folder.accessPassword, file_folder.coverImageId, (SELECT COUNT(file.id) FROM file WHERE file.folderId = file_folder.id AND (isPublic = 2 OR userId = '.(int)$Auth->id.') AND file.statusId = 1) AS total_images, (SELECT file.id FROM file WHERE file.folderId = file_folder.id AND file_folder.isPublic = 2 AND file.statusId = 1 AND extension IN('.$imageExtArr.') LIMIT 1) AS coverImageIdBackup FROM file_folder LEFT JOIN users ON file_folder.userId = users.id WHERE file_folder.isPublic = 2 AND (file_folder.folderName LIKE "%'.$db->escape($query).'%" ) AND (SELECT COUNT(file.id) FROM file WHERE file.folderId = file_folder.id AND isPublic != 0 AND file.statusId = 1) > 0 ORDER BY date_added DESC, folderName ASC LIMIT 10');
		if($albums)
		{
			foreach($albums AS $album)
			{
				// hydrate so we have access to the folder object
				$folderObj = fileFolder::hydrate($album);
		
				// prepare cover image
				$coverData = $folderObj->getCoverData();
				$coverId = (int)$coverData['file_id'];
				$coverUniqueHash = $coverData['unique_hash'];

				// prepare data
				$lRs = array();
				$lRs['id'] = $album['id'];
				$lRs['title'] = $album['folderName'];
				$lRs['url'] = $folderObj->getAlbumUrl();
				$lRs['thumbnail'] = CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$coverId.'/'.$coverUniqueHash.'/100x100_middle.jpg';
				$lRs['owner'] = strlen($album['username'])?$album['username']:t('guest_user', 'Guest User');
				$lRs['total_images'] = $album['total_images'].' '.($album['total_images']==1?(t('image', 'image')):(t('images', 'images')));
				$lRs['none'] = '';
				
				// add to overall array
				$rs[] = $lRs;
			}
		}
		break;
		
	case 'users':
		// lookup users
		$users = $db->getRows('SELECT users.id, users.username, users.lastlogindate, users.title, users.firstname, users.lastname, (SELECT COUNT(file.id) FROM file WHERE file.userId = users.id AND isPublic = 1 AND file.statusId = 1) AS total_images FROM users WHERE (users.username LIKE "%'.$db->escape($query).'%" OR CONCAT(users.firstname, \' \', users.lastname) LIKE "%'.$db->escape($query).'%") ORDER BY (SELECT COUNT(file.id) FROM file WHERE file.userId = users.id AND isPublic = 1 AND file.statusId = 1) DESC, username ASC LIMIT 10');
		//$users = $db->getRows('SELECT users.id, users.username, users.lastlogindate, users.title, users.firstname, users.lastname, (SELECT COUNT(file.id) FROM file WHERE file.userId = users.id AND isPublic = 1 AND file.statusId = 1) AS total_images FROM users WHERE (users.username LIKE "%'.$db->escape($query).'%" OR CONCAT(users.firstname, \' \', users.lastname) LIKE "%'.$db->escape($query).'%") AND level_id IN (SELECT id FROM user_level WHERE level_type != \'admin\' AND level_type != \'admin\') ORDER BY (SELECT COUNT(file.id) FROM file WHERE file.userId = users.id AND isPublic = 1 AND file.statusId = 1) DESC, username ASC LIMIT 10');
		if($users)
		{
			foreach($users AS $user)
			{
				// user object
				$userObj = UserPeer::hydrate($user);
				
				// prepare data
				$lRs = array();
				$lRs['id'] = $user['id'];
				$lRs['title'] = $user['username'];
				$lRs['url'] = $userObj->getProfileUrl();
				$lRs['thumbnail'] = $userObj->getSmallAvatarUrl();
				$lRs['last_seen'] = $userObj->getLastLoginFormatted();
				$lRs['total_images'] = $user['total_images'].' '.($user['total_images']==1?(t('image', 'image')):(t('images', 'images')));
				$lRs['none'] = '';
				
				// add to overall array
				$rs[] = $lRs;
			}
		}
		break;
}

echo json_encode($rs);