<?php

// validation
$colWidth      = 5;
$colHeight     = 5;

// load reward details
$pluginObj      = pluginHelper::getInstance('imageviewer');
$pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// output page
echo '<html>';
echo '<body style=\'margin: 0px; padding: 0px; color: #FFF; font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; font-size: 14px;\'>';

// get limited results
$totalRowPercent = 0;
$images = $db->getRows('SELECT file.* FROM file LEFT JOIN file_folder ON file.folderId = file_folder.id WHERE file_folder.isPublic = 2 AND file.statusId = 1 AND file_folder.accessPassword IS NULL ORDER BY file.uploadedDate DESC LIMIT '.($colWidth*$colHeight));
if(!$images)
{
	die('No public images found.');
}
foreach($images AS $image)
{
	// load file object for later
	$fileObj = file::hydrate($image);
	
	$colWidthPercent = number_format(100/$colWidth, 2);
	$previewImageUrl = file::getIconPreviewImageUrl($image, false, 48, false, 100, 100, 'middle');
	echo '<div style="width: '.$colWidthPercent.'%; display: inline-block;">';
	echo '<a href="'.$fileObj->getFullShortUrl().'" target="_blank">';
	echo '<img src="'.$previewImageUrl.'" style="width: 100%; border: 1px solid #333333; box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;"/>';
	echo '</div>';
}

// output bottom
echo '</body>';
echo '</html>';