#!/bin/sh
# Description: close and stop iptables.

echo "10240 65000" > /proc/sys/net/ipv4/ip_local_port_range
echo "120" > /proc/sys/net/ipv4/tcp_keepalive_time
echo "3" > /proc/sys/net/ipv4/tcp_syn_retries
echo "5" > /proc/sys/net/ipv4/tcp_retries2
echo "3" > /proc/sys/net/ipv4/tcp_orphan_retries
echo "30" > /proc/sys/net/ipv4/tcp_fin_timeout
echo "1" > /proc/sys/net/ipv4/tcp_tw_recycle
echo "1" > /proc/sys/net/ipv4/tcp_tw_reuse
echo "180000" > /proc/sys/net/ipv4/tcp_max_tw_buckets
echo "8192" > /proc/sys/net/ipv4/tcp_max_syn_backlog
echo "8192" > /proc/sys/net/core/somaxconn
echo "8192" > /proc/sys/net/core/netdev_max_backlog

# Used For CentOS 6.X Version
if [ -f "/proc/sys/net/netfilter/nf_conntrack_max" ]; then
    echo "1048560" > /proc/sys/net/netfilter/nf_conntrack_max
    # echo "163840" > /proc/sys/net/netfilter/nf_conntrack_buckets
fi

# Used For CentOS 5.X Version
if [ -f "/proc/sys/net/ipv4/netfilter/ip_conntrack_max" ]; then
    echo "1048560" > /proc/sys/net/ipv4/netfilter/ip_conntrack_max
    # echo "163840" > /proc/sys/net/ipv4/netfilter/ip_conntrack_buckets
fi

if [ -f "/sbin/chkconfig" ]; then
    /sbin/chkconfig iptables off
    /sbin/chkconfig ip6tables off
else
    chkconfig iptables off
    chkconfig ip6tables off
fi

if [ -f "/sbin/service" ]; then
    /sbin/service iptables stop
    /sbin/service ip6tables stop
else
    service iptables stop
    service ip6tables stop
fi

