<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Reported Comments');
define('ADMIN_SELECTED_PAGE', '');
define('ADMIN_SELECTED_SUB_PAGE', 'plugin_comments_menu_reports');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// process submits
if(isset($_REQUEST['delete']))
{
    $db->query("DELETE FROM plugin_comments WHERE id = " . (int) $_REQUEST['delete']);
    $db->query("DELETE FROM plugin_comments_reports WHERE comId = " . (int) $_REQUEST['delete']);
    adminFunctions::setSuccess(t('plugin_comments_comment_deleted', 'Comment deleted.'));
}
// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>
<script>
    console.log()
    oTable = null;
    gRewardId = null;
    $(document).ready(function () {
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "oLanguage": {
                "sZeroRecords": "No reported comments to display"
            },
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/reports.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 10,
            "aaSorting": [[1, "desc"]],
            "aoColumns": [
                {bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide"},
                {bSortable: true, sWidth: '15%', sName: 'date', sClass: "center dataTableFix"},
                {bSortable: false, sName: 'filename', sClass: "adminResponsiveHide"},
                {bSortable: false, sWidth: '12%', sName: 'author', sClass: "center adminResponsiveHide"},
                {bSortable: false, sWidth: '12%', sName: 'timesreported', sClass: "center adminResponsiveHide"},
                {bSortable: false, sWidth: '18%', sClass: "center"}
            ],
            "fnServerData": function (sSource, aoData, fnCallback) {
                aoData.push({"name": "filterText", "value": $('#filterText').val()});
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": sSource,
                    "data": aoData,
                    "success": fnCallback
                });
            },
            "fnDrawCallback": function (oSettings) {
                postDatatableRender();
            },
            "oLanguage": {
                "sEmptyTable": "There are no items in the current filters."
            },
            dom: "lBfrtip",
            buttons: [
                {
                    extend: "copy",
                    className: "btn-sm"
                },
                {
                    extend: "csv",
                    className: "btn-sm"
                },
                {
                    extend: "excel",
                    className: "btn-sm"
                },
                {
                    extend: "pdfHtml5",
                    className: "btn-sm"
                },
                {
                    extend: "print",
                    className: "btn-sm"
                }
            ]
        });
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
    });
    function viewReports(id)
    {
        gViewReportId = id;
        showBasicModal('Loading...', 'View Report', '<button type="button" class="btn btn-primary" onClick="processDeleteReports(); return false;">Delete Selected</button>');
        loadReportsForm();
    }
    function processDeleteReports()
    {
        rSelect = new Array();
        $.each($("input[name='rSelect[]']:checked"), function () {
            rSelect.push($(this).val());
        });

        comId = null;
        if ($('#comId').length != 0)
        {
            comId = $('#comId').val();
        }
        $.ajax({
            type: "POST",
            url: "ajax/view_reports_form_process_delete.ajax.php",
            data: {rSelect: rSelect, comId: comId},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    $('#viewReportsFormInner').html(json.msg);
                    showError(json.msg, 'popupMessageContainer');
                } else
                {
                    showSuccess(json.msg);
                    reloadTable();
                    hideModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                setBasicModalContent(textStatus + ': ' + errorThrown);
            }
        });
    }
    function loadReportsForm()
    {
        $('#viewReportsFormInner').html('');
        $.ajax({
            type: "POST",
            url: "ajax/view_reports_form.ajax.php",
            data: {gViewReportId: gViewReportId},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    setBasicModalContent(json.msg);
                } else
                {
                    setBasicModalContent(json.html);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                setBasicModalContent(textStatus + ': ' + errorThrown);
            }
        });
    }
    function reloadTable()
    {
        oTable.fnDraw();
    }
</script>

<!-- page content -->
<div class="right_col" role="main">
    <div class="">

        <div class="row clearfix">
            <div class="x_panel">
                <div class="x_title"><h2>Reported Comments</h2><div class="clearfix"></div></div>
                <div class="x_content responsiveTable">
<?php echo adminFunctions::compileNotifications(); ?>
                    <table id='fileTable' class="table table-striped table-only-border dtLoading bulk_action">
                        <thead>
                            <tr>
                                <th></th>
                                <th><?php echo adminFunctions::t('plugin_comments_date_added', 'Date Added'); ?></th>
                                <th class="align-left"><?php echo adminFunctions::t('plugin_comments_filename', 'Filename'); ?></th>
                                <th><?php echo adminFunctions::t('plugin_comments_author', 'Author'); ?></th>
                                <th><?php echo adminFunctions::t('plugin_comments_times_reported', 'Times Reported'); ?></th>
                                <th><?php echo adminFunctions::t('plugin_comments_actions', 'Actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        By Author:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable();
                return false;" style="width: 160px;" class="form-control"/>
    </label>
</div>
<div id="viewReportsForm" title="View Reports">
    <span id="viewReportsFormInner"></span>
</div>
<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>