<?php

// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');
define('ADMIN_SELECTED_SUB_PAGE', 'plugin_manage');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}

define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin Settings');

// prepare variables
$plugin_enabled			= (int) $plugin['plugin_enabled'];
$autoApprove			= 1;
$enableCaptcha			= 1;
$commentsPerPage		= 25;
$disableExternalLinks	= 1;
$commentRatings			= 1;
$enabled_non_user       = 1;
$enabled_free_user      = 1;
$enabled_paid_user      = 1;

// load existing settings
if (strlen($plugin['plugin_settings']))
{
    $pluginSettings = json_decode($plugin['plugin_settings'], true);
    if ($pluginSettings)
    {
		$enabled_non_user       = $pluginSettings['enabled_non_user'];
        $enabled_free_user      = $pluginSettings['enabled_free_user'];
        $enabled_paid_user      = $pluginSettings['enabled_paid_user'];
		$autoApprove			= $pluginSettings['autoApprove'];	
		$enableCaptcha			= $pluginSettings['enableCaptcha'];
		$commentsPerPage		= $pluginSettings['commentsPerPage'];		
		$disableExternalLinks	= $pluginSettings['disableExternalLinks'];	
		$commentRatings			= $pluginSettings['commentRatings'];
		$maxReports				= $pluginSettings['maxReports'];
		$maxLikes				= $pluginSettings['maxLikes'];
        $floodControl           = $pluginSettings['floodControl'];
    }
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $plugin_enabled			= (int) $_REQUEST['plugin_enabled'];
    $plugin_enabled			= $plugin_enabled != 1 ? 0 : 1;
    $enabled_non_user       = (int) $_REQUEST['enabled_non_user'];
    $enabled_free_user      = (int) $_REQUEST['enabled_free_user'];
    $enabled_paid_user      = (int) $_REQUEST['enabled_paid_user'];
	$autoApprove			= (int) $_REQUEST['autoApprove'];	
	$enableCaptcha			= (int) $_REQUEST['enableCaptcha'];
	$commentsPerPage		= (int) $_REQUEST['commentsPerPage'];
	$disableExternalLinks	= (int) $_REQUEST['disableExternalLinks'];
	$commentRatings			= (int) $_REQUEST['commentRatings'];
	$maxReports				= (int) $_REQUEST['maxReports'];
	$maxLikes				= (int) $_REQUEST['maxLikes'];
    $floodControl           = $_REQUEST['floodControl'];
    
    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    
    // update the settings
    if (adminFunctions::isErrors() == false)
    {
        // compile new settings
        $settingsArr							= array();
        $settingsArr['enabled_non_user']        = $enabled_non_user;
        $settingsArr['enabled_free_user']       = $enabled_free_user;
        $settingsArr['enabled_paid_user']       = $enabled_paid_user;
		$settingsArr['autoApprove']				= $autoApprove;
		$settingsArr['enableCaptcha']			= $enableCaptcha;
		$settingsArr['commentsPerPage']			= $commentsPerPage;
		$settingsArr['disableExternalLinks']	= $disableExternalLinks;
		$settingsArr['commentRatings']			= $commentRatings;
		$settingsArr['maxReports']				= $maxReports;
		$settingsArr['maxLikes']				= $maxLikes;
        $settingsArr['floodControl']            = $floodControl;
        $settings								= json_encode($settingsArr);
        
        // update the plugin
        $dbUpdate                  = new DBObject("plugin", array("plugin_enabled", "plugin_settings"), 'id');
        $dbUpdate->plugin_enabled  = $plugin_enabled;
        $dbUpdate->plugin_settings = $settings;
        $dbUpdate->id              = $pluginId;
        $dbUpdate->update();
        
        // update plugin config
        pluginHelper::loadPluginConfigurationFiles(true);
        adminFunctions::setSuccess('Plugin settings updated.');
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2><?php echo ADMIN_PAGE_TITLE; ?></h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Plugin State</h3>
                            <p>Whether the comments plugin is enabled.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Plugin Enabled:</label>
                                    <div class="input">
                                        <select name="plugin_enabled" id="plugin_enabled" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($plugin_enabled == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Enable By User Type</h3>
                            <p>Whether each user type can comment or not.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix">
                                    <label>Non User Enabled:</label>
                                    <div class="input">
                                        <select name="enabled_non_user" id="enabled_non_user" class="medium validate[required]" onChange="showHideSelects(); return false;">
                                                    <?php
                                                    $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                                    foreach ($enabledOptions AS $k => $enabledOption)
                                                    {
                                                        echo '<option value="' . $k . '"';
                                                        if ($enabled_non_user == $k)
                                                        {
                                                            echo ' SELECTED';
                                                        }
                                                        echo '>' . $enabledOption . '</option>';
                                                    }
                                                    ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <br/>
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Free User Enabled:</label>
                                    <div class="input">
                                        <select name="enabled_free_user" id="enabled_free_user" class="medium validate[required]" onChange="showHideSelects(); return false;">
                                                    <?php
                                                    $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                                    foreach ($enabledOptions AS $k => $enabledOption)
                                                    {
                                                        echo '<option value="' . $k . '"';
                                                        if ($enabled_free_user == $k)
                                                        {
                                                            echo ' SELECTED';
                                                        }
                                                        echo '>' . $enabledOption . '</option>';
                                                    }
                                                    ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <br/>
                            <div class="form">
                                <div class="clearfix">
                                    <label>Paid User Enabled:</label>
                                    <div class="input">
                                        <select name="enabled_paid_user" id="enabled_paid_user" class="medium validate[required]" onChange="showHideSelects(); return false;">
                                                    <?php
                                                    $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                                    foreach ($enabledOptions AS $k => $enabledOption)
                                                    {
                                                        echo '<option value="' . $k . '"';
                                                        if ($enabled_paid_user == $k)
                                                        {
                                                            echo ' SELECTED';
                                                        }
                                                        echo '>' . $enabledOption . '</option>';
                                                    }
                                                    ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Auto Approve Comments</h3>
                            <p>If set to yes, all comments will be visible as soon as they're posted.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Auto Approve:</label>
                                    <div class="input">
										<select name="autoApprove" id="autoApprove" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($autoApprove == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Enable Captcha</h3>
                            <p>Do you want captcha enabled on the comments form for non-registered users?</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix">
                                    <label>Enable Captcha:</label>
                                    <div class="input">
										<select name="enableCaptcha" id="enableCaptcha" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($enableCaptcha == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Disable External Links</h3>
                            <p>Do you want to disable links in comments?</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Disable Links:</label>
                                    <div class="input">
										<select name="disableExternalLinks" id="disableExternalLinks" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($disableExternalLinks == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Comments Per Page</h3>
                            <p>How many comments per page do you want to show?</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix">
                                    <label>Comments Per Page:</label>
                                    <div class="input">                                
                                    <select name="commentsPerPage" id="commentsPerPage" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array('5' => '5', '10' => '10', '15' => '15', '20' => '20', '25' => '25', '30' => '30', '35' => '35', '40' => '40', '45' => '45', '50' => '50');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($commentsPerPage == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                 
                    
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Flood Control</h3>
                            <p>The amount of time a user must wait in between posting comments.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Time:</label>
									<div class="input">
										<select name="floodControl" id="floodControl" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array('0' => '--- Disabled ---', '5 SECONDS' => '5 Seconds', '15 SECONDS' => '15 Seconds', '30 SECONDS' => '30 Seconds', '1 MINUTE' => '1 Minute', '2 MINUTE' => '2 Minutes', '5 MINUTE' => '5 Minutes', '10 MINUTES' => '10 Minutes', '15 MINUTE' => '15 Minutes', '30 MINUTE' => '30 Minutes', '45 MINUTE' => '45 Minutes', '1 HOUR' => '1 Hour', '3 HOUR' => '3 Hours', '6 HOUR' => '6 Hours', '12 HOUR' => '12 Hours', '1 DAY' => '24 Hours');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($floodControl == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                       </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    				
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Comment Likes</h3>
                            <p>Do you want to enable/disable the comment "Likes" system?</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix">
                                    <label>Comment Likes:</label>
                                    <div class="input">
										<select name="commentRatings" id="commentRatings" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'Disabled', 1 => 'Enabled');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($commentRatings == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Likes Per 24 Hours</h3>
                            <p>The maximum number of likes a user can submit in any 24 hour period.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Likes Per 24 Hours:</label>
                                    <div class="input">
										<select name="maxLikes" id="maxLikes" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array('1' => '1', '3' => '3', '5' => '5', '10' => '10', '15' => '15', '20' => '20', '25' => '25', '50' => '50', '75' => '75', '100' => '100');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($maxLikes == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>	
                    			
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Reports Per 24 Hours</h3>
                            <p>The maximum number of reports a user can submit in any 24 hour period.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix">
                                    <label>Reports Per 24 Hours:</label>
                                    <div class="input">
										<select name="maxReports" id="maxReports" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array('1' => '1', '3' => '3', '5' => '5', '10' => '10', '15' => '15', '20' => '20', '25' => '25');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($maxReports == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
									</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="clearfix col_12">
                        <div class="col_4 adminResponsiveHide">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix alt-highlight">
                                <div class="input no-label">
                                    <input type="submit" value="Submit" class="button blue">
                                    <input type="reset" value="Cancel" class="button" onClick="window.location='<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage.php';"/>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
            </div>
        </div>   
    </div>
</div>
<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>