<?php

$file 			= $params['file'];
$Auth 			= Auth::getAuth();
$db   			= Database::getDatabase();
$pluginConfig	= pluginHelper::pluginSpecificConfiguration('comments');
$pluginSettings = json_decode($pluginConfig['data']['plugin_settings'], true);
if ($pluginSettings)
{
	$plugin_enabled	      = $pluginConfig['data']['plugin_enabled'];
	$plugin_folder	      = $pluginConfig['data']['folder_name'];
    $commentsPerPage      = $pluginSettings['commentsPerPage'];
    $autoApprove          = $pluginSettings['autoApprove'];
    $enableCaptcha        = $pluginSettings['enableCaptcha'];
    $disableExternalLinks = $pluginSettings['disableExternalLinks'];
    $commentRatings       = $pluginSettings['commentRatings'];
    $maxReports           = $pluginSettings['maxReports'];
    $maxLikes             = $pluginSettings['maxLikes'];
}
$pluginObj  = pluginHelper::getInstance('comments');
// Pagination
$rows       = $db->getValue("SELECT COUNT(id) FROM plugin_comments WHERE status = 'active' AND fileId = '".(int)$file->id."'");
$totalpages = ceil($rows / $commentsPerPage);
$page		= 1;
if($totalpages != 1)
{
	$page   = isset($_REQUEST['page']) ? ((int) $_REQUEST['page']) : 1;
}
$pagination = new Pagination();
$pagination->setCurrent($page);
$pagination->setRPP($commentsPerPage);
$pagination->setTotal($rows);
$pagination->setClasses(array('pagination', 'pagination-sm'));
$showPagination = $pagination->render();
$limit      = 'LIMIT '.($page - 1) * (int)$commentsPerPage .', '. (int)$commentsPerPage;

// only logged in users can like comments
$ratingComArr = array();
if($Auth->id >= 1)
{
    $ratings  = $db->getRows("SELECT comId FROM plugin_comments_likes WHERE likedBy = ".(int)$Auth->id);
    foreach($ratings AS $rating)
    {
        $ratingComArr[] = $rating['comId'];
    }
}

// only logged in users can report
$reportComArr = array();
if($Auth->id >= 1)
{
    $reports  = $db->getRows("SELECT comId FROM plugin_comments_reports WHERE reportedBy = ".(int)$Auth->id);
    foreach($reports AS $report)
    {
        $reportComArr[] = $report['comId'];
    }
}
$comments = $db->getRows("SELECT plugin_comments.*, users.username FROM plugin_comments LEFT OUTER JOIN users ON plugin_comments.userId = users.id WHERE plugin_comments.fileId = ".(int)$file->id." AND plugin_comments.status = 'active' ORDER BY plugin_comments.id ".$limit);


?>
<style type="text/css">
#likeIcon {
	text-align: right; 
	vertical-align: bottom;
}
div.justified {
	display: flex;
	justify-content: center;
}
.notification {display: block; padding: 1.3em 35px; margin-bottom: 1em}
.notification.undone {border: 1px solid #c88383; background: url(../images/notifications/cross.png) no-repeat 10px center #fabbbb; color: #882626}
.notification.done {border: 1px solid #90b96b; background: url(../images/notifications/tick.png) no-repeat 10px center #c2ee9b; color: #345f0e}
.notification.information {border: 1px solid #7ea2bf; background: url(../images/notifications/information-balloon.png) no-repeat 10px center #b6d9f4; color: #1e4f74}
.notification.setting {border: 1px solid #b7b7b7; background: url(../images/notifications/gear.png) no-repeat 10px center #e2e2e2; color: #454545}
.notification.warning {border: 1px solid #c2c193; background: url(../images/notifications/exclamation.png) no-repeat 10px center #f1efb1; color: #6c6913}
</style>
<script>
function reportComment(comId)
{
	$.ajax({
		type: "POST",
		url: "<?php echo PLUGIN_WEB_ROOT; ?>/comments/includes/ajax/_report_comment.ajax.php",
		data: { comId: comId, maxReports: <?php echo $maxReports; ?> },
		dataType: 'json',
		success: function(json) {
			if(json.error == false)
			{
				//$('.reported' + comId).show();
				$('.report' + comId).hide();
                alert('<?php echo t('plugin_comments_comment_reported_popup', 'Comment successfully reported.'); ?>');
			}
            else
            {
                alert(json.msg);
            }
		},
		error: function (XMLHttpRequest, textStatus, errorThrown) {
			showError(XMLHttpRequest.responseText);
		}
	});
}

function likeComment(comId)
{
	$.ajax({
		type: "POST",
		url: "<?php echo PLUGIN_WEB_ROOT; ?>/comments/includes/ajax/_like_comment.ajax.php",
		data: { comId: comId },
		dataType: 'json',
		success: function(json) {
			if(json.error == false)
			{
				$('.liked' + comId).show().html('<img src="<?php echo PLUGIN_WEB_ROOT; ?>/comments/assets/img/icons/like.png" style="-webkit-filter: grayscale(100%); filter: grayscale(100%); opacity: 0.2; filter: alpha(opacity=20);" alt="<?php echo t('plugin_comments_like_this_comment', 'Like this comment') ?>" title="<?php echo t('plugin_comments_like_this_comment', 'Like this comment') ?>" /> ('+json.msg+')').show();				
				$('.like' + comId).hide();       
			}
            else
            {
                alert(json.msg);
            }
		},
		error: function (XMLHttpRequest, textStatus, errorThrown) {
			showError(XMLHttpRequest.responseText);
		}
	});
}

function postNewComment()
{
	commentVal = $('#comment').val();
	captchaVal = null;
	if($('#g-recaptcha-response').length != 0)
	{
		captchaVal = $('#g-recaptcha-response').val();
	}
	$.ajax({
		type: "POST",
		url: "<?php echo PLUGIN_WEB_ROOT; ?>/comments/includes/ajax/_post_comment.ajax.php",
		data: { comment: commentVal, captcha: captchaVal, fileId: <?php echo (int)$file->id; ?> },
		dataType: 'json',
		success: function(json) {
			if(json.error == true)
			{
			   commentError(json.msg);                   
			}
			else
			{
				commentSuccess(json.msg);
				$('#postComment').hide();
				$('.submitComment').hide();
				$('#commentSubmitted').show();
				$("#comment").val('');
			}
		},
		error: function (XMLHttpRequest, textStatus, errorThrown) {
			showError(XMLHttpRequest.responseText);
		}
	});
}
function commentError(msg, containerId)
{
	if(typeof(containerId) == "undefined")
	{
		containerId = 'notificationHeader';
	}	
	$(".notification").hide();
	$('#'+containerId).hide().html('<ul class="pageErrors"><li>'+msg+'</li></ul>').show();
	commentNotificationEvents();
}
function commentSuccess(msg, containerId)
{
	if(typeof(containerId) == "undefined")
	{
		containerId = 'notificationHeader';
	}	
	$(".notification").hide();
	$('#'+containerId).hide().html('<ul class="pageSuccess"><li>'+msg+'</li></ul>').show();
	commentNotificationEvents();
}

function commentNotificationEvents()
{
	$(".notification").click(function() {
		$(this).fadeOut("slow");
	});
}
</script>
<div id="pageHeader" style="padding-top: 12px;">
	<h2><?php echo t("plugin_comments_comments_title", "Comments"); ?></h2>
</div>

<div class="container">
<?php
if($comments)
{
?>
	<div class="row">
		<?php                
		foreach ($comments AS $com)
		{
			?>
			<table class="accountStateTable table table-bordered table-striped">
			<tbody>
				<tr>
					<td class="first comments-table-header">
						<?php echo (($com['userId'] != 0) ? $com['username'] : t('plugin_comments_non_user_title', 'Guest User')); ?>
					</td>
					<td>                
					<?php                
					echo (($Auth->level_id == 20) ? '<span style="font-size:11px">'.validation::safeOutputToScreen($com['ipAddress']).'</span>' : '');
					// Already reported
					if(in_array($com['id'], $reportComArr))
					{
						// Don't actually need to add anything here if the comment has been reported.                    
					}
					// Enable the report if the user is not the comment poster
					elseif($com['userId'] != $Auth->id && $Auth->level_id > 0)
					{
						if(!in_array($com['id'], $reportComArr))
						{
						?>
							<span style="float:right;" class="report<?php echo $com['id']; ?>">
							<a href="#" onclick="reportComment(<?php echo $com['id']; ?>); return false;">
							<img src="<?php echo PLUGIN_WEB_ROOT; ?>/comments/assets/img/icons/report.png" alt="<?php echo t('plugin_comments_report_this_comment', 'Report this comment') ?>" title="<?php echo t('plugin_comments_report_this_comment', 'Report this comment') ?>" />
							</a>
							</span>
							<span style="float:right; display:none;" class="reported<?php echo $com['id']; ?>">
							<img src="<?php echo PLUGIN_WEB_ROOT; ?>/comments/assets/img/icons/report.png" alt="<?php echo t('plugin_comments_report_this_comment', 'Report this comment') ?>" style="opacity: 0.2; filter: alpha(opacity=20);" title="<?php echo t('plugin_comments_report_this_comment_reported', 'Comment Reported') ?>" />
							</span>                 
						<?php 
						}
					}
					// Disable the report if they posted the comment
					elseif($com['userId'] == $Auth->id && $Auth->level_id > 0)
					{
						// Don't actually need to add anything here if the comment has been reported.      
					}
					?>
					</td>
				</tr>
				<tr>
					<td class="first comments-table-header" style="font-weight: normal;">
						<?php echo coreFunctions::formatDate($com['dateAdded']); ?>
					</td>
					<td>
						<?php  
						$comment = validation::safeOutputToScreen($com['content'], 'abcdefghijklmnopqrstuvwxyz 1234567890 .#<>:/?-+=&"');
						if($disableExternalLinks == 1)
						{
							$comment = $pluginObj->stripUrls($comment);
							$comment = $pluginObj->stripHyperLinks($comment);
						}
						else
						{
							$comment = $pluginObj->fixUrls($comment);
							$comment = $pluginObj->createHyperLinks($comment);
						}
						echo ($comment);
						if(($commentRatings == 1))
						{
							// Already Liked the comment.
							if(in_array($com['id'], $ratingComArr))
							{						
								echo '<div id="likeIcon" class="liked'.$com['id'].'">';
								echo '<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/like.png" style="opacity: 0.2; filter: alpha(opacity=20);" 
									  alt="'.t('plugin_comments_like_this_comment', 'Like this comment').'" title="'.t('plugin_comments_like_this_comment', 'Like this comment').'" />';

								if($com['rating'] > 0)
								{ 
									echo ' ('.validation::safeOutputToScreen($com['rating']).')'; 
								} 
								echo '</div>';
							}
							// Enable the like if the user is not the comment poster
							elseif($com['userId'] != $Auth->id && $Auth->level_id > 0)
							{
								if(!in_array($com['id'], $ratingComArr))
								{
									echo '<div id="likeIcon" class="like'.$com['id'].'">';
									echo '<a href="#" onclick="likeComment('.$com['id'].'); return false;" style="text-decoration:none;">';
									echo '<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/like.png" alt="'.t('plugin_comments_like_this_comment', 'Like this comment').'" 
										  title="'.t('plugin_comments_like_this_comment', 'Like this comment').'" />';
									
									if($com['rating'] > 0)
									{ 
										echo ' ('.validation::safeOutputToScreen($com['rating']).')'; 
									}
									echo '</a>';
									echo '</div>';
									echo '<div id="likeIcon" class="liked'.$com['id'].'" style="display:none;"></div>';
								}
								else
								{
									echo '<div id="likeIcon" class="liked'.$com['id'].'">';
									echo '<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/like.png" style="opacity: 0.2; filter: alpha(opacity=20);" 
										  alt="'.t('plugin_comments_like_this_comment', 'Like this comment').'" title="'.t('plugin_comments_like_this_comment', 'Like this comment').'" />';
		
									if($com['rating'] > 0)
									{ 
										echo ' ('.validation::safeOutputToScreen($com['rating']).')'; 
									} 
									echo '</div>';
								}
							 }
							 // Disable the like if they posted the comment
							 elseif($com['userId'] == $Auth->id && $Auth->level_id > 0)
							 {
								echo '<div id="likeIcon" class="liked'.$com['id'].'"></div>';
							 } 
							 elseif($Auth->level_id < 1)
							 {
								// Guest users can't vote 
								echo '<div id="likeIcon" class="liked'.$com['id'].'"></div>';
							 }
						}
						?>                         
					</td>
				</tr>
			</tbody>
			</table>            
		<?php
		}
		echo '<div style="float: right;">'.$showPagination.'</div>
    </div>';
}
$userAllowed = false;
if(($Auth->level_id == 0) && ($pluginSettings['enabled_non_user'] == 1))
{
    $userAllowed = true;
}
elseif(($Auth->level_id == 1) && ($pluginSettings['enabled_free_user'] == 1))
{
    $userAllowed   = true;
}
elseif(($Auth->level_id >= 2) && ($pluginSettings['enabled_paid_user'] == 1))
{
    $userAllowed   = true;
}
if($userAllowed === true)
{
    $canReply = true;
}
if($canReply == true)
{
?>	
	<div class="row" id="commentSubmitted">
		<div class="notificationHeader" id="notificationHeader"></div>
	</div>
	<div class="row">
    	<form name="submitComment" action="">     
    	<table class="accountStateTable table table-bordered table-striped submitComment">
    		<tbody>
    			<tr>
    				<td><strong><?php echo t('plugin_comments_add_comment', 'Add Comment'); ?></strong></td>
    			</tr>
    			<tr>
    				<td><div class="justified"><textarea name="comment" id="comment" style="width: 75%;" rows="7" style="margin-left: 50%; margin-right:50%;"></textarea></div></td>
    			</tr>
    			<?php if($enableCaptcha == 1 && $Auth->level_id == 0): ?>
    			<tr>
    				<td><div class="justified"><?php echo coreFunctions::outputCaptcha(); ?></div></td>
    			</tr>
    			<?php endif; ?>
    			<tr>
    				<td style="text-align:center;"><button class="btn btn-default" tabindex="99" type="submit" name="submit" id="postComment" style="width:25%; height: 60px;" onClick="postNewComment(); return false;"><i class="fa fa-check"></i><?php echo t('submit', 'submit'); ?></button></td>
    			</tr>
    		</tbody>
    	</table>
        </form>
	</div>
	<div class="clear"><!-- --></div>
<?php
}
elseif($canReply == false)
{
?>
	<div class="row" id="commentSubmitted">
		<div class="notificationHeader" id="notificationHeader"></div>
	</div>
	<div class="row">
    	<form name="submitComment" action="">     
    	<table class="accountStateTable table table-bordered table-striped submitComment">
    		<tbody>
    			<tr>
    				<td><strong><?php echo t('plugin_comments_add_comment', 'Add Comment'); ?></strong></td>
    			</tr>
    			<tr>
    				<td><?php echo $pluginObj->userErrorReporting($pluginSettings['enabled_non_user'], $pluginSettings['enabled_free_user'], $pluginSettings['enabled_paid_user']); ?></td>
    			</tr>
    		</tbody>
    	</table>
        </form>
	</div>
	<div class="clear"><!-- --></div>
<?php
}
?>
</div>