<?php

include_once('../../../../core/includes/master.inc.php');

// setup plugin
$pluginObj  = pluginHelper::getInstance('comments');
$pluginConfig	= pluginHelper::pluginSpecificConfiguration('comments');
$pluginSettings = json_decode($pluginConfig['data']['plugin_settings'], true);
if ($pluginSettings)
{
    $commentRatings       = $pluginSettings['commentRatings'];
    $maxLikes             = $pluginSettings['maxLikes'];
	$commentsPerPage      = $pluginSettings['commentsPerPage'];
}
$fileId		  = (int)$_REQUEST['fileId'];
$isAdd		  = (int)$_REQUEST['isAdd'];
$file = file::loadById($fileId);
if(!$file)
{
	coreFunctions::output404();
}

// Pagination
$rows       = $db->getValue("SELECT COUNT(id) FROM plugin_comments WHERE status = 'active' AND fileId = ".(int)$file->id);
$totalpages = ceil($rows / $commentsPerPage);
$startPage  = (int)$_REQUEST['startPage'];
if($startPage < 1)
{
	$startPage = 1;
}
elseif($startPage > $totalpages)
{
	$startPage = $totalpages;
}

// if adding a comment set paging as last
if($isAdd == 1)
{
	$startPage = $totalpages;
}

$limit      = 'LIMIT '.($startPage - 1) * (int)$commentsPerPage .', '. (int)$commentsPerPage;

// prepare result
$result = array();
$result['error'] = false;
$result['msg']   = '';
$result['is_add']   = $isAdd;

// only logged in users can like comments
$ratingComArr = array();
if($Auth->id >= 1)
{
    $ratings  = $db->getRows("SELECT comId FROM plugin_comments_likes WHERE likedBy = ".(int)$Auth->id);
    foreach($ratings AS $rating)
    {
        $ratingComArr[] = $rating['comId'];
    }
}

// only logged in users can report
$reportComArr = array();
if($Auth->id >= 1)
{
    $reports  = $db->getRows("SELECT comId FROM plugin_comments_reports WHERE reportedBy = ".(int)$Auth->id);
    foreach($reports AS $report)
    {
        $reportComArr[] = $report['comId'];
    }
}
$comments = $db->getRows("SELECT plugin_comments.*, users.username FROM plugin_comments LEFT OUTER JOIN users ON plugin_comments.userId = users.id WHERE plugin_comments.fileId = ".(int)$file->id." AND plugin_comments.status = 'active' ORDER BY plugin_comments.id ".$limit);;
$pageTotal = COUNT($comments);

$result['html'] = '';
foreach ($comments AS $k=>$com)
{
	$result['html'] .= $pluginObj->outputCommentBootstrap($com, $Auth, $reportComArr, $ratingComArr, ($pageTotal==($k+1)));
}

// paging
if($rows > 0)
{
	$result['html'] .= '<div class="paging-wrapper">';
	$result['html'] .= $pluginObj->outputAjaxPaging($startPage, $totalpages);
	$result['html'] .= '</div>';
}

echo json_encode($result);
exit;