<?php

class pluginComments extends Plugin
{
    public $config = null;

    public function __construct()
    {
        // get the plugin config
        include('_plugin_config.inc.php');

        // load config into the object
        $this->config = $pluginConfig;
    }
    
    public function install()
    {
        $db = database::getDatabase();
        $db->query("CREATE TABLE IF NOT EXISTS plugin_comments_likes (
					  id int(11) NOT NULL AUTO_INCREMENT,
					  comId int(11) NOT NULL,
					  likedBy int(11) NOT NULL,
					  likeDate datetime NOT NULL,
					  ipAddress varchar(21) COLLATE utf8_bin NOT NULL,
					  PRIMARY KEY (id)
					) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;");
     
        $db->query("CREATE TABLE IF NOT EXISTS plugin_comments (
					  id int(11) NOT NULL AUTO_INCREMENT,
					  fileId int(11) NOT NULL,
					  userId int(11) NOT NULL,
					  dateAdded datetime NOT NULL,
					  ipAddress varchar(25) COLLATE utf8_bin NOT NULL,
					  content text COLLATE utf8_bin NOT NULL,
					  status enum('pending','active') COLLATE utf8_bin NOT NULL,
					  rating int(11) NOT NULL DEFAULT '0',
					  PRIMARY KEY (id),
					  UNIQUE KEY id (id),
					  KEY fileId (fileId),
					  KEY userId (userId),
					  KEY ipAddress (ipAddress),
					  KEY status (status),
					  KEY dateAdded (dateAdded)
					) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;");   
        
        $db->query("CREATE TABLE IF NOT EXISTS plugin_comments_reports (
					  id int(11) NOT NULL AUTO_INCREMENT,
					  comId int(11) NOT NULL,
					  reportedBy int(11) NOT NULL,
					  reportDate datetime NOT NULL,
					  ipAddress varchar(25) COLLATE utf8_bin NOT NULL,
					  reportContent text COLLATE utf8_bin NOT NULL,
					  PRIMARY KEY (id)
					) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;"); 

		$db->query("ALTER TABLE plugin_comments ADD INDEX dateAdded (dateAdded)");


        return parent::install();
    }
    
    public function uninstall()
    {
        $db->query("DROP TABLE plugin_comments"); 
        $db->query("DROP TABLE plugin_comments_likes");  
        $db->query("DROP TABLE plugin_comments_reports");  
        return parent::uninstall();
    }

    public function getPluginDetails()
    {
        return $this->config;
    }
    
    // Strips out JS, HTML, Style Tags, & HTML comments
    public function cleanInput($input) 
    {
        $regex   = array(
						'@<body[^>]*?>.*?</body>@siu',
						'@<header[^>]*?>.*?</header>@siu',
                        '@<head[^>]*?>.*?</head>@siu',
            			'@<style[^>]*?>.*?</style>@siu',
            			'@<script[^>]*?.*?</script>@siu',
            			'@<object[^>]*?.*?</object>@siu',
            			'@<embed[^>]*?.*?</embed>@siu',
            			'@<applet[^>]*?.*?</applet>@siu',
            			'@<noframes[^>]*?.*?</noframes>@siu',
            			'@<noscript[^>]*?.*?</noscript>@siu',
            			'@<noembed[^>]*?.*?</noembed>@siu',
            			'@<((hr))@iu',
            			'@</?((address)|(blockquote)|(center)|(del))@iu',
            			'@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            			'@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            			'@</?((table)|(th)|(td)|(caption))@iu',
            			'@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            			'@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            			'@</?((frameset)|(frame)|(iframe))@iu',
                        );
                        
        $output = preg_replace($regex, '', $input);
		$output = strip_tags($output);
		$output = strip_tags($output);
       
        return trim($output);
    }
    
    public function fixUrls($input)
    {
        $input = preg_replace('/([^\w\/])(www\.[a-z0-9\-]+\.[a-z0-9\-]+)/i', "$1http://$2", $input);
        $input = str_replace('&lt;br /&gt;', '<br />', $input);
        return $input;
    }
	
	public function getTotalActiveComments(file $file)
	{
		// get datbaase
		$db = Database::getDatabase();
		$totalComments = (int)$db->getValue('SELECT COUNT(id) AS total FROM plugin_comments WHERE status = \'active\' AND fileId = '.(int)$file->id);
		
		return $totalComments;
	}
	
	public function getTotalActiveAlbumComments(fileFolder $fileFolder)
	{
		// get datbaase
		$db = Database::getDatabase();
		$totalComments = (int)$db->getValue('SELECT COUNT(id) AS total FROM plugin_comments WHERE status = \'active\' AND fileId IN (SELECT id FROM file WHERE folderId = '.(int)$fileFolder->id.')');
		
		return $totalComments;
	}
    
    // Completely remove ALL URL's
    // 1st preg_replace removes normal link http:// www. etc...
    public function stripUrls($input)
    {
        $input   = preg_replace('_^(?:(?:https?|ftp)://)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)(?:\.(?:[a-z\x{00a1}-\x{ffff}0-9]+-?)*[a-z\x{00a1}-\x{ffff}0-9]+)*(?:\.(?:[a-z\x{00a1}-\x{ffff}]{2,})))(?::\d{2,5})?(?:/[^\s]*)?$_iuS', '', $input);
        $input   = preg_replace('~www.[^\s]*~i', '', $input);
        
        return $input;
    }
    
    // Completely remove ALL hyperlinks's
    // preg_replace checks and removes <a href="#">blah</a>
    public function stripHyperLinks($input)
    {   
        $input = preg_replace('/<a href=\"(.*?)\">(.*?)<\/a>/', "\\2", $input);
        return $input;
    }
    
    // Replace links in text with html links
    public function createHyperLinks($input)
    {
        /*$input = str_ireplace(' www.', ' http://www.', $input);
        $input = str_ireplace('>www.', '> http://www.', $input);
        $input = str_ireplace('http://www.', ' http://www.', $input);
        $input = str_ireplace('<', ' <', $input);*/
        $input = preg_replace('/([^\w\/])(www\.[a-z0-9\-]+\.[a-z0-9\-]+)/i', "$1http://$2", $input);
        $regex = '/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/';
        preg_match($regex, $input, $url);
        // Linkify the urls
        return preg_replace($regex, '<a href="'.$url[0].'" rel="nofollow" target="_blank">'.$url[0].'</a> ', $input);
    }
	
	public function userErrorReporting($non, $free, $paid)
	{
		// Registered only
		if($non == 0 && $free == 1 && $paid == 1)
		{
			return t('plugin_comments_registered_users_only', 'Posting comments is limited to registered users only.');
		}
		// Paid Only
		elseif($non == 0 && $free == 0 && $paid == 1)
		{
			return t('plugin_comments_paid_users_only', 'Posting comments is limited to premium members only');
		}
		// All Disabled
		elseif($non == 0 && $free == 0 && $paid == 0)
		{
			return t('plugin_comments_comments_disabled', 'Posting comments is currently disabled.');
		}	
	}
	
	public function outputCommentBootstrap($com, $Auth, $reportComArr, $ratingComArr, $last = false)
	{
		$pluginConfig	= pluginHelper::pluginSpecificConfiguration('comments');
		$pluginSettings = json_decode($pluginConfig['data']['plugin_settings'], true);
		$commentRatings = $pluginSettings['commentRatings'];
		
		$userAllowed = false;
		if(($Auth->level_id == 0) && ($pluginSettings['enabled_non_user'] == 1))
		{
			$userAllowed = true;
		}
		elseif(($Auth->level_id == 1) && ($pluginSettings['enabled_free_user'] == 1))
		{
			$userAllowed   = true;
		}
		elseif(($Auth->level_id >= 2) && ($pluginSettings['enabled_paid_user'] == 1))
		{
			$userAllowed   = true;
		}
		$canReply = false;
		if($userAllowed === true)
		{
			$canReply = true;
		}

		$html = '';
		$html .= '<li'.($last==true?' class="last-comment"':'').'>';
        $html .= '<div class="user-comment-thumb"> <img src="'.WEB_ROOT.'/page/view_avatar.php?id='.(int)$com['userId'].'&width=40&height=40" alt="" class="img-circle" width="40"> </div>';
        $html .= '<div class="user-comment-content">';              
			// not reported already and if the user is not the comment poster
			if((!in_array($com['id'], $reportComArr)) && ($com['userId'] != $Auth->id && $Auth->level_id > 0))
			{
				$html .= '		<span style="float:right;" class="report'.$com['id'].'">'; 
				$html .= '			<a href="#" onclick="reportComment('.$com['id'].'); return false;">'; 
				$html .= '			<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/report_small.png" alt="'.t('plugin_comments_report_this_comment', 'Report this comment').'" title="'.t('plugin_comments_report_this_comment', 'Report this comment').'" />'; 
				$html .= '			</a>'; 
				$html .= '		</span>'; 
				$html .= '		<span style="float:right; display:none;" class="reported'.$com['id'].'">'; 
				$html .= '			<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/report_small.png" alt="'.t('plugin_comments_report_this_comment_reported', 'Comment Reported').'" style="opacity: 0.2; filter: alpha(opacity=65);" title="'.t('plugin_comments_report_this_comment_reported', 'Comment Reported').'" />'; 
				$html .= '		</span>'; 
			}
			elseif(in_array($com['id'], $reportComArr))
			{
				$html .= '<span style="float:right;" class="reported'.$com['id'].'">';
				$html .= '	<img src="'.PLUGIN_WEB_ROOT.'/comments/assets/img/icons/report_small.png" alt="'.t('plugin_comments_report_this_comment_reported', 'Comment Reported').'" style="opacity: 0.2; filter: alpha(opacity=65);" title="'.t('plugin_comments_report_this_comment_reported', 'Comment Reported').'" />';
				$html .= '</span>';
			}

			if($com['userId'] != 0)
			{
				$html .= '<a href="'.UserPeer::buildProfileUrl($com['username']).'" class="user-comment-name">';
				$html .= validation::safeOutputToScreen($com['username']);
				$html .= '</a>';
			}
			else
			{
				$html .= t('plugin_comments_non_user_title', 'Guest User');
			}
            $html .= ' - ';
            $comment = validation::safeOutputToScreen($com['content']);
			if($disableExternalLinks == 1)
			{
				$comment = $this->stripUrls($comment);
				$comment = $this->stripHyperLinks($comment);
			}
			else
			{
				$comment = $this->fixUrls($comment);
				$comment = $this->createHyperLinks($comment);
			}
			$comment = str_replace('[quote]', '<blockquote>', $comment);
			$comment = str_replace('[/quote]', '</blockquote>', $comment);
			$comment = str_replace("\n\n\n", "\n\n", $comment);
			$comment = str_replace("\n\n\n", "\n\n", $comment);
			$comment = str_replace("\n\n\n", "\n\n", $comment);
			$html .= nl2br($comment);

            $html .= '<div class="user-comment-meta"> <a href="#" class="comment-date">'.coreFunctions::formatDate($com['dateAdded'], 'D jS F Y').' '.t('file_at', 'at').' '.coreFunctions::formatDate($com['dateAdded'], 'g:ia').'</a>';

				if(($commentRatings == 1))
				{
					$html .= '&nbsp;-&nbsp;';
					
					// already Liked the comment or guest user
					if((in_array($com['id'], $ratingComArr)) || ($Auth->level_id < 1) || ($com['userId'] == $Auth->id && $Auth->level_id > 0))
					{						
						$html .= '<i class="entypo-heart" style="margin-left: 5px;"></i>'.t('likes', 'Likes').'<span style="margin-right: 5px;">';
						$html .= ' ('.(int)$com['rating'].')';
						$html .= '</span>';
					}
					// enable the like if the user is not the comment poster
					else
					{
						$html .= '<a href="#" onclick="likeComment('.$com['id'].'); return false;"><i class="entypo-heart"></i>'.t('likes', 'Likes').' <span id="totalLikes'.$com['id'].'">';
						$html .= '('.(int)$com['rating'].')';
						$html .= '</span></a>';
					}
				}
				
				if($canReply == true)
				{
					$html .= '&nbsp;-&nbsp;<a href="#" onClick="respondComment(\'@'.(($com['userId'] != 0) ? validation::safeOutputToScreen($com['username']) : t('plugin_comments_non_user_title', 'Guest User')).' - '.str_replace(array('\'', '"', "\n", "\t", "\r"), ' ', $comment).'\'); return false;"> <i class="entypo-comment"></i>Reply</a>';
				}
				$html .= (($Auth->level_id == 20) ? '-&nbsp;&nbsp;<i class="entypo-globe"></i> '.validation::safeOutputToScreen($com['ipAddress']).'' : '');
            $html .= '</div>';
        $html .= '</div>';
		$html .= '</li>';
		
		return $html;
	}
	
	public function outputAjaxPaging($currentPage, $totalPages)
	{
		$html = '';
		$html .= '<ul class="pagination pagination-sm">';
		$html .= '<li class="copy first '.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?'loadComments(1);':'').' return false;"><i class="entypo-to-start"></i></a></li>';
		$html .= '<li class="copy previous '.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?'loadComments('.((int)$currentPage-1).');':'').' return false;"><i class="entypo-left-dir"></i></a></li>';
		
		// calculate numbers before and after
		$startPager = $currentPage - 3;
		if($startPager < 1)
		{
			$startPager = 1;
		}
		
		for($i=0; $i<=6; $i++)
		{
			$currentPager = $startPager + $i;
			if($currentPager > $totalPages)
			{
				continue;
			}
			$html .= '<li class="number';
			if($currentPager == $currentPage)
			{
				$html .= ' active';
			}
			$html .= '"><a data-pagenumber="'.(int)$currentPager.'" href="#" onClick="loadComments('.(int)$currentPager.'); return false;">'.(int)$currentPager.'</a></li>';
		}

		$html .= '<li class="copy next '.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?'loadComments('.((int)$currentPage+1).');':'').' return false;"><i class="entypo-right-dir"></i></a></li>';
		$html .= '<li class="copy last '.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?'loadComments('.((int)$totalPages).');':'').' return false;"><i class="entypo-to-end"></i></a></li>';
		$html .= '</ul>';
		
		return $html;
	}
 }