<?php
// pickup params
$file = $params['file'];
$Auth = $params['Auth'];
$isPublic = (int)$params['isPublic'];

if ($file->statusId == 1)
{
    $ext = array('jpg', 'jpeg', 'png', 'gif');

    // check this is a video or audio, only 'mp4', 'webm', 'mp3', 'ogg' supported in this view
    if(in_array(strtolower($file->extension), $ext))
    {
		// load plugin details
		$pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
		$pluginConfig   = $pluginDetails['config'];
		$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);
		?>
			<h4><strong><?php echo UCWords(t("embed_code", "embed code")); ?></strong></h4>
			<table class="table table-bordered table-striped">
				<tbody>
					<?php
					if ((int) $pluginSettings['show_direct_link'] == 1)
					{
						?>
						<tr>
							<td class="share-file-table-header">
								<label><?php echo t('direct_link', 'Direct Link'); ?>:</label>
							</td>
							<td class="htmlCode" onClick="return false;">
								<section onClick="selectAllText(this); return false;">
								<?php echo _CONFIG_SITE_PROTOCOL . '://' . file::getFileDomainAndPath($file->id, $file->serverId, true) . '/' . PLUGIN_DIRECTORY_NAME; ?>/imageviewer/site/direct.php?s=<?php echo $file->shortUrl; ?>&/<?php echo $file->getSafeFilenameForUrl(); ?>
								</section>
							</td>
						</tr>
						<?php
					}

					if ((int) $pluginSettings['show_embedding'] == 1)
					{
						?>
						<tr>
							<td class="share-file-table-header">
								<label><?php echo t('embed_html_code', 'Embed HTML Code'); ?>:</label>
							</td>
							<td class="htmlCode ltrOverride" onClick="return false;">
								<section onClick="selectAllText(this); return false;">
								&lt;a href=&quot;<?php echo $file->getFullShortUrl(); ?>&quot; target=&quot;_blank&quot; title=&quot;<?php echo t('download_from', 'Download from'); ?> <?php echo SITE_CONFIG_SITE_NAME; ?>&quot;&gt;&lt;img src=&quot;<?php echo _CONFIG_SITE_PROTOCOL . '://' . file::getFileDomainAndPath($file->id, $file->serverId, true) . '/' . PLUGIN_DIRECTORY_NAME; ?>/imageviewer/site/thumb.php?s=<?php echo $file->shortUrl; ?>&amp;/<?php echo $file->getSafeFilenameForUrl(); ?>&quot;/&gt;&lt;/a&gt;
								</section>
							</td>
						</tr>

						<tr>
							<td class="share-file-table-header">
								<label><?php echo t('embed_forum_code', 'Embed Forum Code'); ?>:</label>
							</td>
							<td class="htmlCode ltrOverride">
								<section onClick="selectAllText(this); return false;">
								[URL=<?php echo $file->getFullShortUrl(); ?>][IMG]<?php echo _CONFIG_SITE_PROTOCOL . '://' . file::getFileDomainAndPath($file->id, $file->serverId, true) . '/' . PLUGIN_DIRECTORY_NAME; ?>/imageviewer/site/thumb.php?s=<?php echo $file->shortUrl; ?>&/<?php echo $file->getSafeFilenameForUrl(); ?>[/IMG][/URL]
								</section>
							</td>
						</tr>
						<?php
					}
					?>
				</tbody>
			</table>
		<?php
	}
}
?>