<?php

// Cron task to generate thumbnails of any uploaded files in the background
// Useful if you're allowing a lot of uploads via webdav where they're not automatically generated
// Should be run every minute via the command line like this:
// * * * * * php /path/to/your/install/plugins/imageviewer/site/background_thumbs.cron.php
// This cron script should be run on only your main server

// setup includes
define('CURRENT_FILE_PATH', dirname(__FILE__));
require_once (CURRENT_FILE_PATH.'/../../../core/includes/master.inc.php');

// setup logging
log::setContext('plugin_imageviewer_background_thumbs');
log::info('Starting cron task.');

// preload plugin object for later
$pluginObj = pluginHelper::getInstance('imageviewer');
$animatedExt = $pluginObj->getAnimatedFileExtensions();

// allow for the script to run for 10 minutes
set_time_limit(60 * 60 * 10);

// do as many as we can for 60 seconds
$secondsDone = 59;

// get latest image which does not have a thumbnail generated
$imageDataItems = $db->getRows('SELECT * FROM file WHERE extension IN ('.file::getImageExtStringForSql().') AND statusId = 1 AND id NOT IN (SELECT file_id FROM plugin_imageviewer_background_thumb) ORDER BY uploadedDate DESC LIMIT 30');
if ($imageDataItems)
{
	foreach($imageDataItems AS $imageData)
	{
		// add as processing to avoid overlaps
		$db->query('INSERT INTO plugin_imageviewer_background_thumb (file_id, thumb_status, date_added) VALUES ('.(int)$imageData['id'].', \'processing\', NOW())');
		
		// log
		log::info('Set item processing: #'.(int)$imageData['id'].' ('.$imageData['originalFilename'].')');
		
		// tracking
		$started = microtime(true);
		
		// figure out which extension to use
		$o = 'jpg';
		if(in_array($imageData['extension'], $animatedExt))
		{
			$o = 'gif';
		}
		
		// create thumbnail url
		$url = $pluginObj->createImageCacheUrl($imageData, 280, 280, 'middle', $o);
		
		// log
		log::info('Created thumbnail url: '.$url);

		// request the url to generate the thumbnails, just like on the website ui
		$rs = coreFunctions::getRemoteUrlContent($url);
		
		// tracking
		$ended = microtime(true);
		$processingTime = ($ended - $started);
		
		// update result
		$newStatus = 'created';
		if(($rs === false) || (strlen($rs) == 0))
		{
			$newStatus = 'failed';
			
			// log
			log::info('Failed getting url contents in time.');
		}
		$db->query('UPDATE plugin_imageviewer_background_thumb SET thumb_status = \''.$newStatus.'\', processing_time = \''.number_format($processingTime, 5).'\' WHERE file_id = '.(int)$imageData['id'].' LIMIT 1');
		
		$secondsDone = (int)$secondsDone - (int)ceil($processingTime);
		if($secondsDone < 0)
		{
			// exit if we've already done 60 seconds worth
			log::info('Ended cron task after 60 seconds of processing.');
			exit;
		}
	}
}

log::info('Ended cron task after all pending images processed.');
