<?php

// setup includes
require_once('../../../core/includes/master.inc.php');

// load image details
$pluginObj      = pluginHelper::getInstance('imageviewer');
$pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// validation
$fileId     = (int) $_REQUEST['f'];
$embedToken = $_REQUEST['idt'];

// try to load the file object
$file = null;
if ($fileId)
{
    $file = file::loadById($fileId);
}

// load file details
if (!$file)
{
    // no file found
    coreFunctions::output404();
}

// check file permissions, allow owners, non user uploads and admin/mods
if($file->userId != null)
{
	if((($file->userId != $Auth->id) && ($Auth->level_id < 10)))
	{
		// if this is a private file
		if(coreFunctions::getOverallPublicStatus($file->userId, $file->folderId, $file->id) == false)
		{
			$errorMsg = t("error_file_is_not_publicly_shared", "File is not publicly available.");
			coreFunctions::redirect(coreFunctions::getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
		}
	}
}

// check if file needs a password
$album = null;
if($Auth->id != $file->userId)
{
	if($file->folderId !== NULL)
	{
		$album = $file->getFolderData();
	}
	if(($album) && (strlen($album->accessPassword) > 0))
	{
		// see if we have it in the session already
		$askPassword = true;
		if(!isset($_SESSION['folderPassword']))
		{
			$_SESSION['folderPassword'] = array();
		}
		elseif(isset($_SESSION['folderPassword'][$album->id]))
		{
			if($_SESSION['folderPassword'][$album->id] == $album->accessPassword)
			{
				$askPassword = false;
			}
		}
		
		if($askPassword)
		{
			// redirect to main page which requests for a password
			coreFunctions::redirect(file::getFileUrl($file->id));
		}
	}
}

$db = Database::getDatabase(true);
$rs = $db->getValue('SELECT token FROM plugin_imageviewer_embed_token WHERE file_id=' . (int) $file->id . ' AND token="' . $db->escape($embedToken) . '" LIMIT 1');
if (!$rs)
{
    // show delay
    coreFunctions::redirect($file->getFullShortUrl());
    exit();
}

// cache paths
if ((int) $pluginSettings['caching'] == 1)
{
    $cacheFilePath = '../../../core/cache/plugins/imageviewer/';
    $cacheFilePath .= $fileId . '/';
    if (!file_exists($cacheFilePath))
    {
        mkdir($cacheFilePath, 0777, true);
    }
    $cacheFileName = (int) $pluginSettings['image_size_w'] . 'x' . (int) $pluginSettings['image_size_h'] . '_' . MD5(json_encode($pluginSettings)) . '.jpg';
    $fullCachePath = $cacheFilePath . $cacheFileName;
}

// check for cache
if (((int) $pluginSettings['caching'] == 0) || (!file_exists($fullCachePath)))
{
    // get image contents
    $contents = $file->download(false);

    // if animated gif output the original file
    if ($file->extension == 'gif')
    {
        if ($pluginObj->isAnimatedGif($contents) == true)
        {
            header('Content-Type: ' . $file->fileType);
            echo $contents;
            exit;
        }
    }

    // load image 
	include(DOC_ROOT.'/core/includes/image_resizer/CustomSimpleImage.php');
	$img = new CustomSimpleImage();
	$rs = $img->load_from_image_content($contents);
    if (!$rs)
    {
        // fail
		coreFunctions::redirect($pluginObj->getDefaultImageWebPath());
    }

	$method = 'cropped';
	$width = $pluginSettings['image_size_w'];
	$height = $pluginSettings['image_size_h'];
    if ($method == 'middle')
    {
        $img->thumbnail($width, $height);
    }
	elseif ($method == 'padded')
    {
        $img->padded_image($width, $height);
    }
	elseif($method == 'cropped')
	{
		$img->best_fit($width, $height);
	}
    else
    {
        $img->resize($width, $height);
    }

    // add on the watermark after resizing
    if (((int) $pluginSettings['watermark_enabled'] == 1) && ($width > 299))
    {
        // load watermark image
        $watermark = $db->getRow("SELECT file_name, image_content FROM plugin_imageviewer_watermark LIMIT 1");
        if ($watermark)
        {
			if(!empty($watermark['image_content']))
			{
				// save in tmp
				$tmpWMFile = tempnam('/tmp', 'img-');
				$tmp = fopen($tmpWMFile, 'w+');
				fwrite($tmp, $watermark['image_content']);
				fclose($tmp);

				// apply watermark
				$img->apply_watermark($tmpWMFile, $pluginSettings['watermark_position'], (int) $pluginSettings['watermark_padding'], (int) $pluginSettings['watermark_padding']);
				
				// clear wm cache
				@unlink($tmpWMFile);
			}
        }
    }

    $rs = false;
    if ((int) $pluginSettings['caching'] == 1)
    {
        // save image
        ob_start();
        $img->output('jpg', $pluginObj->getThumbnailImageQuality());
        $imageContent = ob_get_clean();
        $rs           = cache::saveCacheToFile('plugins/imageviewer/' . $fileId . '/' . $cacheFileName, $imageContent);
        header('Content-Type: image/jpeg');
        echo cache::getCacheFromFile('plugins/imageviewer/' . $fileId . '/' . $cacheFileName);
        exit;
    }

    if (!$rs)
    {
        // failed saving cache (or caching disabled), just output
        $img->output('jpg', $pluginObj->getThumbnailImageQuality());
        exit;
    }

    // cleanup memory
    imagedestroy($src);
    imagedestroy($tmp);
}

header('Content-Type: image/jpeg');
echo cache::getCacheFromFile('plugins/imageviewer/' . $fileId . '/' . $cacheFileName);
