<?php

// includes and security
include_once ('../../../../core/includes/master.inc.php');
include_once (DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

$iDisplayLength = (int)$_REQUEST['iDisplayLength'];
$iDisplayStart = (int)$_REQUEST['iDisplayStart'];
$sSortDir_0 = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";
$filterText = $_REQUEST['filterText'] ? $_REQUEST['filterText'] : null;

// get sorting columns
$iSortCol_0 = (int)$_REQUEST['iSortCol_0'];
$sColumns = trim($_REQUEST['sColumns']);
$arrCols = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort = 'plugin_imageviewer_category.label';
switch ($sortColumnName)
{
    case 'label':
        $sort = 'plugin_imageviewer_category.label';
        break;
    case 'key':
        $sort = 'plugin_imageviewer_category.key';
        break;
    case 'total_images':
        $sort = 'plugin_imageviewer_category.total_images';
        break;
}

$sqlClause = "WHERE 1=1 ";
if ($filterText)
{
    $filterText = strtolower($db->escape($filterText));
    $sqlClause .= "AND (LOWER(plugin_imageviewer_category.label) LIKE '%" .
        $filterText . "%' OR ";
    $sqlClause .= "LOWER(plugin_imageviewer_category.key) = '%" .
        $filterText . "%')";
}

$sQL = "SELECT plugin_imageviewer_category.*, (SELECT COUNT(plugin_imageviewer_category_file.id) FROM plugin_imageviewer_category_file WHERE plugin_imageviewer_category_file.category_id = plugin_imageviewer_category.id) AS total_images FROM plugin_imageviewer_category ";
$sQL .= $sqlClause . " ";
$totalRS = $db->getRows($sQL);

$sQL .= "ORDER BY " . $sort . " " . $sSortDir_0 . " ";
$sQL .= "LIMIT " . $iDisplayStart . ", " . $iDisplayLength;
$limitedRS = $db->getRows($sQL);

$data = array();
if (COUNT($limitedRS) > 0)
{
    foreach ($limitedRS as $row)
    {
        $lRow = array();
        $lRow[] = '<img src="assets/img/icons/128px.png" width="16" height="16" title="Category" alt="Category"/>';
        $lRow[] = adminFunctions::makeSafe($row['label']);
        $lRow[] = adminFunctions::makeSafe($row['key']);
        $lRow[] = adminFunctions::makeSafe($row['total_images']);

        $links = array();
        $links[] = '<a href="#" onClick="editCategory(' . (int)$row['id'] . '); return false;">edit</a>';
		$links[] = '<a href="#" onClick="return confirmRemoveCategory(' . (int)$row['id'] . ');">delete</a>';
        $lRow[] = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"] = intval($_GET['sEcho']);
$resultArr["iTotalRecords"] = (int)COUNT($totalRS);
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"] = $data;

echo json_encode($resultArr);
