<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// load theme functions
$themeObj = themeHelper::getLoadedInstance();
$themeSkin = $themeObj->getThemeSkin();

// for stats
$totalActiveImages = (int)file::getTotalActivePublicFiles();
$totalActiveAlbums = (int)fileFolder::getTotalActivePublicFolders();

// load image plugin functions
$imagePluginObj = pluginHelper::getInstance('imageviewer');
$imageCategories = $imagePluginObj->getImageCategories();

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');
?>
<!DOCTYPE html>
<html lang="en" dir="<?php echo SITE_LANGUAGE_DIRECTION == 'RTL' ? 'RTL' : 'LTR'; ?>" class="direction<?php echo SITE_LANGUAGE_DIRECTION == 'RTL' ? 'Rtl' : 'Ltr'; ?>">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title><?php echo validation::safeOutputToScreen(PAGE_NAME); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?></title>
        <meta name="description" content="<?php echo validation::safeOutputToScreen(PAGE_DESCRIPTION); ?>" />
        <meta name="keywords" content="<?php echo validation::safeOutputToScreen(PAGE_KEYWORDS); ?>" />
        <meta name="copyright" content="Copyright &copy; <?php echo date("Y"); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>" />
        <meta name="robots" content="all" />
        <meta http-equiv="Cache-Control" content="no-cache" />
        <meta http-equiv="Expires" content="-1" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php pluginHelper::includeAppends('main_page_header.php', array('file' => (isset($file) ? $file : null), 'Auth' => $Auth)); ?>
		
		<!-- Fav and touch icons -->
        <meta property="og:image" content="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/ms-icon-144x144.png" />
        <link rel="icon" type="image/x-icon" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/favicon.ico" />
        <link rel="icon" type="image/png" sizes="96x96" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/favicon-96x96.png">
        <link rel="apple-touch-icon" sizes="152x152" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-icon-152x152.png">
        <link rel="manifest" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/manifest.json">
        <meta name="msapplication-TileImage" content="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/ms-icon-144x144.png">
        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="theme-color" content="#ffffff">

        <!-- All Stylesheets -->
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/bootstrap.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/style.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/dark.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/custom.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/font-icons.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/animate.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/magnific-popup.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/responsive.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/file-upload.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/font-icons/font-awesome/css/font-awesome.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/font-icons/entypo/css/entypo.css" rel="stylesheet">
        <link href="<?php echo SITE_CSS_PATH; ?>/search_widget.css" rel="stylesheet">

        <?php if ($themeSkin): ?>
            <link href="<?php echo SITE_CSS_PATH; ?>/skins/<?php echo $themeSkin; ?>" rel="stylesheet">
        <?php endif; ?>
		<?php echo $themeObj->outputCustomCSSCode(); ?>

        <!--[if lt IE 9]>
        <script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
        <![endif]-->

        <script type="text/javascript" src="<?php echo SITE_THEME_PATH; ?>/frontend_assets/js/jquery.js"></script>
        <script type="text/javascript" src="<?php echo SITE_THEME_PATH; ?>/frontend_assets/js/plugins.js"></script>
        <script type="text/javascript" src="<?php echo SITE_THEME_PATH; ?>/frontend_assets/js/custom.js"></script>
        <script type="text/javascript" src="<?php echo SITE_THEME_PATH; ?>/js/handlebars.js"></script>
        <script type="text/javascript" src="<?php echo SITE_THEME_PATH; ?>/js/typeahead.bundle.js"></script>

        <script type="text/javascript">
            var WEB_ROOT = "<?php echo WEB_ROOT; ?>";
<?php echo translate::generateJSLanguageCode(); ?>
        </script>
        <?php
        // add js files, use the htmlHelper::addJsFile() function so files can be joined/minified
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.dataTables.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.tmpl.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/load-image.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/canvas-to-blob.min.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.iframe-transport.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-process.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-resize.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-validate.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-ui.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/zeroClipboard/ZeroClipboard.js');
        pluginHelper::addJsFile(SITE_JS_PATH . '/global.js');

        // output js
        pluginHelper::outputJs();
        ?>
    </head>
    <body class="stretched <?php if (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index') echo 'homepage-wrapper'; ?>">
		<?php
		// adblock notification, if enabled via the site settings
		include_once(SITE_TEMPLATES_PATH . '/partial/_ad_block.inc.php');
		?>
        <!-- Document Wrapper
        ============================================= -->
        <div id="wrapper" class="clearfix">

            <!-- Header
            ============================================= -->
            <header id="header" class="transparent-header full-header light <?php if (!defined('CURRENT_PAGE_KEY') || CURRENT_PAGE_KEY != 'index'): ?>sticky-header<?php endif; ?>">
                <div id="header-wrap">
                    <div class="container clearfix">

                        <div id="primary-menu-trigger"><i style="color:#fff;" class="icon-reorder"></i></div>

                        <!-- Logo
                        ============================================= -->
                        <div id="logo" class="responsive-logo">
                            <a href="<?php echo WEB_ROOT; ?>/index.html" class="standard-logo" data-light-logo="<?php echo $themeObj->getMainLogoUrl(); ?>"><img src="<?php echo $themeObj->getMainLogoUrl(); ?>" class="site-logo" alt="<?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>&nbsp;<?php echo t('logo', 'Logo'); ?>"></a>
                        </div><!-- #logo end -->

                        <!-- Primary Navigation
                        ============================================= -->
                        <nav id="primary-menu">

                            <ul class="one-page-menu">
								<?php if (UserPeer::getAllowedToUpload() == true): ?>
                                <li>
                                    <a href="#" onClick="showUploaderPopup(); return false;"><?php echo t('navigation_home_upload', 'UPLOAD'); ?>&nbsp;<i class="fa fa-upload"></i> </a>
                                </li>
								<?php endif; ?>

                                <li<?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index') ? ' class="current"' : ''; ?>>
                                    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><?php echo t('home_dropdown', ' HOME'); ?><i class="fa fa-caret-down"></i> </a>
                                    <ul role="menu">
                                        <li><a class="smooth-anchor-link" href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>#first-class-image-manager" hash="#first-class-image-manager" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('image_manager', 'Image Manager'); ?></a></li>
                                        <li><a class="smooth-anchor-link" href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>#powerful-features" hash="#powerful-features" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('powerful_features', 'Powerful Features'); ?></a></li>
                                        <li><a class="smooth-anchor-link" href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>#premium-access" hash="#premium-access" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('premium_access', 'Premium Access'); ?></a></li>
                                        <li><a class="smooth-anchor-link" href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>#get-started-now" hash="#get-started-now" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('get_started_now', 'Get Started Now'); ?></a></li>
                                        <?php if (!$Auth->loggedIn()): ?>
                                            <li><a class="external" href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('navigation_register', 'Register'); ?></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </li>
                                <li>
                                    <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/"><?php echo t('home_browse', ' BROWSE'); ?><?php if (COUNT($imageCategories)): ?><i class="fa fa-caret-down"></i> <?php endif; ?></a>
										<ul role="menu">
											<li>
												<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/"><?php echo t('navigation_images', 'Images'); ?><span class="badge badge-nav-homepage"><?php echo number_format($totalActiveImages, 0); ?></span></a></a>
											</li>
											<li>
												<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/albums/"><?php echo t('navigation_albums', 'Albums'); ?><span class="badge badge-nav-homepage"><?php echo number_format($totalActiveAlbums, 0); ?></span></a>
											</li>
											<li>
												<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/category/"><?php echo t('navigation_categories', 'Categories'); ?></a>
													<?php
													if (COUNT($imageCategories))
													{
													?>
													<ul role="menu">
														<?php
														foreach ($imageCategories AS $imageCategory) {
															?>
															<li><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/category/<?php echo validation::safeOutputToScreen($imageCategory['key']); ?>" tabindex="-1" role="menuitem"><i class="fa fa-caret-right"></i>&nbsp;<?php echo t('home_category_' . $imageCategory['key'], $imageCategory['label']); ?></a></li>
															<?php
														}
														?>
													</ul>
														<?php
													}
													?>
											</li>
										</ul>
                                </li>

<?php
// add any other navigation items
$headerNavigation = pluginHelper::generateHeaderNavStructure($headerNavigation, $Auth->level_id);

// format nagivation for template
$navigationHtmlItems = array();
foreach ($headerNavigation AS $headerNavigationItem) {
    // skip settings menu option
    if ($headerNavigationItem['link_key'] == 'settings') {
        continue;
    }

    $navHtml = '<li';
    if (defined('CURRENT_PAGE_KEY') && isset($headerNavigationItem['link_key']) && CURRENT_PAGE_KEY == $headerNavigationItem['link_key']) {
        $navHtml .= ' class="current"';
    }
    $navHtml .= '><a role="menuitem" tabindex="-1" class="external nav-shadow" href="' . $headerNavigationItem['link_url'] . '"';
    if (isset($headerNavigationItem['element_id'])) {
        $navHtml .= ' id="' . validation::safeOutputToScreen($headerNavigationItem['element_id']) . '"';
    }
    $navHtml .= '>' . validation::safeOutputToScreen(strtoupper($headerNavigationItem['link_text'])) . '</a></li>';

    if (isset($headerNavigationItem['wrap_html'])) {
        $navHtml = str_replace('[[[NAV_ITEM_HTML]]]', $navHtml, $headerNavigationItem['wrap_html']);
    }

    $navigationHtmlItems[] = $navHtml;
}

// output nav
echo implode('', $navigationHtmlItems);
?>
                            </ul>

                            <!-- Top Search
                            ============================================= -->
                            <div id="top-search" class="responsive-top-search">
                                <a href="#" id="top-search-trigger"><i class="icon-search3"></i><i class="icon-line-cross"></i></a>
                                <form action="<?php echo WEB_ROOT; ?>/search/" method="get" autocomplete="off">
									<input type="hidden" name="s" value="image"/>
                                    <input type="text" name="t" class="form-control typeahead" value="" placeholder="<?php echo t('search_type_and_hit_enter', 'Type & Hit Enter..'); ?>" autocomplete="off"/>
                                </form>
                            </div><!-- #top-search end -->
                        </nav><!-- #primary-menu end -->
                    </div>
                </div>
            </header><!-- #header end -->

<?php
// if not index page
if ((!defined('CURRENT_PAGE_KEY') || CURRENT_PAGE_KEY != 'index') && !defined('HIDE_SUB_TITLE_SECTION')):
    ?>

                <section id="page-title" class="page-headers page-title-<?php echo str_replace(array("_", " "), "-", CURRENT_PAGE_KEY); ?>">
                    <div class="container clearfix">
                        <h1><?php echo PAGE_NAME; ?></h1>
                <?php if ((defined('TITLE_DESCRIPTION_LEFT')) && (strlen(TITLE_DESCRIPTION_LEFT))): ?>
                            <span><?php echo TITLE_DESCRIPTION_LEFT ?></span>
                <?php endif; ?>
                    </div>
                </section>

                <section class="content">
                    <div class="content-wrap">
                        <div class="container">

<?php endif; ?>