<?php

// includes and security
define('MIN_ACCESS_LEVEL', 10); // allow moderators
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// get params
$existingCommentId = (int) $_REQUEST['existingCommentId'];
$editedComment = strip_tags(trim($_REQUEST['editedComment']));
$editedComment = str_replace(array("'", "\""), "", $editedComment);

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';

// validate submission
if(strlen($editedComment) == 0)
{
    $result['error'] = true;
    $result['msg'] = adminFunctions::t("plugin_comments_edit_no_content", "Please enter some content for the comment");
}
elseif(strlen($existingCommentId) == 0)
{
    $result['error'] = true;
    $result['msg'] = adminFunctions::t("plugin_comments_invalid_comment_id", "Invalid comment ID");
}
elseif(_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg'] = adminFunctions::t("no_changes_in_demo_mode");
}

// no errors
if(strlen($result['msg']) == 0)
{
    // update the existing record
    $dbUpdate = new DBObject("plugin_comments", array("content"), 'id');
    $dbUpdate->content = $editedComment;
    $dbUpdate->id = $existingCommentId;
    $dbUpdate->update();
    
    $result['error'] = false;
    $result['msg'] = 'Comment Updated.';
}

echo json_encode($result);
exit;
