﻿<?php
// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');
define('MIN_ACCESS_LEVEL', 10); // allow moderators
// make sure we have the comment to edit
if(!isset($_REQUEST['gEditCommentId']))
{
    $result = array();
    $result['error'] = true;
    $result['msg'] = 'Comment not found.';
    echo json_encode($result);
    exit;
}

// load comment & associated user stuff & filename from the passed variable
$commentId = (int) $_REQUEST['gEditCommentId'];
$comment = $db->getRow("SELECT plugin_comments.*, file.originalFilename, users.username, users.level_id AS package_id FROM plugin_comments LEFT JOIN users ON plugin_comments.userId = users.id LEFT JOIN file ON plugin_comments.fileId = file.id WHERE plugin_comments.id = '" . (int) $commentId . "' LIMIT 1");

if(!$comment)
{
    $result = array();
    $result['error'] = true;
    $result['msg'] = 'Comment not found.';
    echo json_encode($result);
    exit;
}

$levelId = UserPeer::getLevelIdFromPackageId($comment['package_id']);
switch($levelId)
{
    case '20':
        $group = 'Admin';
        break;
    case '10':
        $group = 'Moderator';
        break;
    case '2':
        $group = 'Paid User';
        break;
    case '1':
        $group = 'Free User';
        break;
    default:
        $group = 'Guest';
        break;
}

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';
$result['html'] = '<p style="padding-bottom: 4px;">Use the form below to edit the comment.</p>
					<span id="popupMessageContainer"></span>
					<form id="editCommentForm" class="form-horizontal form-label-left input_mask">';

$result['html'] .= '<table class="table table-data-list" style="margin-top: 0px;"><tbody>';
$result['html'] .= '<tr>
                        <td>Filename:</td>
                        <td>' . validation::safeOutputToScreen($comment['originalFilename']) . '</td>
                </tr>';

$result['html'] .= '<tr>
                        <td>Comment By:</td>
                        <td>' . ($comment['username'] ? validation::safeOutputToScreen($comment['username']) : adminFunctions::t('plugin_comments_edit_comment_anonymous', 'Anonymous')) . '&nbsp;(' . $group . ')</td>
                </tr>';

$result['html'] .= '<tr>
                        <td>IP Address:</label>
                        <td>' . validation::safeOutputToScreen($comment['ipAddress']) . '</td>
                </tr>';

$result['html'] .= '<tr>
                        <td>Date:</label>
                        <td>' . coreFunctions::formatDate($comment['dateAdded']) . '</td>
                </tr>';
$result['html'] .= '</tbody></table>';

$result['html'] .= '<div class="form">';
$result['html'] .= '<div class="form-group">
						<label class="control-label col-md-3 col-sm-3 col-xs-12">Comment:</label>
						<div class="col-md-9 col-sm-9 col-xs-12">
							<textarea name="editedComment" id="editedComment" class="form-control" rows="5">' . validation::safeOutputToScreen($comment['content']) . '</textarea>
						</div>
					</div>
					</form>';

echo json_encode($result);
exit;
