<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

$iDisplayLength = (int) $_REQUEST['iDisplayLength'];
$iDisplayStart = (int) $_REQUEST['iDisplayStart'];
$sSortDir_0 = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";
$filterText = strlen($_REQUEST['filterText']) ? $_REQUEST['filterText'] : '';
$filterFileText = strlen($_REQUEST['filterFileText']) ? $_REQUEST['filterFileText'] : '';
$filterByStatus = strlen($_REQUEST['filterByStatus']) ? $_REQUEST['filterByStatus'] : '';

// get sorting columns
$iSortCol_0 = (int) $_REQUEST['iSortCol_0'];
$sColumns = trim($_REQUEST['sColumns']);
$arrCols = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort = 'dateAdded';

switch($sortColumnName)
{
    case 'date':
        $sort = 'plugin_comments.dateAdded';
        break;
    case 'status':
        $sort = 'plugin_comments.status';
        break;
}
$sqlClause = 'WHERE 1=1';

if($filterText)
{
    $sqlClause .= " AND users.username = " . $db->quote($filterText);
}
if($filterFileText)
{
    $sqlClause .= " AND file.originalFilename = " . $db->quote($filterFileText);
}
if($filterByStatus)
{
    $sqlClause .= " AND plugin_comments.status = " . $db->quote($filterByStatus);
}
$totalRS = $db->getValue("SELECT COUNT(plugin_comments.id) AS total FROM plugin_comments LEFT JOIN users ON plugin_comments.userId = users.id " . $sqlClause);
$limitedRS = $db->getRows("SELECT plugin_comments.*, users.username, file.originalFilename FROM plugin_comments LEFT JOIN users ON plugin_comments.userId = users.id LEFT JOIN file ON plugin_comments.fileId = file.id " . $sqlClause . " ORDER BY " . $sort . " " . $sSortDir_0 . " LIMIT " . $iDisplayStart . ", " . $iDisplayLength);

$data = array();
if(COUNT($limitedRS) > 0)
{
    foreach($limitedRS AS $comments)
    {
        $total = $db->getValue("SELECT COUNT(plugin_comments_reports.id) FROM plugin_comments_reports WHERE plugin_comments_reports.comId = " . $comments['id'] . " GROUP BY plugin_comments_reports.comId");
        $lRow = array();

        // Multi use checkbox
        $lRow[] = '<input type="checkbox" id="cbElement[]" name="table_records" value="' . $comments['id'] . '" class="checkbox flat"/>';

        // Shows the status by image, green = active, red = pending, = blue = has reports
        if($comments['status'] == 'pending' && ($total == '0' || !$total))
        {
            $lRow[] = '<img src="../assets/img/icons/pending.png" width="16" height="16" title="Pending Approval" alt="Pending Approval"/>';
        }
        elseif($comments['status'] == 'active' && ($total == '0' || !$total))
        {
            $lRow[] = '<img src="../assets/img/icons/approved.png" width="16" height="16" title="Approved Comment" alt="Approved Comment"/>';
        }
        elseif($total >= '1')
        {
            $lRow[] = '<img src="../assets/img/icons/info.png" width="16" height="16" title="' . $total . ' report' . ($total >= '2' ? 's' : '') . ' for this comment" alt="' . $total . ' report' . ($total >= '2' ? 's' : '') . ' for this comment"/>';
        }

        // Date the comment was added
        $lRow[] = coreFunctions::formatDate($comments['dateAdded'], SITE_CONFIG_DATE_TIME_FORMAT);

        // Limited view of the comment
        $lRow[] = validation::safeOutputToScreen($comments['content'], '', '155');

        // User Details
        $lRow[] = strlen($comments['username']) ? ('<a href="' . ADMIN_WEB_ROOT . '/user_edit.php?id=' . $comments['userId'] . '" target="_blank">' . $comments['username'] . '</a>') : '<span style="color: #777777;">[Anonymous]</span><br/><span style="color: #777777;font-size:11px;">' . $comments['ipAddress'] . '</span>';

        // Status (pending|active)
        $lRow[] = UCWords(str_replace("_", " ", $comments['status']));

        // Action links
        $links = array();
        $links[] = '<a href="#" onClick="editComment(' . (int) $comments['id'] . '); return false;">' . ($total >= '1' ? 'Review' : 'Edit') . '</a>';

        if($comments['status'] == 'pending')
        {
            $links[] = '<a href="overview.php?approve=' . $comments['id'] . '" onClick="return confirm(\'Are you sure you want to approve this comment?\');">Approve</a>';
        }
        if($comments['status'] == 'active')
        {
            $links[] = '<a href="overview.php?pending=' . $comments['id'] . '" onClick="return confirm(\'Are you sure you want to change this comments status?\');">Set Pending</a>';
        }
        $links[] = '<a href="overview.php?delete=' . $comments['id'] . '" onClick="return confirm(\'Are you sure you want to delete this comment?\');">Delete</a>';
        $lRow[] = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"] = intval($_GET['sEcho']);
$resultArr["iTotalRecords"] = (int) $totalRS;
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"] = $data;

echo json_encode($resultArr);
