<?php

// includes and security
define('MIN_ACCESS_LEVEL', 10); // allow moderators
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

log::setContext('plugin_comments_admin_process_reports_delete');

// get params
$rSelect = $_REQUEST['rSelect'];
$comId	 = (int) $_REQUEST['comId'];
log::info('Selected Reports: '. implode(', ', $rSelect));
log::info('Selected Comment: '. $comId);

// prepare result
$result          = array();
$result['error'] = false;
$result['msg']   = '';

// Validate submission
if (count($rSelect) == 0 || strlen($comId) == 0)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("plugin_comments_delete_report_nothing_select", "You didn't select anything to delete");
}
if (_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("no_changes_in_demo_mode");
}

if ($result['error'] === false)
{
    log::info('rSelect: '.print_r($rSelect, true));
	if(is_array($rSelect))
	{		
		foreach($rSelect AS $rs)
		{
			$db->query("DELETE FROM plugin_comments_reports WHERE id = ".(int)$rs);
		}	
		$db->query("UPDATE plugin_comments SET reports = reports - ".COUNT($rSelect)." WHERE id = ".(int)$comId);		
		$result['error'] = false;
		$result['msg']   = adminFunctions::t('plugin_comments_reports_successfully_deleted', 'The selected reports was successfully deleted.');
		log::info('Updated Comment ID: '.$comId);
	}
}

echo json_encode($result);
log::info('Encoded Message: '.json_encode($result));
exit;