<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Comments Overview');
define('ADMIN_SELECTED_PAGE', '');
define('ADMIN_SELECTED_SUB_PAGE', 'plugin_comments_menu_overview');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// process submits
// Approve pending comments
if(isset($_REQUEST['approve']) || $_REQUEST['cbElement'] && $_REQUEST['auth'] == '1')
{
    $app = (int) $_REQUEST['approve'];
    $arr = $_REQUEST['cbElement'];
    if(is_array($arr))
    {
        foreach($arr AS $item)
        {
            $db->query("UPDATE plugin_comments SET status = 'active' WHERE id = " . (int) $item . " LIMIT 1");
        }
        adminFunctions::setSuccess(t('plugin_comments_comment_approved_multi', 'Comments approved.'));
    }
    elseif(!is_array($arr) || $app)
    {
        $db->query("UPDATE plugin_comments SET status = 'active' WHERE id = " . (int) ($app ? $app : $arr) . " LIMIT 1");
        adminFunctions::setSuccess(t('plugin_comments_comment_approved', 'Comment approved.'));
    }
    elseif(empty($arr) || empty($app))
    {
        adminFunctions::setError(t('plugin_comments_blank_selection_approve', 'you didn\'t select anything to approve.'));
    }
}
// Set comments to pending
elseif(isset($_REQUEST['pending']) || $_REQUEST['cbElement'] && $_REQUEST['pend'] == '1')
{
    $pen = (int) $_REQUEST['pending'];
    $arr = $_REQUEST['cbElement'];
    if(is_array($arr))
    {
        foreach($arr AS $item)
        {
            $db->query("UPDATE plugin_comments SET status = 'pending' WHERE id = " . (int) $item . " LIMIT 1");
        }
        adminFunctions::setSuccess(t('plugin_comments_comment_pending_multi', 'Comments status changed to "pending".'));
    }
    elseif(!is_array($arr) || $pen)
    {
        $db->query("UPDATE plugin_comments SET status = 'pending' WHERE id = " . (int) ($arr ? $arr : $pen) . " LIMIT 1");
        adminFunctions::setSuccess(t('plugin_comments_comment_pending', 'Comment status changed to "pending".'));
    }
    elseif(empty($arr) || empty($pen))
    {
        adminFunctions::setError(t('plugin_comments_blank_selention_pending', 'you didn\'t select anything to set as pending.'));
    }
}
// Delete Comments
elseif(isset($_REQUEST['delete']) || $_REQUEST['cbElement'] && $_REQUEST['del'] == '1')
{
    $sin = (int) $_REQUEST['delete'];
    $mul = $_REQUEST['cbElement'];
    if(is_array($mul))
    {
        foreach($mul as $item)
        {
            $db->query("DELETE FROM plugin_comments WHERE id = " . (int) $item);
            $db->query("DELETE FROM plugin_comments_reports WHERE comId = " . (int) $item);
        }
        adminFunctions::setSuccess(t('plugin_comments_comment_deleted_multi', 'Comments deleted.'));
    }
    elseif(!is_array($mul) || $sin)
    {
        $db->query("DELETE FROM plugin_comments WHERE id = " . (int) ($mul ? $mul : $sin));
        $db->query("DELETE FROM plugin_comments_reports WHERE comId = " . (int) ($mul ? $mul : $sin));
        adminFunctions::setSuccess(t('plugin_comments_comment_deleted', 'Comment deleted.'));
    }
    elseif(empty($sin) || empty($mul))
    {
        adminFunctions::setError(t('plugin_comments_blank_selection_delete', 'you didn\'t select anything to delete.'));
    }
}
// overview stats
$totalApproved = (int) $db->getValue("SELECT COUNT(fileId) AS total FROM plugin_comments WHERE status = 'active'");
$totalPending = (int) $db->getValue("SELECT COUNT(fileId) AS total FROM plugin_comments WHERE status = 'pending'");
$reportedComments = (int) $db->numRows("SELECT COUNT(id) FROM plugin_comments_reports GROUP BY comId");
$totalComments = (int) $db->getValue("SELECT COUNT(fileId) AS total FROM plugin_comments");
$totalCommentsLast7Days = (int) $db->getValue("SELECT COUNT(fileId) AS total FROM plugin_comments WHERE dateAdded BETWEEN NOW() - INTERVAL 7 DAY AND NOW()");
$totalCommentsLast30Days = (int) $db->getValue("SELECT COUNT(fileId) AS total FROM plugin_comments WHERE dateAdded BETWEEN NOW() - INTERVAL 30 DAY AND NOW()");
// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
// load all status
$statusDetails = array('pending', 'active');
?>
<script>
    oTable = null;
    gRewardId = null;
    $(document).ready(function () {
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/overview.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[1, "desc"]],
            "aoColumns": [
                {bSortable: false, sWidth: '3%', sName: 'checkbox', sClass: "center adminResponsiveHide"},
                {bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide"},
                {sName: 'date', sWidth: '15%', sClass: "center dataTableFix"},
                {bSortable: false, sName: 'comment', sClass: "adminResponsiveHide"},
                {bSortable: false, sWidth: '12%', sName: 'author', sClass: "center adminResponsiveHide"},
                {sName: 'status', sWidth: '12%', sClass: "center adminResponsiveHide"},
                {bSortable: false, sWidth: '17%', sClass: "center"}
            ],
            "fnServerData": function (sSource, aoData, fnCallback) {
                aoData.push({"name": "filterText", "value": $('#filterText').val()});
                aoData.push({"name": "filterFileText", "value": $('#filterFileText').val()});
                aoData.push({"name": "filterByStatus", "value": $('#filterByStatus').val()});
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": sSource,
                    "data": aoData,
                    "success": fnCallback
                });
            },
            "fnDrawCallback": function (oSettings) {
                postDatatableRender();
            },
            "oLanguage": {
                "sEmptyTable": "There are no items in the current filters."
            },
            dom: "lBfrtip",
            buttons: [
                {
                    extend: "copy",
                    className: "btn-sm"
                },
                {
                    extend: "csv",
                    className: "btn-sm"
                },
                {
                    extend: "excel",
                    className: "btn-sm"
                },
                {
                    extend: "pdfHtml5",
                    className: "btn-sm"
                },
                {
                    extend: "print",
                    className: "btn-sm"
                }
            ]
        });
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
    });
    
    function editComment(id)
    {
        gEditCommentId = id;
        showBasicModal('Loading...', 'Edit Comment', '<button type="button" class="btn btn-primary" onClick="processEditComment(); return false;">Update Comment</button>');
        loadEditCommentForm();
    }
    
    function loadEditCommentForm()
    {
        $('#editCommentFormInner').html('');
        $.ajax({
            type: "POST",
            url: "ajax/edit_comment_form.ajax.php",
            data: {gEditCommentId: gEditCommentId},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    setBasicModalContent(json.msg);
                } else
                {
                    setBasicModalContent(json.html);
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                setBasicModalContent(textStatus + ': ' + errorThrown);
            }
        });
    }
    
    function reloadTable()
    {
        oTable.fnDraw();
    }
    
    $(function () {
        $('#select-all').click(function (event) {
            if (this.checked) {
                $(':checkbox').each(function () {
                    this.checked = true;
                });
            }
            if (!this.checked) {
                $(':checkbox').each(function () {
                    this.checked = false;
                });
            }
        });
    });
    
    function processEditComment()
    {
        // get data
        editedComment = $('#editedComment').val();
        existingCommentId = gEditCommentId;
        $.ajax({
            type: "POST",
            url: "ajax/comment_edit_process.ajax.php",
            data: {existingCommentId: existingCommentId, editedComment: editedComment},
            dataType: 'json',
            success: function (json) {
                if (json.error == true)
                {
                    showError(json.msg, 'popupMessageContainer');
                } else
                {
                    showSuccess(json.msg);
                    reloadTable();
                    hideModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(textStatus + ': ' + errorThrown, 'popupMessageContainer');
            }
        });
    }
    
    function updateButtonText() {
        // do nothing
    }
</script>


<!-- page content -->
<div class="right_col" role="main">
    <div class="">
        <!-- top tiles -->
        <div class="row tile_count">
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-trophy"></i> Approved Comment<?php echo ($totalApproved >= '2' || $totalApproved == '0' ? 's' : ''); ?></span>
                <div class="count green"><?php echo $totalApproved; ?></div>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-trophy"></i> Pending Comment<?php echo ($totalPending >= '2' || $totalPending == '0' ? 's' : ''); ?></span>
                <div class="count green"><?php echo $totalPending; ?></div>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count" onclick="location.href = '<?php echo PLUGIN_WEB_ROOT . '/comments/admin/'; ?>reports.php';" style="cursor: pointer;">
                <span class="count_top"><i class="fa fa-trophy"></i> Reported Comment<?php echo ($reportedComments >= '2' || $reportedComments == '0' ? 's' : ''); ?></span>
                <div class="count green"><?php echo $reportedComments; ?></div>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-trophy"></i> Total Comments</span>
                <div class="count green"><?php echo $totalComments; ?></div>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-trophy"></i> Comments Past 7 Days</span>
                <div class="count green"><?php echo $totalCommentsLast7Days; ?></div>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-trophy"></i> Comments Past 30 Days</span>
                <div class="count green"><?php echo $totalCommentsLast30Days; ?></div>
            </div>
            <div class="clear"></div>
        </div>
        <!-- /top tiles -->

        <div class="row clearfix">
            <div class="x_panel">
                <div class="x_title"><h2>By User</h2><div class="clearfix"></div></div>
                <form method="POST" enctype="multipart/form-data" action="overview.php" name="form">
                    <div class="x_content responsiveTable">
                        <?php echo adminFunctions::compileNotifications(); ?>
                        <table id='fileTable' class="table table-striped table-only-border dtLoading bulk_action">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="check-all" class="flat"/></th>
                                    <th></th>
                                    <th><?php echo adminFunctions::t('plugin_comments_date_added', 'Date Added'); ?></th>
                                    <th class="align-left"><?php echo adminFunctions::t('plugin_comments_comment', 'Comment'); ?></th>
                                    <th><?php echo adminFunctions::t('plugin_comments_author', 'Author'); ?></th>
                                    <th><?php echo adminFunctions::t('plugin_comments_status', 'Status'); ?></th>
                                    <th><?php echo adminFunctions::t('plugin_comments_actions', 'Actions'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>

                    <div class="x_panel">
                        <div class="btn-group">
                            <button name="auth" id="auth" type="submit" value="1" class="btn btn-primary" onClick="return confirm('Are you sure you want to approve the selected comments?');"><?php echo adminFunctions::t('plugin_comments_approve_selected', 'Approve Selected'); ?></button>
                            <button name="pend" id="pend" type="submit" value="1" class="btn btn-primary" onClick="return confirm('Are you sure you want to change this comments status?');"><?php echo adminFunctions::t('plugin_comments_set_pending', 'Set Selected Pending'); ?></button>
                        </div>
                        <div class="btn-group">
                            <button name="del" id="del" type="submit" value="1" class="btn btn-disabled" onClick="return confirm('Are you sure you want to delete the selected comments?');"><?php echo adminFunctions::t('plugin_comments_delete_selected', 'Delete Selected'); ?></button>
                        </div>
                    </div>
                    
                    <input type="hidden" name="submitted" value="1"/>
                </form>
            </div>
        </div>
        
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        By Author:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable(); return false;" style="width: 160px;" class="form-control input-sm"/>
    </label>
    <label style="padding-left: 6px;">
        By Filename:
        <input name="filterFileText" id="filterFileText" type="text" onKeyUp="reloadTable();
                return false;" style="width: 160px;" class="form-control input-sm"/>
    </label>
    <label class="adminResponsiveHide filterByServerWrapper" style="padding-left: 6px;">
        By Status:
        <select name="filterByStatus" id="filterByStatus" onChange="reloadTable();
                return false;" style="width: 120px;" class="form-control input-sm"/>
        <option value="">- all -</option>
        <?php
        if(COUNT($statusDetails))
        {
            foreach($statusDetails AS $statusDetail)
            {
                echo '<option value="' . $statusDetail . '"';
                if(($filterByStatus) && ($filterByStatus == $statusDetail))
                {
                    echo ' SELECTED';
                }
                echo '>' . UCWords(str_replace("_", " ", $statusDetail)) . '</option>';
            }
        }
        ?>
        </select>
    </label>
</div>
<div id="editCommentForm" title="Edit Comment">
    <span id="editCommentFormInner"></span>
</div>
</div>
<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>