<?php
// available params
// $params['iconUrl']
// $params['fileArr']

// load plugin details
$pluginObj = pluginHelper::getInstance('imageviewer');

// check this is an image
$fileObj = file::hydrate($params['fileArr']);
if ($fileObj->isImage())
{
    // only for active files
    if($params['fileArr']['statusId'] == 1)
    {
        $w = 99;
        if((int)$params['width'])
        {
            $w = (int)$params['width'];
        }
        
        $h = 60;
        if((int)$params['height'])
        {
            $h = (int)$params['height'];
        }
        
        $m = 'middle';
        if(trim($params['type']))
        {
            $m = trim($params['type']);
        }
		
        $o = 'jpg';
        if(in_array($params['fileArr']['extension'], $pluginObj->getAnimatedFileExtensions()))
        {
            $o = 'gif';
        }
        
        //$params['iconUrl'] = _CONFIG_SITE_PROTOCOL . '://' . file::getFileDomainAndPath($params['fileArr']['id'], $params['fileArr']['serverId'], true) . '/' . PLUGIN_DIRECTORY_NAME . '/imageviewer/site/resize_image_inline.php?f='.($params['fileArr']['id']).'&w='.$w.'&h='.$h.'&m='.$m;
        $params['iconUrl'] = $pluginObj->createImageCacheUrl($params['fileArr'], $w, $h, $m, $o);
    }
}
