<?php

// site includes
require_once('../../../../core/includes/master.inc.php');

// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

//setup database
$db = Database::getDatabase();

// load plugin details
$pluginObj = pluginHelper::getInstance('imageviewer');

// load files and check ownership
$fileId = (int)$_REQUEST['fileId'];
$dir    = trim($_REQUEST['dir']);
if(!in_array($dir, array('r', 'l')))
{
	// exit
    coreFunctions::output404();
}

// make sure the logged in user owns the files
$file = file::loadById($fileId);
if ($file->userId != $Auth->id)
{
    // exit
    coreFunctions::output404();
}

if (_CONFIG_DEMO_MODE == true)
{
    notification::setError(t("no_changes_in_demo_mode"));
}

// no errors
if (!notification::isErrors())
{
    // get server path and make secure request to rotate
	$rotateRequestUrl = crossSiteAction::appendUrl(_CONFIG_SITE_PROTOCOL . '://' . file::getFileDomainAndPath($file->id, $file->serverId, true) . '/' . PLUGIN_DIRECTORY_NAME.'/imageviewer/site/ajax/_account_image_rotate_final.ajax.php?fileId='.(int)$file->id.'&dir='.$dir);

	// request
	$rs = coreFunctions::getRemoteUrlContent($rotateRequestUrl);
	if (!$rs)
    {
		// error
		notification::setError(t("problem_updating_item", "There was a problem updating the item, please try again later."));
    }
    else
    {
		$rsArr = json_decode($rs, true);
		if(!is_array($rsArr))
		{
			// error
			notification::setError(t("problem_updating_item", "There was a problem updating the item, please try again later."));
		}
		else
		{
			// success
			notification::setSuccess(t('plugin_imageviewer_image_rotated', 'Image rotated.'));
		}
    }
}

// prepare result
$returnJson            = array();
$returnJson['success'] = false;
$returnJson['msg']     = t("problem_updating_item", "There was a problem updating the item, please try again later.");
if (notification::isErrors())
{
    // error
    $returnJson['success'] = false;
    $returnJson['msg']     = implode('<br/>', notification::getErrors());
}
else
{
    // success
    $returnJson['success'] = true;
    $returnJson['msg']     = implode('<br/>', notification::getSuccess());
}
$returnJson['fileId'] = $fileId;

$o = 'jpg';
if(in_array($file->extension, $pluginObj->getAnimatedFileExtensions()))
{
    $o = 'gif';
}
$returnJson['fileThumb'] = $pluginObj->createImageCacheUrl((array)$file, 280, 280, 'middle', $o);

echo json_encode($returnJson);