<?php

// validation
$fileId = (int) $_REQUEST['f'];
$uniqueHash = !isset($_REQUEST['uh']) ? null : $_REQUEST['uh'];
$embedToken = !isset($_REQUEST['idt']) ? null : $_REQUEST['idt'];
$width = (int) $_REQUEST['w'];
$height = (int) $_REQUEST['h'];
$method = isset($_REQUEST['m']) ? $_REQUEST['m'] : '';
if(($method != 'padded') && ($method != 'middle') && ($method != 'maximum'))
{
    $method = 'cropped';
}
$outputFormat = isset($_REQUEST['o']) ? $_REQUEST['o'] : 'jpg';

// support only jpg or gif output
if($outputFormat != 'gif')
{
    $outputFormat = 'jpg';
}

// validate width & height
if($width <= 0)
{
    $width = 8;
}
if($height <= 0)
{
    $height = 8;
}

// memory saver
if(($width > 5000) || ($height > 5000))
{
    // fail
    coreFunctions::redirect($pluginObj->getDefaultImageWebPath());
}

// check and show cache before loading environment
$cacheFilePath = '../../../core/cache/plugins/imageviewer/';
$cacheFilePath .= $fileId . '/';
if($uniqueHash != null)
{
    $cacheFilePath .= $uniqueHash . '/';
}
if(!file_exists($cacheFilePath))
{
    mkdir($cacheFilePath, 0777, true);
}
$cacheFileName = (int) $width . 'x' . (int) $height . '_' . $method . '.' . $outputFormat;
$fullCachePath = $cacheFilePath . $cacheFileName;

// setup includes
require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginObj = pluginHelper::getInstance('imageviewer');
$pluginDetails = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// try to load the file object
$file = null;
if($fileId)
{
    $file = file::loadById($fileId);
}

// load file details
if(!$file)
{
    // fail
    coreFunctions::redirect($pluginObj->getDefaultImageWebPath());
}

// make sure it's an image
if(!$file->isImage())
{
    // fail
    coreFunctions::redirect($pluginObj->getDefaultImageWebPath());
}

// check if file needs a password
$album = null;
if($Auth->id != $file->userId)
{
    if($file->folderId !== NULL)
    {
        $album = $file->getFolderData();
    }
    if(($album) && (strlen($album->accessPassword) > 0))
    {
        // see if we have it in the session already
        $askPassword = true;
        if(!isset($_SESSION['folderPassword']))
        {
            $_SESSION['folderPassword'] = array();
        }
        elseif(isset($_SESSION['folderPassword'][$album->id]))
        {
            if($_SESSION['folderPassword'][$album->id] == $album->accessPassword)
            {
                $askPassword = false;
            }
        }

        if($askPassword)
        {
            // redirect to main page which requests for a password
            coreFunctions::redirect(file::getFileUrl($file->id));
        }
    }
}

if((int) $pluginSettings['caching'] == 1)
{
    // cache paths
    $cacheFilePath = 'plugins/imageviewer/';
    $cacheFilePath .= $fileId . '/';
    if($uniqueHash != null)
    {
        $cacheFilePath .= $uniqueHash . '/';
    }
    $cacheFileName = (int) $width . 'x' . (int) $height . '_' . $method . '.' . $outputFormat;
    $fullCachePath = $cacheFilePath . $cacheFileName;
}

// check for cache
//if(((int) $pluginSettings['caching'] == 0) || (!cache::checkCacheFileExists($fullCachePath)))
if(1==1)
{
    // load content from main image
    $contents = '';
    $imageExtension = $file->extension;

    // figure out if we're resizing to animated or static
    $processAsAnimated = false;
    if((in_array($file->extension, $pluginObj->getAnimatedFileExtensions())) && ($outputFormat == 'gif'))
    {
        // should we show all gifs as animated, including thumbnails? (option in plugin settings)
        if($pluginSettings['animate_gif_thumbnails'] == 1)
        {
            $processAsAnimated = true;
        }
        // only large images should be shown as animated
        elseif(($width >= $pluginObj->getHoldingCacheSize()) || ($height >= $pluginObj->getHoldingCacheSize()))
        {
            $processAsAnimated = true;
        }
    }

    // create holding cache, if it doesn't already exist
    $pluginObj->setupImageMetaAndCache($file);

    // ignore for animated file types, i.e. use the original image
    if(in_array($file->extension, $pluginObj->getAnimatedFileExtensions()) == false)
    {
        if(($width <= $pluginObj->getHoldingCacheSize()) && ($height <= $pluginObj->getHoldingCacheSize()))
        {
            $contents = $pluginObj->getHoldingCache($file);
            if($contents)
            {
                $imageExtension = $outputFormat;
            }
        }
    }

    if(!strlen($contents))
    {
        // use original image
        $contents = $file->download(false);
    }

    // prep watermark
    $hasWatermark = false;
    if(((int) $pluginSettings['watermark_enabled'] == 1) && ($width > 310))
    {
        // load watermark image
        $watermark = $db->getRow("SELECT file_name, image_content FROM plugin_imageviewer_watermark LIMIT 1");
        if($watermark)
        {
            if(!empty($watermark['image_content']))
            {
                // save in tmp
                $tmpWMFile = tempnam('/tmp', 'img-');
                $tmp = fopen($tmpWMFile, 'w+');
                fwrite($tmp, $watermark['image_content']);
                fclose($tmp);

                $hasWatermark = true;
            }
        }
    }

    // GD
    if($pluginObj->getImageLibrary() == 'gd')
    {
        // load image 
        include(DOC_ROOT . '/core/includes/image_resizer/CustomSimpleImage.php');
        $img = new CustomSimpleImage();
        $rs = $img->load_from_image_content($contents);
        if(!$rs)
        {
            // fail
            coreFunctions::redirect($pluginObj->getDefaultImageWebPath());
        }

        if($method == 'middle')
        {
            $img->thumbnail($width, $height);
        }
        elseif($method == 'padded')
        {
            $img->padded_image($width, $height);
        }
        elseif($method == 'cropped')
        {
            $img->best_fit($width, $height);
        }
        else
        {
            $img->resize($width, $height);
        }

        // add on the watermark after resizing
        if($hasWatermark == true)
        {
            // apply watermark
            $img->apply_watermark($tmpWMFile, $pluginSettings['watermark_position'], (int) $pluginSettings['watermark_padding'], (int) $pluginSettings['watermark_padding']);

            // clear wm cache
            @unlink($tmpWMFile);
        }
    }
    // Imagemagick
    else
    {
        $tmpStorage = uploader::getLocalTempStorePath();
        $tmpImageFile = $tmpStorage . 'tmp-' . MD5(microtime()) . '.' . $imageExtension;
        $tmpImage = fopen($tmpImageFile, 'w+');
        fwrite($tmpImage, $contents);
        fclose($tmpImage);

        // start Imagick
        try
        {
            $imagick = new Imagick($tmpImageFile);
        }
        catch(Exception $e)
        {
            unlink($tmpImageFile);
            log::outputFormattedError((array) $e);
            log::error(print_r($e, true));
            exit;
        }

        // set the background to white
        $imagick->setImageBackgroundColor('white');

        // set as jpg/gif
        if(($processAsAnimated == false) && in_array($file->extension, $pluginObj->getAnimatedFileExtensions()))
        {
            // get first frame for static preview
            $firstFrameImagick = $imagick->coalesceImages();
            foreach($firstFrameImagick as $k => $frame)
            {
                if($k == 0)
                {
                    $imagick = $frame;
                }
            }
        }
        elseif($processAsAnimated == false)
        {
            // flatten the image to remove layers and transparency
            $imagick = $imagick->flattenImages();
        }

        // remove any meta data for privacy
        $imagick->stripImage();

        // set output format
        $imagick->setImageFormat($outputFormat == 'jpg' ? 'jpeg' : $outputFormat);
        $imagick->setCompressionQuality($pluginObj->getThumbnailImageQuality());

        // resize
        if($method == 'middle')
        {
            if($processAsAnimated == true)
            {
                $imagick = $imagick->coalesceImages();
                foreach($imagick as $frame)
                {
                    $frame->cropThumbnailImage($width, $height);
                }
                $imagick = $imagick->deconstructImages();
            }
            else
            {
                $imagick->cropThumbnailImage($width, $height);
            }
        }
        elseif($method == 'padded')
        {
            if($processAsAnimated == true)
            {
                $imagick = $imagick->coalesceImages();
                foreach($imagick as $frame)
                {
                    $frame->scaleImage($width, $height, true);
                    $frame->setImageBackgroundColor('white');
                    $w = $frame->getImageWidth();
                    $h = $frame->getImageHeight();
                    $frame->extentImage($width, $height, ($w - $width) / 2, ($h - $height) / 2);
                }
                $imagick = $imagick->deconstructImages();
            }
            else
            {
                $imagick->scaleImage($width, $height, true);
                $imagick->setImageBackgroundColor('white');
                $w = $imagick->getImageWidth();
                $h = $imagick->getImageHeight();
                $imagick->extentImage($width, $height, ($w - $width) / 2, ($h - $height) / 2);
            }
        }
        elseif($method == 'cropped')
        {
            // get image dimensions
            $w = $imagick->getImageWidth();
            $h = $imagick->getImageHeight();

            if($processAsAnimated == true)
            {
                $imagick = $imagick->coalesceImages();
                foreach($imagick as $frame)
                {
                    // check width
                    if($w > $width)
                    {
                        $frame->thumbnailImage($width, null, 0);
                    }

                    // check height
                    if($h > $height)
                    {
                        $frame->thumbnailImage(null, $height, 0);
                    }
                }
                $imagick = $imagick->deconstructImages();
            }
            else
            {
                // check width
                if($w > $width)
                {
                    $imagick->thumbnailImage($width, null, 0);
                }

                // check height
                if($h > $height)
                {
                    $imagick->thumbnailImage(null, $height, 0);
                }
            }
        }
        else
        {
            if($processAsAnimated == true)
            {
                $imagick = $imagick->coalesceImages();
                foreach($imagick as $frame)
                {
                    $frame->scaleImage($width, $height, true);
                }
                $imagick = $imagick->deconstructImages();
            }
            else
            {
                $imagick->scaleImage($width, $height, true);
            }
        }

        // add on the watermark after resizing
        if(($hasWatermark == true) && ($processAsAnimated == false))
        {
            // open the watermark
            $watermark = new Imagick();
            $watermark->readImage($tmpWMFile);

            // calculate watermark positions
            $posArr = $pluginObj->calculateWatermarkPosition($pluginSettings['watermark_position'], $imagick->getImageWidth(), $imagick->getImageHeight(), $watermark->getImageWidth(), $watermark->getImageHeight(), (int) $pluginSettings['watermark_padding'], (int) $pluginSettings['watermark_padding']);

            // apply watermark
            $imagick->compositeImage($watermark, imagick::COMPOSITE_OVER, $posArr['x'], $posArr['y']);

            // clear wm cache
            @unlink($tmpWMFile);
        }
    }

    $rs = false;
    if((int) $pluginSettings['caching'] == 1)
    {
        // save image
        if($pluginObj->getImageLibrary() == 'gd')
        {
            ob_start();
            $img->output($outputFormat, $pluginObj->getThumbnailImageQuality());
            $imageContent = ob_get_clean();
            $rs = cache::saveCacheToFile($fullCachePath, $imageContent);
        }
        else
        {
            if($processAsAnimated == true)
            {
                $rs = $imagick->writeImages(CACHE_DIRECTORY_ROOT . '/' . $fullCachePath, true);
            }
            else
            {
                $rs = $imagick->writeImage(CACHE_DIRECTORY_ROOT . '/' . $fullCachePath, true);
                if(!$rs)
                {
                    ob_start();
                    echo $imagick;
                    $imageContent = ob_get_clean();
                    $rs = cache::saveCacheToFile($fullCachePath, $imageContent);
                }
            }
        }
    }

    if(!$rs)
    {
        // failed saving cache (or caching disabled), just output
        if($pluginObj->getImageLibrary() == 'gd')
        {
            $img->output($outputFormat, $pluginObj->getThumbnailImageQuality());
        }
        else
        {
            header("Content-Type: image/" . $outputFormat);
            echo $imagick;

            // tidy up
            @unlink($tmpImageFile);
        }
        exit;
    }

    // tidy up
    if($pluginObj->getImageLibrary() != 'gd')
    {
        @unlink($tmpImageFile);
    }
}

$size = $width . 'x' . $height;
$filename = $file->originalFilename;
$filename = str_replace(array('.' . $file->extension), "", $filename);
$filename .= '_' . $size;
$filename .= '.' . $file->extension;
$filename = str_replace("\"", "", $filename);

// output some headers
header("Expires: 0");
header("Pragma: public");
header("Content-Type: image/" . $outputFormat);
echo cache::getCacheFromFile($fullCachePath);
