<?php

// includes and security
include_once ('../../../../core/includes/master.inc.php');
include_once (DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// get params
$action = 'add';
$existing_category_id = null;
if((int)$_REQUEST['existing_category_id'])
{
	$existing_category_id = (int) $_REQUEST['existing_category_id'];
}
$label         	  = trim($_REQUEST['label']);
$key              = strtolower(trim($_REQUEST['key']));

// prepare result
$result          = array();
$result['error'] = false;
$result['msg']   = '';

// load category
if($existing_category_id != null)
{
	$category = $db->getRow('SELECT * FROM plugin_imageviewer_category WHERE id = '.(int)$existing_category_id.' LIMIT 1');
	if (!$category)
	{
		$result['error'] = true;
		$result['msg']   = 'Failed loading category to edit.';
		echo json_encode($result);
		exit;
	}
}

// validate submission
if (strlen($label) == 0)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("please_enter_the_category_name", "Please enter the category name");
}
elseif (strlen($key) == 0)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("please_enter_the_category_key", "Please enter the category url key");
}
elseif (validation::containsInvalidCharacters($key, 'abcdefghijklmnopqrstuvwxyz1234567890-0') == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("please_enter_a_valid_category_key", "Category key can only contain letters, numbers and hyphens");
}
elseif (coreFunctions::inDemoMode() == true)
{
    $result['error'] = true;
    $result['msg']   = adminFunctions::t("no_changes_in_demo_mode");
}
else
{
    // double check for category with the same name
    $foundExistingCategory = (int) $db->getValue('SELECT COUNT(id) FROM plugin_imageviewer_category WHERE (`label` = ' . $db->quote($label) . ' OR `key` = ' . $db->quote($key) . ') AND id != ' . (int) $existing_category_id);
    if ($foundExistingCategory)
    {
        $result['error'] = true;
        $result['msg']   = adminFunctions::t("category_with_same_name_found", "Category with same name or url key already exists. Please try again.");
    }
}

// no errors
if (strlen($result['msg']) == 0)
{
	if($existing_category_id != null)
	{
		// update the existing record
		$dbUpdate                   = new DBObject("plugin_imageviewer_category", array("label", "key"), 'id');
		$dbUpdate->label 			= $label;
		$dbUpdate->key           	= $key;
		$dbUpdate->id               = $existing_category_id;
		$dbUpdate->update();
		
		$result['error'] = false;
		$result['msg']   = 'Category \'' . $label . '\' updated.';
	}
	else
	{
		// add
		$dbInsert                   = new DBObject("plugin_imageviewer_category", array("label", "key"));
		$dbInsert->label 			= $label;
		$dbInsert->key           	= $key;
		$rs = $dbInsert->insert();
		if($rs)
		{
			$result['error'] = false;
			$result['msg']   = 'Category \'' . $label . '\' added.';
		}
		else
		{
			$result['error'] = true;
			$result['msg']   = 'Error adding \'' . $label . '\' category, please try again later.';
		}
	}
}

echo json_encode($result);
exit;
