<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'themes');
define('ADMIN_SELECTED_SUB_PAGE', 'theme_manage');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load themes details
$themeFolder = substr(str_replace(DIRECTORY_SEPARATOR."admin", "", __DIR__), strrpos(str_replace(DIRECTORY_SEPARATOR."admin", "", __DIR__), DIRECTORY_SEPARATOR)+1);
$themes   = $db->getRow("SELECT * FROM theme WHERE folder_name = " . $db->quote($themeFolder) . " LIMIT 1");
if (!$themes)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/theme_manage.php?error=' . urlencode('There was a problem loading the theme details.'));
}
define('ADMIN_PAGE_TITLE', $themes['theme_name'] . ' Settings');

// load themes details
$themeDetails = themeHelper::themeSpecificConfiguration($themes['folder_name']);
$themeConfig  = $themeDetails['config'];

if (isset($_REQUEST['se']))
{
    adminFunctions::setSuccess('Theme settings updated.');
}

// prepare variables
$thumbnail_type = 'square';

// pre-load all site skins
$skinsPath = '../styles/skins/';
$skins = coreFunctions::getDirectoryListing($skinsPath);
sort($skins);

// load existing settings
if (strlen($themes['theme_settings']))
{
    $theme_settings = json_decode($themes['theme_settings'], true);
    if ($theme_settings)
    {
        $thumbnail_type = $theme_settings['thumbnail_type'];
		$site_skin = $theme_settings['site_skin'];
		$home_images_selection_type = $theme_settings['home_images_selection_type'];
		$home_images_short_url_pool = $theme_settings['home_images_short_url_pool'];
		$last_image_id = $theme_settings['last_image_id'];
		$next_image_change = $theme_settings['next_image_change'];
		$facebook_page_url = $theme_settings['facebook_page_url'];
		$css_code = $theme_settings['css_code'];
    }
}

// make sure the logo directory path exists
$logoStorageFolder = CACHE_DIRECTORY_ROOT . '/themes/'.$themeFolder;
$logoStorageUrl = CACHE_WEB_ROOT . '/themes/'.$themeFolder;
if(!file_exists($logoStorageFolder))
{
	mkdir($logoStorageFolder, 0777, true);
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $thumbnail_type = $_REQUEST['thumbnail_type'];
	$site_skin = $_REQUEST['site_skin'];
	$home_images_selection_type = $_REQUEST['home_images_selection_type'];
	$home_images_short_url_pool = $_REQUEST['home_images_short_url_pool'];
	$last_image_id = (int)$_REQUEST['last_image_id'];
	$next_image_change = (int)$_REQUEST['next_image_change'];
	$facebook_page_url = trim($_REQUEST['facebook_page_url']);
	$css_code = $_REQUEST['css_code'];

    // validate submission
    if (coreFunctions::inDemoMode() == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
	elseif(strlen($facebook_page_url))
	{
		if(substr($facebook_page_url, 0, 4) != 'http')
		{
			adminFunctions::setError(adminFunctions::t("facebook_page_url_is_invalid", "Facebook url is invalid."));
		}
	}
	
	if (adminFunctions::isErrors() == false)
    {
		$imagesSandardised = array();
		if(strlen($home_images_short_url_pool))
		{
			$images = explode(',', $home_images_short_url_pool);
			foreach($images AS $image)
			{
				// try to load image
				$image = trim($image);
				$fileObj = file::loadByShortUrl($image);
				if(!$fileObj)
				{
					adminFunctions::setError('Could not load file with short url \''.validation::safeOutputToScreen($image).'\'. Please check or remove and try again.');
				}
				else
				{
					// check it's a public file
					if($fileObj->isPublic() == false)
					{
						adminFunctions::setError('Found file however it\'s not set as public \''.validation::safeOutputToScreen($image).'\'. Please check or remove and try again.');
					}
				}
				
				$imagesSandardised[] = $image;
			}
		}
	}
	
	if (adminFunctions::isErrors() == false)
    {
		if(strlen($_FILES["site_logo"]["tmp_name"]))
		{
			// check it's an image
			if (exif_imagetype($_FILES["site_logo"]["tmp_name"]) != IMAGETYPE_PNG)
			{
				adminFunctions::setError('Logo does not appear to be a PNG image. Please check and try again.');
			}
			elseif ($_FILES["site_logo"]["size"] > 200000)
			{
				adminFunctions::setError('Logo is bigger than 200k in size, please reduce and try again.');
			}
		}
	}

    // update the settings
    if (adminFunctions::isErrors() == false)
    {
		if($_REQUEST['thumbnail_type'] != $theme_settings['thumbnail_type'])
		{
			$next_image_change = 0;
		}

        // compile new settings
        $settingsArr                          		= array();
        $settingsArr['thumbnail_type'] 		  		= $thumbnail_type;
		$settingsArr['site_skin'] 		  			= $site_skin;
		$settingsArr['home_images_selection_type'] 	= $home_images_selection_type;
		$settingsArr['home_images_short_url_pool']  = COUNT($imagesSandardised)?implode(',', $imagesSandardised):'';
		$settingsArr['last_image_id']  				= $last_image_id;
		$settingsArr['next_image_change']  			= $next_image_change;
		$settingsArr['facebook_page_url']  			= $facebook_page_url;
		$settingsArr['css_code'] 		  			= $css_code;
        $settings                             		= json_encode($settingsArr);

        // update
        $dbUpdate                  = new DBObject("theme", array("theme_settings"), 'id');
        $dbUpdate->theme_settings  = $settings;
        $dbUpdate->id              = $themes['id'];
        $dbUpdate->update();
		
		// move logo into storage
		if(strlen($_FILES["site_logo"]["tmp_name"]))
		{
			$targetFile = $logoStorageFolder.'/logo.png';
			move_uploaded_file($_FILES["site_logo"]["tmp_name"], $targetFile);
		}
		
		// create custom css file
		$cssCodeFile = CACHE_DIRECTORY_ROOT . '/themes/'.$themeFolder.'/custom_css.css';
		if(strlen($settingsArr['css_code']))
		{
			file_put_contents($cssCodeFile, $settingsArr['css_code']);
		}
		else
		{
			unlink($cssCodeFile);
		}

		// clear cache
		themeHelper::clearCachedThemeSettings();
		
        adminFunctions::redirect('settings.php?se=1');
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Settings</h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off" enctype="multipart/form-data">
				
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>General Site Settings</h3>
                            <p>Site logo, skin and homepage images.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Replace Site Logo:</label>
                                    <div class="input">
                                        <input type="file" name="site_logo"/>
										<br/>
                                        <div class="formFieldFix" style='width: 500px; color: #777; font-size: 11px;'>Leave blank to keep existing. Must be a transparent png. Download the <a href="../offline/logo.png" target="_blank" download>original png here</a>.</div>
                                    </div>
                                </div>
								
								<div class="clearfix">
                                    <label>Site Skin:</label>
                                    <div class="input">
                                        <select name="site_skin" id="site_skin" class="medium">
                                            <?php
                                            foreach ($skins AS $option)
                                            {
												$option = str_replace($skinsPath, '', $option);
                                                echo '<option value="' . $option . '"';
                                                if ($site_skin == $option)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $option . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
								
								<div class="clearfix alt-highlight">
                                    <label>Homepage Images:</label>
                                    <div class="input">
                                        <select name="home_images_selection_type" id="home_images_selection_type" class="xxlarge">
                                            <?php
                                            $options = array('default_image' => 'Specific Image', 'random_public_page_load' => 'Random Public Image - Change Each Page Load', 'random_public_hourly' => 'Random Public Image - Change Every Hour', 'random_public_daily' => 'Random Public Image - Change Every Day', 'random_public_weekly' => 'Random Public Image - Change Every Week');
                                            foreach ($options AS $k => $option)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($home_images_selection_type == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $option . '</option>';
                                            }
                                            ?>
                                        </select><br/>
										<div class="formFieldFix" style='width: 500px; color: #777; font-size: 11px;'>How to select the main homepage background image.</div>
                                    </div>
                                </div>
								
								<div class="clearfix">
                                    <label>Homepage Image Pool:</label>
                                    <div class="input">
                                        <textarea name="home_images_short_url_pool" id="home_images_short_url_pool" class="xxlarge" placeholder="3nx,2s4,s2s..."><?php echo validation::safeOutputToScreen($home_images_short_url_pool); ?></textarea>
										<br/>
                                        <div class="formFieldFix" style='width: 500px; color: #777; font-size: 11px;'>Comma separated list of short urls to show on the homepage background. These will be chosen based on the "Homepage Images" option above. Images must be set to public. Leave blank to select from all public images on the site.</div>
                                    </div>
                                </div>
								
								<div class="clearfix alt-highlight">
                                    <label>Facebook Page Url:</label>
                                    <div class="input">
                                        <input name="facebook_page_url" id="facebook_page_url" type="text" class="xxlarge" value="<?php echo validation::safeOutputToScreen($facebook_page_url); ?>" placeholder="https://www.facebook.com/..."/>
                                    </div>
                                </div>
								
								<div class="clearfix">
                                    <label>Custom CSS Code:</label>
                                    <div class="input">
                                        <textarea name="css_code" class="xxlarge" placeholder="css code..." style="font-family: monospace; height: 200px;"><?php echo validation::safeOutputToScreen($css_code); ?></textarea>
										<br/>
                                        <div class="formFieldFix" style='width: 500px; color: #777; font-size: 11px;'>Optional. Use this field to override any of the site CSS without having to create a new theme. By right clicking on an element in your browser and selecting 'inspect', you can find the relating CSS rules. These changes will be kept after any script upgrades.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>File Manager</h3>
                            <p>Logged in file manager settings.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Thumbnail Type:</label>
                                    <div class="input">
                                        <select name="thumbnail_type" id="thumbnail_type" class="xxlarge">
                                            <?php
                                            $options = array('square' => 'Square Thumbnail (Center Clipped)', 'full' => 'Full Image Thumbnail');
                                            foreach ($options AS $k => $option)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($thumbnail_type == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $option . '</option>';
                                            }
                                            ?>
                                        </select>
										<br/>
                                        <div class="formFieldFix" style='width: 500px; color: #777; font-size: 11px;'>This is the shape of the thumbnails to show in the logged in file manager.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					
					<div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Image Previews</h3>
                            <p>Control settings around the quality of the image previews, watermarks and more.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Access:</label>
                                    <div class="input" style="margin-top: 5px; margin-bottom: 5px;">
                                        <a href="<?php echo WEB_ROOT; ?>/plugins/imageviewer/admin/settings.php?id=23" class="button blue">Image Preview Settings</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4 adminResponsiveHide">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Submit" class="button blue">
                                    <input type="reset" value="Cancel" class="button" onClick="window.location='<?php echo ADMIN_WEB_ROOT; ?>/theme_manage.php';"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $themeId; ?>"/>
					<input name="last_image_id" type="hidden" value="<?php echo $last_image_id; ?>"/>
					<input name="next_image_change" type="hidden" value="<?php echo $next_image_change; ?>"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>