function widgetLoadImage(id, url)
{
	if($('#main-ajax-container').length)
	{
		showImage(id);
		return false;
	}
	
	window.location = url;
}

function widgetLoadAlbum(id, url)
{
	if($('#main-ajax-container').length)
	{
		loadImages(id);
		return false;
	}
	
	window.location = url;
}

var engine1 = new Bloodhound({
	datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	queryTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	identify: "id",
	remote: {
		url: WEB_ROOT+'/ajax/_search_widget.ajax.php?type=images&query=%QUERY',
		wildcard: '%QUERY',
		rateLimitWait: 100
	}
});

var engine2 = new Bloodhound({
	datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	queryTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	identify: "id",
	remote: {
		url: WEB_ROOT+'/ajax/_search_widget.ajax.php?type=albums&query=%QUERY',
		wildcard: '%QUERY',
		rateLimitWait: 100
	}
});

var engine3 = new Bloodhound({
	datumTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	queryTokenizer: Bloodhound.tokenizers.obj.whitespace('title', 'thumbnail', 'id'),
	identify: "id",
	remote: {
		url: WEB_ROOT+'/ajax/_search_widget.ajax.php?type=users&query=%QUERY',
		wildcard: '%QUERY',
		rateLimitWait: 100
	}
});
 
$('#top-search .typeahead').typeahead({
		minLength: 3, // send AJAX request only after user type in at least 3 characters
		highlight: true,
		cache: false,
		hint: false
	},
	{
		name: 'search-result',
		source: engine1,
		display: 'none',
		limit: 8,
		valueKey: 'id',
		templates: {
			header: function(obj) { return '<h3 class="group-title"><a href="'+WEB_ROOT+'/search/?s=image&t='+encodeURIComponent(obj['query'])+'">Images <span class="view-all-link">View All</span></a></h3>'; },
			footer: function(obj) { return '<h3 class="group-footer"><a href="'+WEB_ROOT+'/search/?s=image&t='+encodeURIComponent(obj['query'])+'">More...</a></h3>'; },
			notFound: '<h3 class="group-title">Images</h3><div class="search-widget-no-results">No images found in search.</div>',
			suggestion: Handlebars.compile('<div><a href="{{url}}" onClick=\'widgetLoadImage({{id}}, "{{url}}"); return false;\'><img src="{{thumbnail}}" class="listing-image-thumbnail"/> <span class="listing-image-title">{{title}}</span><span class="listing-image-sub-title">by {{owner}}</span><div class="clear"></div></a></div>')
		}
	},
	{
		name: 'search-result2',
		source: engine2,
		display: 'none',
		limit: 8,
		valueKey: 'id',
		templates: {
			header: function(obj) { return '<h3 class="group-title"><a href="'+WEB_ROOT+'/search/?s=album&t='+encodeURIComponent(obj['query'])+'">Albums <span class="view-all-link">View All</span></a></h3>'; },
			footer: function(obj) { return '<h3 class="group-footer"><a href="'+WEB_ROOT+'/search/?s=album&t='+encodeURIComponent(obj['query'])+'">More...</a></h3>'; },
			notFound: '<h3 class="group-title">Albums</h3><div class="search-widget-no-results">No albums found in search.</div>',
			suggestion: Handlebars.compile('<div><a href="{{url}}" onClick=\'widgetLoadAlbum({{id}}, "{{url}}"); return false;\'><img src="{{thumbnail}}" class="listing-image-thumbnail"/> <span class="listing-image-title">{{title}}</span><div class="search-widget-col-right">{{total_images}}</div><span class="listing-image-sub-title">by {{owner}}</span><div class="clear"></div></a></div>')
		}
},
	{
		name: 'search-result3',
		source: engine3,
		display: 'none',
		limit: 8,
		valueKey: 'id',
		templates: {
			header: '<h3 class="group-title">User Profiles</h3>',
			notFound: '<h3 class="group-title">User Profiles</h3><div class="search-widget-no-results">No profiles found in search.</div>',
			suggestion: Handlebars.compile('<div><a href="{{url}}"><img src="{{thumbnail}}" class="listing-image-thumbnail"/> <span class="listing-image-title">{{title}}</span><span class="listing-image-sub-title">{{total_images}}</span><div class="clear"></div></a></div>')
		}
}).on('typeahead:asyncrequest', function() {
	//$('.Typeahead-spinner').show();
})
.on('typeahead:asynccancel typeahead:asyncreceive', function() {
	//$('.Typeahead-spinner').hide();
});