<?php

// setup response
$returnJson = array();
$returnJson['error'] = false;
$returnJson['msg'] = '';

// only logged in users can like
if(!$Auth->loggedIn())
{
	$returnJson['error'] = true;
	$returnJson['msg'] = 'You must be logged in to like images.';
	echo json_encode($returnJson);
	exit;
}

// get image viewer object
$imageViewerObj = pluginHelper::getInstance('imageviewer');

// like image
$returnJson['total_likes'] = 0;
$imageId = (int)$_REQUEST['imageId'];
$file = file::loadById($imageId);
if(!$file)
{
	$returnJson['error'] = true;
	$returnJson['msg'] = 'Failed loading image.';
	echo json_encode($returnJson);
	exit;
}
// get total
$returnJson['total_likes'] = $imageViewerObj->getTotalLikes($file);
$imageViewerObj->setLike($file, $Auth->id);

// send back total
$newTotal = $imageViewerObj->getTotalLikes($file);
$returnJson['action'] = 'unlike';
if($newTotal > $returnJson['total_likes'])
{
	$returnJson['action'] = 'like';
}
$returnJson['total_likes'] = $newTotal;

// output response
echo json_encode($returnJson);