<?php

// layout settings
$thumbnailType = themeHelper::getConfigValue('thumbnail_type');

// per page options
$perPageOptions = array(15, 30, 50, 100, 250);
$defaultPerPage = 30;

// sorting options
$sortingOptions = array();
$sortingOptions['order_by_filename_asc'] = t('order_by_filename_asc', 'Filename ASC');
$sortingOptions['order_by_filename_desc'] = t('order_by_filename_desc', 'Filename DESC');
$sortingOptions['order_by_date_taken_asc'] = t('order_by_date_taken_asc', 'Date Taken ASC');
$sortingOptions['order_by_date_taken_desc'] = t('order_by_date_taken_desc', 'Date Taken DESC');
$sortingOptions['order_by_uploaded_date_asc'] = t('order_by_uploaded_date_asc', 'Uploaded Date ASC');
$sortingOptions['order_by_uploaded_date_desc'] = t('order_by_uploaded_date_desc', 'Uploaded Date DESC');
$sortingOptions['order_by_downloads_asc'] = t('order_by_downloads_asc', 'Total Downloads ASC');
$sortingOptions['order_by_downloads_desc'] = t('order_by_downloads_desc', 'Total Downloads DESC');
$sortingOptions['order_by_filesize_asc'] = t('order_by_filesize_asc', 'Filesize ASC');
$sortingOptions['order_by_filesize_desc'] = t('order_by_filesize_desc', 'Filesize DESC');
$sortingOptions['order_by_last_access_date_asc'] = t('order_by_last_access_date_asc', 'Last Access Date ASC');
$sortingOptions['order_by_last_access_date_desc'] = t('order_by_last_access_date_desc', 'Last Access Date DESC');
$defaultSorting = 'order_by_date_taken_asc';

// image extensions
$imageExtArr = file::getImageExtStringForSql();

// some initial headers
header("HTTP/1.0 200 OK");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Pragma: no-cache");

// setup response
$returnJson = array();
$returnJson['html'] = '';
$returnJson['javascript'] = '';

// setup session params
if(!isset($_SESSION['search']))
{
	$_SESSION['search'] = array();
}
if(!isset($_SESSION['search']['perPage']))
{
	$_SESSION['search']['perPage'] = $defaultPerPage;
}
if(!isset($_SESSION['search']['filterOrderBy']))
{
	$_SESSION['search']['filterOrderBy'] = $defaultSorting;
}
if(!isset($_SESSION['browse']['viewType']))
{
	$_SESSION['browse']['viewType'] = 'fileManagerIcon';
	if(SITE_CONFIG_FILE_MANAGER_DEFAULT_VIEW == 'list')
	{
		$_SESSION['browse']['viewType'] = 'fileManagerList';
	}
}

// setup initial params
$pageStart = (int)$_REQUEST['pageStart'];
$perPage = (int)$_REQUEST['perPage']>0?(int)$_REQUEST['perPage']:$_SESSION['search']['perPage'];
$filterOrderBy = strlen($_REQUEST['filterOrderBy'])?$_REQUEST['filterOrderBy']:$_SESSION['search']['filterOrderBy'];
$searchTerm = isset($_REQUEST['searchFilter'])?trim($_REQUEST['searchFilter']):'';
$categoryId = isset($_REQUEST['categoryId'])?(int)$_REQUEST['categoryId']:null;

// advanced filters
$advFilters = isset($_REQUEST['advFilters'])?$_REQUEST['advFilters']:array();
$filterImagesAll = (isset($advFilters['filterImagesAll']) && ($advFilters['filterImagesAll'] == 'false'))?false:true;
$filterUploadedDateRange = (isset($advFilters['filterUploadedDateRange']) && strlen($advFilters['filterUploadedDateRange']))?$advFilters['filterUploadedDateRange']:null;

$categoryArr = null;
$searchType = null;
$addClause = '';

$foldersClause = "WHERE 1=1 ";
if(isset($_REQUEST['nodeId']))
{
	$nodeId = $_REQUEST['nodeId'];
	switch($nodeId)
	{
		case 'recent':
			$searchType = 'recent';
			$foldersClause .= ' AND 1=2'; // disable
			break;
		case 'trash':
			$searchType = 'trash';
			$foldersClause .= ' AND 1=2'; // disable
			break;
		case 'all':
			$searchType = 'all';
			$foldersClause .= ' AND 1=2'; // disable
			break;
		case '-1':
			$searchType = 'root';
			$foldersClause .= " AND file_folder.parentId IS NULL AND userId = " . (int)$Auth->id;
			break;
		default:
			$searchType = 'folder';
			$foldersClause .= " AND file_folder.parentId = ".(int)$nodeId;
			break;
	}
}
elseif(isset($_REQUEST['userId']))
{
	$userId = $_REQUEST['userId'];
	if(isset($_REQUEST['likes']))
	{
		$searchType = 'likes';
	}
	else
	{
		$searchType = 'user';
	}
	$foldersClause .= ' AND 1=2'; // disable
}
elseif(isset($_REQUEST['categoryId']))
{
	// load category
	$categoryArr = $db->getRow('SELECT * FROM plugin_imageviewer_category WHERE id = '.(int)$categoryId.' LIMIT 1');
	$searchType = 'category';
	$foldersClause .= ' AND 1=2'; // disable
}
elseif(isset($_REQUEST['searchType']))
{
	if(in_array($_REQUEST['searchType'], array('browserecent')))
	{
		$searchType = $_REQUEST['searchType'];
	}
	$foldersClause .= ' AND 1=2'; // disable
}

// for recent uploads
if(($searchType == 'recent') || ($searchType == 'browserecent'))
{
    $filterOrderBy = 'order_by_uploaded_date_desc';
}

// save session params
$_SESSION['search']['perPage'] = $perPage;
$_SESSION['search']['filterOrderBy'] = $filterOrderBy;

// setup page title for later
$pageTitle = t('images', 'Images');
$pageUrl = '';
$album = null;
$owner = null;
$folderId = null;
$userOwnsFolder = false;
if($searchType == 'folder')
{
	$album = fileFolder::loadById($nodeId);
	if($album)
	{
		$pageTitle = $album->folderName;
		$pageUrl = $album->getAlbumUrl();
		$folderId = $album->id;
		
		if((int)$album->userId)
		{
			// get folder owner details
			$owner = UserPeer::loadUserById($album->userId);
			
			// store if the current user owns the folder
			if($owner->id === $Auth->id)
			{
				$userOwnsFolder = true;
			}
		}
		
		// privacy
		if(((int)$album->userId > 0) && ($album->userId != $Auth->id))
		{
			if(coreFunctions::getOverallPublicStatus($album->userId, $album->id) == false)
			{
				// output response
				$returnJson['html'] = '<div class="ajax-error-image"><!-- --></div>';
				$returnJson['page_title'] = UCWords(t('error', 'Error'));
				$returnJson['page_url'] = '';
				$returnJson['javascript'] = 'showErrorNotification("'.str_replace("\"", "'", UCWords(t('error', 'Error'))).'", "'.str_replace("\"", "'", t('folder_is_not_publicly_shared_please_contact', 'Folder is not publicly shared. Please contact the owner and request they update the privacy settings.')).'");';
				echo json_encode($returnJson);
				exit;
			}
		}
		
		// check if album needs a password, ignore if logged in as the owner
		if((strlen($album->accessPassword) > 0) && ($owner->id != $Auth->id))
		{
			// see if we have it in the session already
			$askPassword = true;
			if(!isset($_SESSION['folderPassword']))
			{
				$_SESSION['folderPassword'] = array();
			}
			elseif(isset($_SESSION['folderPassword'][$album->id]))
			{
				if($_SESSION['folderPassword'][$album->id] == $album->accessPassword)
				{
					$askPassword = false;
				}
			}
			
			if($askPassword == true)
			{
				// output response
				$returnJson['html'] = '<div class="ajax-error-image"><!-- --></div><div id="albumPasswordModel" data-backdrop="static" data-keyboard="false" class="albumPasswordModel modal fade custom-width general-modal"><div class="modal-dialog"><div class="modal-content"><form id="folderPasswordForm" action="'.WEB_ROOT.'/ajax/_album_password.process.ajax.php" autocomplete="off" onSubmit="$(\'#password-submit-btn\').click(); return false;"><div class="modal-body">';
				
				$returnJson['html'] .= '<div class="row">';
				$returnJson['html'] .= '	<div class="col-md-4">';
				$returnJson['html'] .= '		<div class="tile-title tile-orange"> <div class="icon"> <i class="glyphicon glyphicon-lock"></i> </div> <div class="title"> <h3>'.t('password_protected', 'Password Protected').'</h3> <p></p> </div> </div>';
				$returnJson['html'] .= '	</div>';
				$returnJson['html'] .= '	<div class="col-md-8">';
				$returnJson['html'] .= '		<h4>'.t('password_required', 'Password Required').'</h4><hr style="margin-top: 5px;"/>';
				$returnJson['html'] .= '		<div class="form-group">';
				$returnJson['html'] .= '			<p>'.t('this_folder_has_a_password_set', 'This folder requires a password to gain access. Use the form below to enter the password, then click "unlock".').'</p>';
				$returnJson['html'] .= '		</div>';
				
				$returnJson['html'] .= '		<div class="form-group">';
				$returnJson['html'] .= '			<label for="folderName" class="control-label">'.UCWords(t('access_password', 'Access Password')).':</label>';
				$returnJson['html'] .= '			<div class="input-grsoup">';
				$returnJson['html'] .= '				<input type="password" name="folderPassword" id="folderPassword" class="form-control" placeholder="************"/>';
				$returnJson['html'] .= '			</div>';
				$returnJson['html'] .= '		</div>';
				$returnJson['html'] .= '	</div>';
				$returnJson['html'] .= '</div>';
				
				$returnJson['html'] .= '</div><div class="modal-footer" style="margin-top: 0px;">';
				$returnJson['html'] .= '<input type="hidden" value="'.(int)$album->id.'" id="folderId" name="folderId"/>';
				$returnJson['html'] .= '<input type="hidden" value="1" id="submitme" name="submitme"/>';
				$returnJson['html'] .= '<button type="button" class="btn btn-default" data-dismiss="modal">'.t('cancel', 'Cancel').'</button>';
				$returnJson['html'] .= '<button type="button" class="btn btn-info" id="password-submit-btn" onClick="processAjaxForm(this, function() { $(\'.modal\').modal(\'hide\'); $(\'.modal-backdrop\').remove(); loadFiles('.(int)$album->id.'); }); return false;">'.t('unlock', 'Unlock').' <i class="entypo-check"></i></button>';
				$returnJson['html'] .= '</div></form></div></div></div>';
				$returnJson['javascript'] = "jQuery('.albumPasswordModel').modal('show');";
				$returnJson['page_title'] = $pageTitle;
				$returnJson['page_url'] = $pageUrl;
				echo json_encode($returnJson);
				exit;
			}
		}
	}
}
elseif($searchType == 'recent')
{
	$pageTitle = t('recent_images', 'Recent Images');
	$pageUrl = WEB_ROOT.'/account_home.html';
}
elseif($searchType == 'root')
{
	$pageTitle = t('image_manager', 'Image Manager');
	$pageUrl = WEB_ROOT.'/account_home.html';
	$userOwnsFolder = true;
}
elseif($searchType == 'all')
{
	$pageTitle = t('all_images', 'All Images');
	$pageUrl = WEB_ROOT.'/account_home.html';
}
elseif($searchType == 'category')
{
	$pageTitle = t('categories', 'Categories');
}
elseif($searchType == 'browserecent')
{
	if(strlen($searchTerm))
	{
		$pageTitle = t('image_search_results', 'Image Search Results');
	}
	else
	{
		$pageTitle = t('recent_image_uploads', 'Recent Image Uploads');
	}
}

$db = Database::getDatabase();
$filesClause = "WHERE 1=1 ";

if($filterImagesAll == false)
{
	$filesClause .= " AND file.userId = " . (int)$Auth->id;
}

// root folder listing
if($searchType == 'root')
{
    $filesClause .= " AND file.folderId IS NULL AND file.userId = " . (int)$Auth->id;
}

// all images for user
if($searchType == 'all')
{
    $filesClause .= " AND file.userId = " . (int)$Auth->id;
}

if(strlen($searchTerm))
{
	$filesClause .= ' AND (file.originalFilename LIKE "%'.$db->escape($searchTerm).'%" '
                . 'OR file.shortUrl LIKE "%'.$db->escape($searchTerm).'%" '
                . 'OR file.keywords LIKE "%'.$db->escape($searchTerm).'%")';
}

$sortColName = 'plugin_imageviewer_meta.date_taken';
$sortDir = 'asc';
switch($_SESSION['search']['filterOrderBy'])
{
    case 'order_by_filename_asc':
        $sortColName = 'originalFilename';
        $sortDir = 'asc';
        break;
    case 'order_by_filename_desc':
        $sortColName = 'originalFilename';
        $sortDir = 'desc';
        break;
    case 'order_by_uploaded_date_asc':
	case '':
        $sortColName = 'uploadedDate';
        $sortDir = 'asc';
        break;
    case 'order_by_uploaded_date_desc':
        $sortColName = 'uploadedDate';
        $sortDir = 'desc';
        break;
    case 'order_by_downloads_asc':
        $sortColName = 'visits';
        $sortDir = 'asc';
        break;
    case 'order_by_downloads_desc':
        $sortColName = 'visits';
        $sortDir = 'desc';
        break;
    case 'order_by_filesize_asc':
        $sortColName = 'fileSize';
        $sortDir = 'asc';
        break;
    case 'order_by_filesize_desc':
        $sortColName = 'fileSize';
        $sortDir = 'desc';
        break;
    case 'order_by_last_access_date_asc':
        $sortColName = 'lastAccessed';
        $sortDir = 'asc';
        break;
    case 'order_by_last_access_date_desc':
        $sortColName = 'lastAccessed';
        $sortDir = 'desc';
        break;
	case 'order_by_date_taken_asc':
        $sortColName = 'plugin_imageviewer_meta.date_taken';
        $sortDir = 'asc';
        break;
    case 'order_by_date_taken_desc':
        $sortColName = 'plugin_imageviewer_meta.date_taken';
        $sortDir = 'desc';
        break;
}

// trash can
if($searchType == 'trash')
{
    $filesClause .= " AND file.statusId != 1";
	$filesClause .= " AND file.userId = ".(int)$Auth->id;
}
else
{
	// only active
	$filesClause .= " AND file.statusId = 1";
}

// make sure only images - disabled as it's not really needed and could slow things down
//$filesClause .= " AND file.extension IN (".$imageExtArr.")";

// folder listing
if($searchType == 'folder')
{
    $filesClause .= " AND file.folderId = ".(int)$nodeId;
}
elseif($searchType == 'likes')
{
	$filesClause .= " AND file.id IN(SELECT file_id FROM plugin_imageviewer_image_like WHERE user_id = ".(int)$userId.")";
}
elseif($searchType == 'category')
{
	$filesClause .= " AND file.id IN(SELECT file_id FROM plugin_imageviewer_category_file WHERE category_id = ".(int)$categoryId.")";
}

// paging js
$pagingJs = "loadImages('".$nodeId."', ";
$updatePagingJs = 'updatePerPage(';
$updateSortingJs = 'updateSorting(';
if($searchType == 'category')
{
	$pagingJs = "loadBrowsePageCategoryImages(".(int)$categoryId.', ';
	$updatePagingJs = 'updateCategoryPerPage('.(int)$categoryId.', ';
	$updateSortingJs = 'updateCategorySorting('.(int)$categoryId.', ';
}
elseif($searchType == 'browserecent')
{
	$pagingJs = "loadBrowsePageRecentImages('".str_replace(array('"', '\'', '\\'), '', $searchTerm)."', ";
	$updatePagingJs = 'updateRecentImagesPerPage(';
}
elseif($searchType == 'likes')
{
	$pagingJs = "loadImageLikes(".(int)$userId.", ";
	$updatePagingJs = 'updateImageLikesPerPage('.(int)$userId.', ';
	$updateSortingJs = 'updateImageLikesSorting('.(int)$userId.', ';
}

// for recent uploads
if($searchType == 'recent')
{
    $sortColName = 'uploadedDate';
    $sortDir = 'desc';
	$filesClause .= " AND file.userId = ".(int)$Auth->id;
}

// filter by date range
if($filterUploadedDateRange !== null)
{
    // validate date
    $expDate = explode('|', $filterUploadedDateRange);
    if(COUNT($expDate) == 2)
    {
        $startDate = $expDate[0];
        $endDate = $expDate[1];
    }
    else
    {
        $startDate = $expDate[0];
        $endDate = $expDate[0];
    }

    if((validation::validDate($startDate, 'Y-m-d')) && (validation::validDate($endDate, 'Y-m-d')))
    {
        // dates are valid
        $filesClause .= " AND (UNIX_TIMESTAMP(file.uploadedDate) >= ".coreFunctions::convertDateToTimestamp($startDate, 'Y-m-d')." AND UNIX_TIMESTAMP(file.uploadedDate) <= ".(coreFunctions::convertDateToTimestamp($endDate, 'Y-m-d')+(60*60*24)-1).")";
    }
}

if($searchType == 'browserecent')
{
    $filesClause .= " AND (file_folder.isPublic = 2 OR file.userId IS NULL OR file.userId = ".(int)$Auth->id.")";
}

// get file total for this account and filter
$allStats = $db->getRow('SELECT COUNT(file.id) AS totalFileCount, SUM(file.fileSize) AS totalFileSize FROM file LEFT JOIN file_folder ON file.folderId = file_folder.id '.$filesClause);
$allStatsFolders = $db->getRow("SELECT COUNT(file_folder.id) AS totalFolderCount FROM file_folder ".$foldersClause);

// load folders
$folders = $db->getRows("SELECT file_folder.id, file_folder.parentId, file_folder.folderName, file_folder.isPublic, file_folder.coverImageId, (SELECT COUNT(file.id) AS fileCount FROM file WHERE file.folderId = file_folder.id AND statusId = 1) AS fileCount FROM file_folder ". $foldersClause ." ORDER BY folderName ASC LIMIT ".(($pageStart - 1) * (int)$_SESSION['search']['perPage']).", ".(int)$_SESSION['search']['perPage']);

// allow for folders in paging
$newStart = floor((($pageStart - 1) * (int)$_SESSION['search']['perPage']) - $allStatsFolders['totalFolderCount']);
if($newStart < 0)
{
	$newStart = 0;
}
$newLimit = $_SESSION['search']['perPage'] - COUNT($folders);
$limit = ' LIMIT ' . $newStart . ',' . $newLimit;

// load limited page filtered
$files = $db->getRows('SELECT file.*, plugin_imageviewer_meta.width, plugin_imageviewer_meta.height FROM file LEFT JOIN file_folder ON file.folderId = file_folder.id LEFT JOIN plugin_imageviewer_meta ON file.id = plugin_imageviewer_meta.file_id '.$filesClause.' ORDER BY '.$sortColName.' '.$sortDir.' '.$limit);

// breadcumbs
$breadcrumbs = array();
if($searchType == 'category')
{
	$breadcrumbs[] = '<li><a href="#" onClick="loadBrowsePageCategories(); return false;"><i class="entypo-archive"></i>'.validation::safeOutputToScreen($pageTitle).'</a></li>';
	$breadcrumbs[] = '<li><a href="#" onClick="'.$pagingJs.'1); return false;">'.validation::safeOutputToScreen($categoryArr['label']).'</a></li>';
}
elseif($searchType == 'browserecent')
{
	if(strlen($searchTerm))
	{
		$breadcrumbs[] = '<li><a href="#" onClick="loadBrowsePageRecentImages(\''.str_replace(array('"', '\'', '\\'), '', $searchTerm).'\'); return false;"><i class="entypo-camera"></i>'.validation::safeOutputToScreen($pageTitle).'</a></li>';
	}
	else
	{
		$breadcrumbs[] = '<li><a href="#" onClick="loadBrowsePageRecentImages(); return false;"><i class="entypo-camera"></i>'.validation::safeOutputToScreen($pageTitle).'</a></li>';
	}
}
elseif($searchType == 'folder')
{
	$localAlbum = $album;
	$localBreadcrumbs = array();
	while($localAlbum != false)
	{
		$parentId = $localAlbum->parentId;
		$localBreadcrumbs[] = '<li><a href="#" onClick="loadImages('.(int)$localAlbum->id.', 1); return false;">'.($parentId==null?'<i class="entypo-folder"></i>':'').validation::safeOutputToScreen($localAlbum->folderName).'</a></li>';
		$localAlbum = fileFolder::loadById($parentId);
	}
	
	// change direction of breadcrumbs and add globally
	$breadcrumbs = array_merge($breadcrumbs, array_reverse($localBreadcrumbs));
}
else
{
	$breadcrumbs[] = '<li><a href="#" onClick="'.$pagingJs.'1); return false;"><i class="entypo-folder"></i>'.validation::safeOutputToScreen($pageTitle).'</a></li>';
}
$breadcrumbs[] = '<li>'.(int)$allStats['totalFileCount'].' images'.((int)$allStats['totalFileCount']>0?(' ('.coreFunctions::formatSize($allStats['totalFileSize']).')'):'').'</li>';

$returnJson['html'] .= '<div class="image-browse">';

$returnJson['html'] .= '<div id="fileManager" class="fileManager '.validation::safeOutputToScreen($_SESSION['browse']['viewType']).'">';
if (($files) || ($folders))
{
	$returnJson['html'] .= '<div class="toolbar-container">
		<!-- toolbar -->
		<div class="col-md-4 clearfix">
			<!-- breadcrumbs -->
			<div class="row breadcrumbs-container">
				<div class="col-md-12 col-sm-12 clearfix">
					<ol id="folderBreadcrumbs" class="breadcrumb bc-3 pull-left">'.implode('', $breadcrumbs).'</ol>
				</div>
			</div>
		</div>';

	$returnJson['html'] .= '
		<div class="col-md-8 clearfix right-toolbar-options">
			<div class="list-inline pull-right">
				<div class="btn-toolbar pull-right" role="toolbar">';
	
	// show album options
	if(($userOwnsFolder === true) && ($album != null))
	{
		$returnJson['html'] .= '<div class="btn-group">
								<button id="folderOptions" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
									Album <i class="caret"></i>
								</button>
								<ul role="menu" class="dropdown-menu dropdown-white pull-left">';
		if (UserPeer::getAllowedToUpload() == true)
		{
			$returnJson['html'] .= '	<li><a href="#" onClick="uploadFiles('.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-cloud-upload"></span></span>'.t('upload_images', 'Upload Images').'</a></li>';
			$returnJson['html'] .= '	<li class="divider"></li>';
		}
		$returnJson['html'] .= '	<li><a href="#" onClick="showAddFolderForm(null, '.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-pencil"></span></span>'.t('edit_folder', 'Edit').'</a></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="confirmRemoveFolder('.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-remove"></span></span>'.t('delete_folder', 'Delete').'</a></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="showAddFolderForm('.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-plus"></span></span>'.t('add_albumfolder', 'Add Album').'</a></li>';
		$returnJson['html'] .= '	<li class="divider"></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="downloadAllFilesFromFolder('.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-floppy-save"></span></span>'.t('download_all_images', 'Download All Images (Zip)').'</a></li>';
		$returnJson['html'] .= '	<li class="divider"></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="selectAllFiles();"><span class="context-menu-icon"><span class="glyphicon glyphicon-check"></span></span>'.t('account_file_details_select_all_images', 'Select All Images').'</a></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="clearSelected();"><span class="context-menu-icon"><span class="glyphicon glyphicon-unchecked"></span></span>'.t('account_file_details_clear_selected', 'Clear Selected').'</a></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="sharePublicAlbum('.(int)$album->id.');"><span class="context-menu-icon"><span class="glyphicon glyphicon-share"></span></span>'.t('share_album', 'Share Album').'</a></li>';
		$returnJson['html'] .= '</ul>
							</div>';
	}
	elseif($searchType == 'root')
	{
		$returnJson['html'] .= '<div class="btn-group">
								<button id="folderOptions" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
									Album <i class="caret"></i>
								</button>
								<ul role="menu" class="dropdown-menu dropdown-white pull-left">';
		$returnJson['html'] .= '	<li><a href="#" onClick="uploadFiles(\'\');">'.t('upload_images', 'Upload Images').'</a></li>';
		$returnJson['html'] .= '	<li class="divider"></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="showAddFolderForm('.(int)$album->id.');">'.t('add_albumfolder', 'Add Album').'</a></li>';
		$returnJson['html'] .= '	<li class="divider"></li>';
		$returnJson['html'] .= '	<li><a href="#" onClick="selectAllFiles();">'.t('account_file_details_select_all_images', 'Select All Images').'</a></li>';
		$returnJson['html'] .= '</ul>
							</div>';
	}
	
	$returnJson['html'] .= '<div class="btn-group hidden-xs">
						<button class="btn btn-white disabled fileActionLinks" type="button" title="" data-original-title="Links" data-placement="bottom" data-toggle="tooltip" onclick="viewFileLinks();
								return false;"><i class="entypo-link"></i></button>';
if($userOwnsFolder === true)
{
	$returnJson['html'] .= '<button class="btn btn-white disabled fileActionLinks" type="button" title="" data-original-title="Delete" data-placement="bottom" data-toggle="tooltip" onclick="deleteFiles();
								return false;"><i class="entypo-cancel"></i></button>';
}
$returnJson['html'] .= '<button class="btn btn-white" type="button" title="" data-original-title="List View" data-placement="bottom" data-toggle="tooltip" onclick="toggleViewType();
								return false;" id="viewTypeText"><i class="entypo-list"></i></button>
						<button class="btn btn-white" type="button" title="" data-original-title="Fullscreen" data-placement="bottom" data-toggle="tooltip" onclick="toggleFullScreenMode();
								return false;"><i class="entypo-resize-full"></i></button>
					</div>';
if($album != null)
{
	$returnJson['html'] .= '<div class="btn-group hidden-xs">
						<a href="'.coreFunctions::getCoreSitePath().'/slideshow/'.(int)$album->id.'/'.$album->getSafeFoldernameForUrl().'" target="_blank" class="btn btn-white" type="button" title="" data-original-title="Play Slideshow" data-placement="bottom" data-toggle="tooltip"><i class="entypo-play"></i></a>
						</div>';
}
$returnJson['html'] .= '
					<div class="btn-group">';
					
if($searchType != 'browserecent')
{
	$returnJson['html'] .= '<div class="btn-group">
								<button id="filterButton" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
									'.validation::safeOutputToScreen($sortingOptions{$_SESSION['search']['filterOrderBy']}).' <i class="entypo-arrow-combo"></i>
								</button>
								<ul role="menu" class="dropdown-menu dropdown-white pull-right">
									<li class="disabled"><a href="#">Sort By</a></li>';
									foreach($sortingOptions AS $k=>$v)
									{
										$returnJson['html'] .= '<li><a href="#" onclick="'.$updateSortingJs.'\''.$k.'\', \''.$v.'\', this); return false;">'.$v.'</a></li>';
									}
								$returnJson['html'] .= '</ul>
								<input name="filterOrderBy" id="filterOrderBy" value="'.validation::safeOutputToScreen($_SESSION['search']['filterOrderBy']).'" type="hidden">
							</div>';
}

$returnJson['html'] .= '<div class="btn-group">
							<button id="perPageButton" data-toggle="dropdown" class="btn btn-white dropdown-toggle" type="button">
								'.(int)$_SESSION['search']['perPage'].' <i class="entypo-arrow-combo"></i>
							</button>
							<ul role="menu" class="dropdown-menu dropdown-white pull-right per-page-menu">
								<li class="disabled"><a href="#">Per Page:</a></li>';
								foreach($perPageOptions AS $perPageOption)
								{
									$returnJson['html'] .= '<li><a href="#" onclick="'.$updatePagingJs.'\''.(int)$perPageOption.'\', \''.(int)$perPageOption.'\', this); return false;">'.(int)$perPageOption.'</a></li>';
								}
                            $returnJson['html'] .= '</ul>
							<input name="perPageElement" id="perPageElement" value="100" type="hidden">
						</div>
					</div>
				</div>
				<ol id="folderBreadcrumbs2" class="breadcrumb bc-3 pull-right">
					<li class="active">
						<span id="statusText"></span>
					</li>
				</ol>
			</div>
		</div>';

$returnJson['html'] .= '
		<!-- /.navbar-collapse -->
	</div>';
	
    $returnJson['html'] .= '<div class="gallery-env"><div class="fileListing" id="fileListing">';
    
    // some presets
    $thumbnailWidth = 280;
    $thumbnailHeight = 280;
	$counter = 1;
	$delayedThumbnailUrls = array();

	// output folders
	if($folders)
    {
        foreach ($folders AS $folder)
        {
			// skip if user does not own the folder and the folders are not public
			if(($userOwnsFolder === false) && ((int)$folder['isPublic'] == 0))
			{
				continue;
			}
			
			// hydrate folder
			$folderObj = fileFolder::hydrate($folder);
			$folderLabel = $folder['folderName'];
			
			// prepare cover image
			$coverData = $folderObj->getCoverData();
			$coverId = (int)$coverData['file_id'];
			$coverUniqueHash = $coverData['unique_hash'];
			
            $returnJson['html'] .= '<div class="fileItem folderIconLi fileIconLi col-sm-2 col-xs-4 image-thumb '.($userOwnsFolder==true?'owned-album':'not-owned-album').'" onClick="loadImages('.(int)$folderObj->id.'); return false;" folderId="'.(int)$folderObj->id.'">';
			
			// delay rendering of thumbnail to protect the server
			$delayedThumbnailUrls['delayedThumbBrowse'.(int)$coverId] = CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$coverId.'/'.$coverUniqueHash.'/'.$thumbnailWidth.'x'.$thumbnailWidth.'_middle.jpg';
			
			$returnJson['html'] .= '<div class="thumbIcon">';
			$returnJson['html'] .= '<a name="link"><img src="'.(SITE_IMAGE_PATH.'/trans_1x1.gif').'" data-src="'.CACHE_WEB_ROOT.'/plugins/imageviewer/'.(int)$coverId.'/'.$coverUniqueHash.'/'.$thumbnailWidth.'x'.$thumbnailWidth.'_middle.jpg'.'" alt="" style="max-width: 100%; max-height: 100%; min-width: 30px; min-height: 30px;" class="delayedThumbBrowse'.(int)$coverId.'"></a>';
			$returnJson['html'] .= '<div class="albumIcon"></div>';
			$returnJson['html'] .= '</div>';
			
			$returnJson['html'] .= '<div class="back">';
			$returnJson['html'] .= '<p>';
			$returnJson['html'] .= validation::safeOutputToScreen($folderLabel);
			$returnJson['html'] .= '</p>';
			$returnJson['html'] .= '</div>';
			
			$returnJson['html'] .= '<span class="filesize"></span>';
			$returnJson['html'] .= '<span class="fileUploadDate">'.($folder['fileCount'] > 0 ? $folder['fileCount']." ".($folder['fileCount']==1?strtolower(t('image', 'image')):strtolower(t('images', 'images'))) : "-").'</span>';
			$returnJson['html'] .= '<span class="thumbList">';
			$returnJson['html'] .= '<a name="link"><img src="'.SITE_IMAGE_PATH.'/file_browser/album_icon.png" alt=""></a>';
			$returnJson['html'] .= '</span>';
			
			$returnJson['html'] .= '<span class="filename">'.validation::safeOutputToScreen($folderLabel).'</span>';

            $returnJson['html'] .= '</div>';
			
			if($counter % 6 == 0)
			{
				// double clear so row background colours still look ok
				$returnJson['html'] .= '<div class="clear"></div>';
				$returnJson['html'] .= '<div class="clear"></div>';
			}
			$counter++;
        }
    }
    
    // output images
	if($files)
    {
		foreach ($files AS $file)
		{
			// get file object
			$fileObj = file::hydrate($file);
			
			// check image ownership
			$ownedByCurrentUser = false;
			if(($Auth->loggedIn() == true) && ($Auth->id == $fileObj->userId) && ((int)$fileObj->userId > 0))
			{
				$ownedByCurrentUser = true;
			}
			
			$sizingMethod = 'middle';
			if($thumbnailType == 'full')
			{
				$sizingMethod = 'cropped';
			}
			$previewImageUrlLarge = file::getIconPreviewImageUrl($file, false, 48, false, $thumbnailWidth, $thumbnailHeight, $sizingMethod);
			$previewImageUrlMedium = file::getIconPreviewImageUrlMedium($file);
			
			$extraMenuItems = array();
			$params  = pluginHelper::includeAppends('account_home_file_list_menu_item.php', array('fileObj' => $fileObj, 'extraMenuItems' => $extraMenuItems));
			$extraMenuItems = $params['extraMenuItems'];

			// add on option to set as album cover
			if($fileObj->folderId != null)
			{
				$extraMenuItems['SetAlbum'] = array("label"=>UCWords(t('account_file_set_as_albume_cover', 'Set As Album Cover')), "separator_after"=>true, "action"=>"function() { updateAlbumCover(".(int)$fileObj->id."); }");
			}
			
			$menuItemsStr = '';
			if(COUNT($extraMenuItems))
			{
				$menuItemsStr = json_encode($extraMenuItems);
			}
			
			$returnJson['html'] .= '<div dttitle="'.validation::safeOutputToScreen($file['originalFilename']).'" dtsizeraw="'.validation::safeOutputToScreen($file['fileSize']).'" dtuploaddate="'.validation::safeOutputToScreen(coreFunctions::formatDate($file['uploadedDate'])).'" dtfullurl="'.validation::safeOutputToScreen($fileObj->getFullShortUrl()).'" dtfilename="'.validation::safeOutputToScreen($file['originalFilename']).'" dtstatsurl="'.validation::safeOutputToScreen($fileObj->getStatisticsUrl()).'" dturlhtmlcode="'.validation::safeOutputToScreen($fileObj->getHtmlLinkCode()).'" dturlbbcode="'.validation::safeOutputToScreen($fileObj->getForumLinkCode()).'" dtextramenuitems="'.validation::safeOutputToScreen($menuItemsStr).'" title="'.validation::safeOutputToScreen($file['originalFilename']).' ('.validation::safeOutputToScreen(coreFunctions::formatSize($file['fileSize'])).')" fileId="'.$file['id'].'" class="col-sm-2 col-xs-4 image-thumb image-thumb-'.$sizingMethod.' fileItem'.$file['id'].' fileIconLi '.($file['statusId']!=1?'fileDeletedLi':'').' '.($ownedByCurrentUser==true?'owned-image':'not-owned-image').'">';
			
			// delay rendering of thumbnail to protect the server
			$delayedThumbnailUrls['delayedThumbBrowse'.(int)$fileObj->id] = ((substr($previewImageUrlLarge, 0, 4)=='http')?$previewImageUrlLarge:(SITE_IMAGE_PATH.'/trans_1x1.gif'));
			
			$returnJson['html'] .= '<div class="thumbIcon">';
			$returnJson['html'] .= '<a name="link"><img src="'.(SITE_IMAGE_PATH.'/trans_1x1.gif').'" data-src="'.$previewImageUrlLarge.'" alt="" class="delayedThumbBrowse'.(int)$fileObj->id.' '.((substr($previewImageUrlLarge, 0, 4)!='http')?$previewImageUrlLarge:'').'" style="max-width: 100%; max-height: 100%; min-width: 30px; min-height: 30px;"></a>';
			$returnJson['html'] .= '</div>';
			
			$returnJson['html'] .= '<div class="back">';
			$returnJson['html'] .= '<p>';
			$returnJson['html'] .= validation::safeOutputToScreen($file['originalFilename']);
			$returnJson['html'] .= '</p>';
			$returnJson['html'] .= '</div>';
			
			$returnJson['html'] .= '<span class="filesize">'.validation::safeOutputToScreen(coreFunctions::formatSize($file['fileSize'])).'</span>';
			$returnJson['html'] .= '<span class="fileUploadDate">'.validation::safeOutputToScreen(coreFunctions::formatDate($file['uploadedDate'])).'</span>';
			$returnJson['html'] .= '<span class="thumbList">';
			$returnJson['html'] .= '<a name="link"><img src="'.$previewImageUrlMedium.'" alt=""></a>';
			$returnJson['html'] .= '</span>';
			
			$returnJson['html'] .= '<span class="filename">'.validation::safeOutputToScreen($file['originalFilename']).'</span>';
			
			// menu link
			if($ownedByCurrentUser == true)
			{
				$returnJson['html'] .= '  <div class="fileOptions">';
				$returnJson['html'] .= '      <a class="fileDownload" href="#"><i class="entypo-down"></i></a>';
				$returnJson['html'] .= '  </div>';
			}
			
			$returnJson['html'] .= '</div>';
			
			if($counter % 6 == 0)
			{
				// double clear so row background colours still look ok
				$returnJson['html'] .= '<div class="clear"></div>';
				$returnJson['html'] .= '<div class="clear"></div>';
			}
			$counter++;
		}
	}
    $returnJson['html'] .= '</div>';
	$returnJson['html'] .= '</div>';
	
	// paging
	$currentPage = $pageStart;
	$totalPages = ceil((int)$allStats['totalFileCount']/(int)$_SESSION['search']['perPage']);
	$returnJson['html'] .= '<div class="paginationRow">';
	$returnJson['html'] .= '	<div id="pagination" class="paginationWrapper col-md-12 responsiveAlign">';
	$returnJson['html'] .= '		<ul class="pagination">';
	$returnJson['html'] .= '			<li class="'.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?$pagingJs.'1);':'').' return false;"><i class="entypo-to-start"></i><span>'.UCWords(t('first', 'first')).'</span></a></li>';
	$returnJson['html'] .= '			<li class="'.($currentPage==1?'disabled':'').'"><a href="#" onClick="'.($currentPage>1?$pagingJs.''.((int)$currentPage-1).');':'').' return false;"><i class="entypo-left-dir"></i> <span>'.UCWords(t('previous', 'previous')).'</span></a></li>';
	
	// calculate numbers before and after
	$startPager = $currentPage - 3;
	if($startPager < 1)
	{
		$startPager = 1;
	}
	
	for($i=0; $i<=6; $i++)
	{
		$currentPager = $startPager + $i;
		if($currentPager > $totalPages)
		{
			continue;
		}
		$returnJson['html'] .= '		<li class="'.(($currentPager == $currentPage)?'active':'').'"><a href="#" onclick="'.$pagingJs.''.(int)$currentPager.'); return false;">'.(int)$currentPager.'</a></li>';
	}

	$returnJson['html'] .= '			<li class="'.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?$pagingJs.''.((int)$currentPage+1).');':'').' return false;"><span>'.UCWords(t('next', 'next')).'</span> <i class="entypo-right-dir"></i></a></li>';
	$returnJson['html'] .= '			<li class="'.($currentPage==$totalPages?'disabled':'').'"><a href="#" onClick="'.($currentPage!=$totalPages?$pagingJs.''.((int)$totalPages).');':'').' return false;"><span>'.UCWords(t('last', 'last')).'</span> <i class="entypo-to-end"></i></a></li>';
	$returnJson['html'] .= '		</ul>';
	$returnJson['html'] .= '	</div>';
	
	$returnJson['html'] .= '</div>';
}
else
{
	$returnJson['html'] .= '<div class="toolbar-container">
		<!-- toolbar -->
		<div class="col-md-6 col-sm-8 clearfix">
			<!-- breadcrumbs -->
			<div class="row breadcrumbs-container">
				<div class="col-md-12 col-sm-12 clearfix">
					<ol id="folderBreadcrumbs" class="breadcrumb bc-3 pull-left">'.implode('', $breadcrumbs).'</ol>
				</div>
			</div>
		</div>
	</div>';

	$returnJson['html'] .= '<div class="no-results-wrapper">';
	if(($searchType == 'folder') || ($searchType == 'root'))
	{
		$returnJson['html'] .= '<div class="alert alert-warning"><i class="entypo-attention"></i> '.t('no_images_found_in_this_album', 'No images found within this album.').'</div>';
		if($Auth->loggedIn())
		{
			if (UserPeer::getAllowedToUpload() == true)
			{
				$returnJson['html'] .= '<button type="button" class="btn btn-success btn-icon" onClick="uploadFiles('.(int)$album->id.'); return false;">'.t('upload_images', 'Upload Images').' <i class="entypo-upload"></i></button>';
			}
			$returnJson['html'] .= '<button type="button" class="btn btn-default btn-icon" onClick="showAddFolderForm('.((int)$album->id?$album->id:'null').'); return false;">Add Album <i class="entypo-user-add"></i></button>';
		}
	}
	else
	{
		$returnJson['html'] .= '<div class="alert alert-warning"><i class="entypo-attention"></i> '.t('no_images_found_in_search', 'No images found within album or search criteria.').'</div>';
	}
	$returnJson['html'] .= '</div>';
}

// stats
$returnJson['html'] .= '<input id="rspFolderTotalFiles" value="'.(int)$allStats['totalFileCount'].'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspFolderTotalSize" value="'.$allStats['totalFileSize'].'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspTotalPerPage" value="'.(int)$_SESSION['search']['perPage'].'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspTotalResults" value="'.(int)$allStats['totalFileCount'].'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspCurrentStart" value="'.(int)$pageStart.'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspCurrentPage" value="'.ceil(((int)$pageStart+(int)$_SESSION['search']['perPage'])/(int)$_SESSION['search']['perPage']).'" type="hidden"/>';
$returnJson['html'] .= '<input id="rspTotalPages" value="'.ceil((int)$allStats['totalFileCount']/(int)$_SESSION['search']['perPage']).'" type="hidden"/>';

$returnJson['html'] .= '</div>';
$returnJson['html'] .= '</div>';

// for delayed thumbs
$jsObject = json_encode($delayedThumbnailUrls);
$returnJson['javascript'] .= "delayedThumbnailUrls = ". $jsObject . ";\n";

$returnJson['page_title'] = $pageTitle;
$returnJson['page_url'] = $pageUrl;

// output response
echo json_encode($returnJson);