<?php

// validation
$albumId     = (int)$_REQUEST['a'];
$colWidth      = 3;
$colHeight     = 3;

// load reward details
$pluginObj      = pluginHelper::getInstance('imageviewer');
$pluginDetails  = pluginHelper::pluginSpecificConfiguration('imageviewer');
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

// try to load the album object
$album = null;
if ($albumId)
{
    $album = fileFolder::loadById($albumId);
}

// load album details
if (!$album)
{
    // fail
	die('Could not load album.');
	coreFunctions::output404();
}

// make sure it's publicly shown on the site
if(!$album->isPublic())
{
	// fail
	die('Album is not publicly shared.');
	coreFunctions::output404();
}

// make sure there's no password set
if(strlen($album->accessPassword))
{
	// fail
	die('Album is protected by a password.');
	coreFunctions::output404();
}

// get public images
$totalImages = $db->getValue('SELECT COUNT(id) FROM file WHERE folderId = '.(int)$album->id.' AND statusId = 1');
if($totalImages == 0)
{
	die('No images found.');
}

// output page
echo '<html>';
echo '<body style="margin: 0px; padding: 0px;">';

// get limited results
$totalRowPercent = 0;
$images = $db->getRows('SELECT * FROM file WHERE folderId = '.(int)$album->id.' AND statusId = 1 LIMIT 0, '.($colWidth*$colHeight));
foreach($images AS $image)
{
	// load file object for later
	$fileObj = file::hydrate($image);
	
	$colWidthPercent = number_format(100/$colWidth, 2);
	$previewImageUrl = file::getIconPreviewImageUrl($image, false, 48, false, 300, 300, 'middle');
	echo '<div style="width: '.$colWidthPercent.'%; display: inline-block;">';
	echo '<a href="'.$fileObj->getFullShortUrl().'" target="_blank">';
	echo '<img src="'.$previewImageUrl.'" style="width: 100%; border: 1px solid #ffffff; box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;"/>';
	echo '</div>';
}

// output bottom
echo '</body>';
echo '</html>';