<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// get database connection
$db = Database::getDatabase();

// load theme functions
$themeObj = themeHelper::getLoadedInstance();
$totalActiveImages = (int)file::getTotalActivePublicFiles();
$totalActiveAlbums = (int)fileFolder::getTotalActivePublicFolders();

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');

// load all files
$sQL         = "SELECT COUNT(id) AS total, SUM(fileSize) AS totalFilesize, IF(statusId=1,'active','inactive') AS status FROM file WHERE userId = " . (int) $Auth->id . " GROUP BY IF(statusId=1,'active','inactive')";
$totalData   = $db->getRows($sQL);
$totalActiveFileSize = 0;
foreach($totalData AS $totalDataItem)
{
	if($totalDataItem['status'] == 'active')
	{
		$totalActive = (int)$totalDataItem['total'];
		$totalActiveFileSize = (int)$totalDataItem['totalFilesize'];
	}
	else
	{
		$totalTrash = (int)$totalDataItem['total'];
	}
}

// account stats
$totalFileStorage = UserPeer::getMaxFileStorage($Auth->id);
$storagePercentage = 0;
if ($totalActiveFileSize > 0) {
    $storagePercentage = ($totalActiveFileSize / $totalFileStorage) * 100;
    if ($storagePercentage < 1) {
        $storagePercentage = 1;
    } else {
        $storagePercentage = floor($storagePercentage);
    }
}

// load user object
$user = null;
if ($Auth->loggedIn()) {
    $user = UserPeer::loadUserById($Auth->id);
}

// header top
require_once(SITE_TEMPLATES_PATH . '/partial/_header_file_manager_top.inc.php');
?>
<body class="page-body">
	<?php
	// adblock notification, if enabled via the site settings
	include_once(SITE_TEMPLATES_PATH . '/partial/_ad_block.inc.php');
	?>
    <div class="page-container horizontal-menu with-sidebar fit-logo-with-sidebar">	

        <div class="sidebar-menu fixed">
			<div class="sidebar-mobile-menu visible-xs"> <a href="#" class="with-animation"><i class="entypo-menu"></i> </a> </div>
			<?php if (UserPeer::getAllowedToUpload() == true): ?>
				<div class="sidebar-mobile-upload visible-xs"><a href="#" onClick="uploadFiles(); return false;"><?php echo t('upload_account', 'Upload'); ?><i class="entypo-upload"></i> </a> </div>
			<?php endif; ?>
			
            <!-- logo -->
            <div class="siderbar-logo">
                <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">
                    <img src="<?php echo $themeObj->getMainLogoUrl(); ?>" alt="<?php echo SITE_CONFIG_SITE_NAME; ?>" />
                </a>
            </div>
			
            <ul id="main-menu" class="main-menu">
				<?php if ($Auth->loggedIn()): ?>
				<li class="nav-item visible-xs"><a href="#" onClick="loadImages('-1'); $('.entypo-menu:visible').click(); return false;"><i class="entypo-picture"></i><?php echo validation::safeOutputToScreen(t('navigation_your_images', 'Your Images')); ?></a></li></li>
				<?php endif; ?>
				
                <li class="nav-section-header"><span><?php echo t('navigation_community', 'Community'); ?></span><li>
				<li class="nav-item <?php echo SELECTED_NAVIGATION_LINK == 'browse' ? 'active' : ''; ?>"><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/"><i class="glyphicon glyphicon-camera icon"></i><span><?php echo t('navigation_images', 'Images'); ?></span><span class="badge badge-secondary"><?php echo number_format($totalActiveImages, 0); ?></span></a></li><li>
				<li class="nav-item <?php echo SELECTED_NAVIGATION_LINK == 'album' ? 'active' : ''; ?>"><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/album/"><i class="entypo-picture icon"></i><span><?php echo t('navigation_albums', 'Albums'); ?></span><span class="badge badge-secondary"><?php echo number_format($totalActiveAlbums, 0); ?></span></a></li><li>
				<li class="nav-item <?php echo SELECTED_NAVIGATION_LINK == 'category' ? 'active' : ''; ?>"><a href="<?php echo coreFunctions::getCoreSitePath(); ?>/browse/category/"><i class="entypo-archive"></i><span><?php echo t('navigation_categories', 'Categories'); ?></span></a></li><li>

                <li class="nav-section-header"><span><?php echo t('navigation_account', 'Account'); ?></span><li>
<?php if ($Auth->loggedIn()): ?>
                    <li class="nav-item <?php echo SELECTED_NAVIGATION_LINK == 'profile' ? 'active' : ''; ?>"><a href="<?php echo $user->getProfileUrl(); ?>"><i class="glyphicon glyphicon-user icon"></i><span class="title"><?php echo t('navigation_public_profile', 'Public Profile'); ?></span></a></li><li>
                    <li class="nav-item <?php echo SELECTED_NAVIGATION_LINK == 'likes' ? 'active' : '';?>"><a href="<?php echo $user->getLikesUrl(); ?>"><i class="glyphicon glyphicon-thumbs-up icon"></i><span class="title"><?php echo t('navigation_likes', 'Likes'); ?></span></a></li><li>
<?php else: ?>
                    <li class="nav-item"><a href="<?php echo coreFunctions::getCoreSitePath() . '/register.' . SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="glyphicon glyphicon-user icon"></i><span class="title"><?php echo t('navigation_register', 'Register'); ?></span></a></li><li>
                    <li class="nav-item"><a href="<?php echo coreFunctions::getCoreSitePath() . '/login.' . SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="glyphicon glyphicon-lock icon"></i><span class="title"><?php echo t('login', 'login'); ?></span></a></li><li>
<?php endif; ?>

                    <?php
                    // add any other navigation items
                    $pluginNavigation = pluginHelper::generateHeaderNavStructure(array(), $Auth->level_id);

                    // format nagivation for template
                    $navigationHtmlItems = array();
                    foreach ($pluginNavigation AS $pluginNavigationItem) {
                        $navHtml = '<li class="';
                        if (isset($pluginNavigationItem['link_key']) && $pluginNavigationItem['link_key'] == SELECTED_NAVIGATION_LINK) {
                            $navHtml .= 'active';
                        }
                        $navHtml .= '"><a href="' . $pluginNavigationItem['link_url'] . '"';
                        $navHtml .= '><i class="glyphicon glyphicon-chevron-right icon"></i>' . validation::safeOutputToScreen(UCWords($pluginNavigationItem['link_text'])) . '</a></li>';
                        $navigationHtmlItems[] = $navHtml;
                    }

                    // output nav
                    echo implode('', $navigationHtmlItems);
                    ?>

                    <?php if ($Auth->loggedIn()): ?>
                    <li class="nav-section-header root-level"><span><?php echo t('navigation_your_images', 'Your Images'); ?></span></li>
                    <?php endif; ?>
            </ul>

                    <?php if ($Auth->loggedIn()): ?>
                <div id="folderTreeview"></div>
                    <?php endif; ?>

            <div class="clear"></div>

            <?php pluginHelper::includeAppends('file_manager_left_nav_base.php', array('Auth' => $Auth)); ?>
        </div>

        <header class="navbar navbar-fixed-top"><!-- set fixed position by adding class "navbar-fixed-top" -->
            <div class="navbar-inner">
                <div class="navbar-form navbar-form-sm navbar-left shift" ui-shift="prependTo" data-target=".navbar-collapse" role="search">
                    <div class="form-group">
                        <div class="input-group" id="top-search">
                            <input type="text" value="<?php echo isset($_REQUEST['t'])?validation::safeOutputToScreen($_REQUEST['t']):''; ?>" class="form-control input-sm bg-light no-border rounded padder typeahead" placeholder="<?php echo addslashes(t('account_header_search_images', 'Search images...')); ?>" onKeyUp="handleTopSearch(event, this); return false;" id="searchInput">
                            <span class="input-group-btn">
                                <button type="submit" class="btn btn-sm bg-light rounded" onClick="handleTopSearch(null, $('#searchInput')); return false;" title="" data-original-title="<?php echo t('filter', 'Filter'); ?>" data-placement="bottom" data-toggle="tooltip"><i class="entypo-search"></i></button>
                                <button type="submit" class="btn btn-sm bg-light rounded" onClick="showFilterModal(); return false;" title="" data-original-title="<?php echo t('advanced_search', 'Advanced Search'); ?>" data-placement="bottom" data-toggle="tooltip"><i class="entypo-cog"></i></button>
                            </span>
                        </div>
                    </div>
                </div>

				<?php if (UserPeer::getAllowedToUpload() == true): ?>
					<div class="upload-button-wrapper pull-left">
						<button class="btn btn-green" type="button" onClick="uploadFiles(); return false;"><?php echo t('upload_account', 'Upload'); ?> <i class="entypo-upload"></i></button>
					</div>
				<?php endif; ?>

                <ul class="mobile-account-toolbar-wrapper nav navbar-right pull-right">
                <?php if ($Auth->loggedIn()): ?>
                    <?php
                    // load all in the past 14 days for current user
                    $internalNotifications = internalNotification::loadRecentByUser($Auth->id);
                    $unreadCount = 0;
                    foreach ($internalNotifications AS $internalNotification) {
                        if ($internalNotification['is_read'] == 0) {
                            $unreadCount++;
                        }
                    }
                    ?>
                        <li class="dropdown internal-notification">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                <i class="entypo-globe"></i>
                        <?php if ($unreadCount > 0): ?>
                                    <span class="badge badge-warning"><?php echo $unreadCount; ?></span>
                        <?php endif; ?>
                            </a>
                            <!-- dropdown menu -->
                            <ul class="dropdown-menu">
                                <li class="top">
                                    <p class="small">
                                <?php if ($unreadCount > 0): ?>
                                            <a href="#" class="pull-right mark-read-link" onClick="markInternalNotificationsRead();
                                                        return false;"><?php echo t('file_manager_mark_all_read', 'Mark all Read'); ?></a>
                                <?php endif; ?>
                                        <span class="unread-count"><?php echo $unreadCount != 1 ? t('file_manager_you_have_x_new_notifications', 'You have <strong>[[[UNREAD]]]</strong> new notifications.', array('UNREAD' => $unreadCount)) : t('file_manager_you_have_x_new_notification', 'You have <strong>[[[UNREAD]]]</strong> new notification.', array('UNREAD' => $unreadCount)); ?></span>
                                    </p>
                                </li>
                                <li>
                                    <ul class="dropdown-menu-list scroller">
                                        <?php foreach ($internalNotifications AS $internalNotification): ?>
                                            <li class="<?php echo $internalNotification['is_read'] == 0 ? 'unread' : 'read'; ?> notification-<?php echo $internalNotification['is_read'] == 0 ? 'info' : 'default'; ?>">
                                                <a href="<?php echo strlen($internalNotification['href_url']) ? $internalNotification['href_url'] : '#'; ?>" <?php echo strlen($internalNotification['onclick']) ? (' onClick="' . addslashes($internalNotification['onclick']) . '"') : ''; ?>>
                                                    <i class="<?php echo validation::safeOutputToScreen($internalNotification['notification_icon']); ?> pull-right"></i>
                                                    <span class="line <?php echo $internalNotification['is_read'] == 0 ? 'text-bold' : ''; ?>">
        <?php echo $internalNotification['content']; // allow for html    ?>
                                                    </span>
                                                    <span class="line small">
                                            <?php echo coreFunctions::timeToRelativeString($internalNotification['date_added']); ?>
                                                    </span>
                                                </a>
                                            </li>
    <?php endforeach; ?>
                                    </ul>
                                </li>
                            </ul>
                        </li>

                        <li class="root-level responsive-Hide">
    <?php
    $className = 'info';
    $label = 'FREE USER';
    $url = coreFunctions::getCoreSitePath() . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION;

    // reload user level from database encase they've just upgraded
    $packageId = $db->getValue('SELECT level_id FROM users WHERE id = ' . (int) $Auth->id . ' LIMIT 1');
    switch ($packageId) {
        case 10:
            $className = 'secondary';
            $label = 'MODERATOR';
            $url = ADMIN_WEB_ROOT . '/';
            break;
        case 20:
            $className = 'danger';
            $label = 'ADMIN AREA';
            $url = ADMIN_WEB_ROOT . '/';
            break;
        default:
            $className = 'success';
            $label = strtoupper(UserPeer::getLevelLabel($packageId));
            $url = coreFunctions::getCoreSitePath() . '/account_edit.' . SITE_CONFIG_PAGE_EXTENSION;
            break;
    }
    ?>
                            <a href="<?php echo $url; ?>">
                                <span class="badge badge-<?php echo $className; ?>"><?php echo strtoupper(t(str_replace(' ', '_', strtolower($label)), $label)); ?></span>
                            </a>
                        </li>
                        
                        <li class="dropdown account-nav-icon">
                            <a href="#" data-toggle="dropdown" class="dropdown-toggle clear">
                                <span class="thumb-sm avatar pull-right">
                                    <img width="40" height="40" class="img-circle" alt="<?php echo validation::safeOutputToScreen($Auth->getAccountScreenName()); ?>" src="<?php echo WEB_ROOT; ?>/page/view_avatar.php?id=<?php echo $Auth->id; ?>&width=40&height=40"/>
                                </span>
                                <span class="user-screen-name hidden-sm hidden-md"><?php echo validation::safeOutputToScreen($Auth->getAccountScreenName()); ?></span> <b class="caret"></b>
                            </a>
                            <!-- dropdown -->
                            <ul class="dropdown-menu">
                                <?php
                                $label = UCWords(t('unlimited', 'unlimited'));
                                if ($totalFileStorage > 0) {
                                    $label = $storagePercentage . '%';
                                }
                                ?>

                                <li class="account-menu bg-light" title="<?php echo $label; ?>">
                                    <div>
                                        <p>
                                <?php if ($totalFileStorage > 0): ?>
                                                <span><span id="totalActiveFileSize"><?php echo validation::safeOutputToScreen(coreFunctions::formatSize($totalActiveFileSize)); ?></span> <?php echo t("of", "of"); ?> <?php echo validation::safeOutputToScreen(coreFunctions::formatSize($totalFileStorage)); ?> <?php echo t("used", "used"); ?></span>
                                <?php else: ?>
                                                <span><span id="totalActiveFileSize"><?php echo validation::safeOutputToScreen(coreFunctions::formatSize($totalActiveFileSize)); ?></span> <?php echo t("of", "of"); ?> <?php echo UCWords(t('unlimited', 'unlimited')); ?></span>
                                <?php endif; ?>
                                        </p>
                                    </div>
                                    <div class="progress progress-xs m-b-none dker">
                                        <div style="width: <?php echo $storagePercentage; ?>%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="<?php echo $storagePercentage; ?>" role="progressbar" class="progress-bar progress-bar-success"></div>
                                    </div>
                                </li>
                                <li>
                                    <a href="<?php echo $user->getProfileUrl(); ?>"></i> <i class="entypo-user"></i><?php echo t('navigation_public_profile', 'Public Profile'); ?></a>
                                </li>
                                <li>
                                    <a href="<?php echo coreFunctions::getCoreSitePath() . '/account_edit.' . SITE_CONFIG_PAGE_EXTENSION; ?>"></i> <i class="entypo-cog"></i><?php echo t('file_manager_account_settings', 'Account Settings'); ?></a>
                                </li>
                            <?php
                            if (UserPeer::enableUpgradePage() == 'yes') {
                                $label = t('uprade_account', 'upgrade account');
                                if ($Auth->hasAccessLevel(2)) {
                                    $label = t('extend_account', 'extend account');
                                }
                                ?>
                                    <li>
                                        <a href="<?php echo coreFunctions::getCoreSitePath() . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION; ?>"> <i class="entypo-upgrade"></i><?php echo UCWords($label); ?></a>
                                    </li>
                                    <?php
                                }
                                ?>
                                <li class="divider"></li>
                                <li>
                                    <a href="<?php echo coreFunctions::getCoreSitePath() . '/logout.' . SITE_CONFIG_PAGE_EXTENSION; ?>"> <i class="entypo-logout"></i><?php echo t('file_manager_logout', 'Logout'); ?></a>
                                </li>
                            </ul>
                            <!-- / dropdown -->
                        </li>
<?php else: ?>

                        <li>
                            <a href="<?php echo coreFunctions::getCoreSitePath() . '/register.' . SITE_CONFIG_PAGE_EXTENSION; ?>">
                                <i class="entypo-user"></i>
                                <?php echo t('navigation_register', 'Register'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo coreFunctions::getCoreSitePath() . '/login.' . SITE_CONFIG_PAGE_EXTENSION; ?>">
                                <i class="entypo-lock"></i>
    <?php echo t('login', 'login'); ?>
                            </a>
                        </li>

<?php endif; ?>
                </ul>
            </div>
        </header>

        <div id="main-ajax-container" class="layer"></div>

<?php
// file manager javascript
require_once(SITE_TEMPLATES_PATH . '/partial/_account_home_javascript.inc.php');
?>