#!/bin/bash
#PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:~/bin
#install
#Check system
function check_sys(){
    local checkType=$1;
    local value=$2;

    local release='';
    local systemPackage='';

    if [[ -f /etc/redhat-release ]]; then
        release="centos";
        systemPackage="yum";
    elif cat /etc/issue | grep -Eqi "debian"; then
        release="debian"
        systemPackage="apt";
    elif cat /etc/issue | grep -Eqi "ubuntu"; then
        release="ubuntu"
        systemPackage="apt";
    elif cat /etc/issue | grep -Eqi "centos|red hat|redhat"; then
        release="centos"
        systemPackage="yum";
    elif cat /proc/version | grep -Eqi "debian"; then
        release="debian";
        systemPackage="apt";
    elif cat /proc/version | grep -Eqi "ubuntu"; then
        release="ubuntu";
        systemPackage="apt";
    elif cat /proc/version | grep -Eqi "centos|red hat|redhat"; then
        release="centos";
        systemPackage="yum";
    fi;

    if [[ ${checkType} == "sysRelease" ]]; then
        if [ "$value" == "$release" ]; then
            return 0;
        else
            return 1;
        fi;
    elif [[ ${checkType} == "packageManager" ]]; then
        if [ "$value" == "$systemPackage" ]; then
            return 0;
        else
            return 1;
        fi;
    fi;
}
# Get version

# CentOS version


function get_ip(){
    local IP=$( ip addr | egrep -o '[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' | egrep -v "^192\.168|^172\.1[6-9]\.|^172\.2[0-9]\.|^172\.3[0-2]\.|^10\.|^127\.|^255\.|^0\." | head -n 1 );
    [ -z ${IP} ] && IP=$( wget -qO- -t1 -T2 ipv4.icanhazip.com );
    [ -z ${IP} ] && IP=$( wget -qO- -t1 -T2 ipinfo.io/ip );
    [ ! -z ${IP} ] && echo ${IP} || echo;
}
get_char(){
    SAVEDSTTY=`stty -g`
    stty -echo
    stty cbreak
    dd if=/dev/tty bs=1 count=1 2> /dev/null
    stty -raw
    stty echo
    stty $SAVEDSTTY
}
#Current folder
cur_dir=`pwd`;
	 if [ -f /etc/init.d/shadowsocks ]; then
        echo "Shadowsocks start success!";
		exit;

	else
# Make sure only root can run our script
    if [[ $EUID -ne 0 ]]; then
       echo "Error:This script must be run as root!" 1>&2;
       exit 1;
    fi;
# Disable selinux
    if [ -s /etc/selinux/config ] && grep 'SELINUX=enforcing' /etc/selinux/config; then
        sed -i 's/SELINUX=enforcing/SELINUX=disabled/g' /etc/selinux/config
        setenforce 0;
    fi;
	function getversion(){
    if [[ -s /etc/redhat-release ]]; then
        grep -oE  "[0-9.]+" /etc/redhat-release;
    else
        grep -oE  "[0-9.]+" /etc/issue;
    fi;
}
function centosversion(){
    if check_sys sysRelease centos; then
        local code=$1;
        local version="$(getversion)";
        local main_ver=${version%%.*};
        if [ "$main_ver" == "$code" ]; then
            return 0;
        else
            return 1;
        fi;
    else
        return 1;
    fi
}
    check_sys;
	echo "Please input password for shadowsocks:";
    read -p "(Default password: www.sxsay.com):" shadowsockspwd;
    [ -z "${shadowsockspwd}" ] && shadowsockspwd="www.sxsay.com";
    echo;
    echo "---------------------------";
    echo "password = ${shadowsockspwd}";
    echo "---------------------------";
    echo;
	# Set shadowsocks-go config port
    while true;
    do
    echo -e "Please input port for shadowsocks [1-65535]:";
    read -p "(Default port: 6868):" shadowsocksport;
    [ -z "${shadowsocksport}" ] && shadowsocksport="6868";
    expr ${shadowsocksport} + 0 &>/dev/null;
    if [ $? -eq 0 ]; then
        if [ ${shadowsocksport} -ge 1 ] && [ ${shadowsocksport} -le 65535 ]; then
            echo;
            echo "---------------------------";
            echo "port = ${shadowsocksport}";
            echo "---------------------------";
            echo;
            break;
        else
            echo "Input error, please input correct number";
        fi;
    else
        echo "Input error, please input correct number";
    fi;
	done
    echo;
    echo "Press any key to start...or Press Ctrl+C to cancel";
    char=`get_char`;
    #Install necessary dependencies
	
    if check_sys packageManager yum; then
        yum install -y wget unzip gzip curl;
    elif check_sys packageManager apt; then
        apt-get -y update;
        apt-get install -y wget unzip gzip curl;
    fi;
    echo;
	 cd ${cur_dir};
	 # is 64bit or not
	 is_64bit='32' && [ `getconf WORD_BIT` == '32' ] && [ `getconf LONG_BIT` == '64' ] && is_64bit='64';
	 if [ "$is_64bit" == '64' ]; then
        if ! wget -c http://www.sxsay.com/amh/modules/SS/shadowsocks-server-linux64-1.2.1.gz; then
            echo "Failed to download shadowsocks-server-linux64-1.2.1.gz";
            exit 1;
        fi;
        gzip -d shadowsocks-server-linux64-1.2.1.gz;
        if [ $? -eq 0 ]; then
            echo "Decompress shadowsocks-server-linux64-1.2.1.gz success";
        else
            echo "Decompress shadowsocks-server-linux64-1.2.1.gz failed";
            exit 1;
        fi;
        mv -f shadowsocks-server-linux64-1.2.1 /usr/bin/shadowsocks-server;
    else
        if ! wget -c http://www.sxsay.com/amh/modules/SS/shadowsocks-server-linux32-1.2.1.gz; then
            echo "Failed to download shadowsocks-server-linux32-1.2.1.gz";
            exit 1;
        fi;
        gzip -d shadowsocks-server-linux32-1.2.1.gz;
        if [ $? -eq 0 ]; then
            echo "Decompress shadowsocks-server-linux32-1.2.1.gz success";
        else
            echo "Decompress shadowsocks-server-linux32-1.2.1.gz failed";
            exit 1;
        fi;
        mv -f shadowsocks-server-linux32-1.2.1 /usr/bin/shadowsocks-server;
    fi;

    # Download start script
    if check_sys packageManager yum; then
        if ! wget --no-check-certificate -O /etc/init.d/shadowsocks http://www.sxsay.com/amh/modules/SS/shadowsocks-go; then
            echo "Failed to download Shadowsocks auto start script!";
            exit 1;
        fi;
    elif check_sys packageManager apt; then
        if ! wget --no-check-certificate -O /etc/init.d/shadowsocks http://www.sxsay.com/amh/modules/SS/shadowsocks-go-debian; then
            echo "Failed to download Shadowsocks auto start script!";
            exit 1;
        fi;
    fi;
if [ ! -d /etc/shadowsocks ]; then
        mkdir -p /etc/shadowsocks;
    fi;
    cat > /etc/shadowsocks/config.json<<-EOF
{
    "server":"0.0.0.0",
    "server_port":${shadowsocksport},
    "local_port":1080,
    "password":"${shadowsockspwd}",
    "method":"aes-256-cfb",
    "timeout":600
}
EOF

                echo "firewall set start...";
                /sbin/iptables-save > /etc/amh-iptables;
		        sed -i '/--dport 6868 -j ACCEPT/d' /etc/amh-iptables;
                sed -i '/--dport 1080 -j ACCEPT/d' /etc/amh-iptables;
                /sbin/iptables-restore < /etc/amh-iptables;
		        /sbin/iptables -I INPUT -p tcp --dport ${shadowsocksport} -j ACCEPT;
		        /sbin/iptables -I INPUT -p tcp --dport 1080 -j ACCEPT;
                /sbin/iptables-save > /etc/amh-iptables;
				echo 'IPTABLES_MODULES="ip_conntrack_ftp"' >>/etc/sysconfig/iptables-config;
                echo "port ${shadowsocksport} has been set up.";


	    if [ -f /usr/bin/shadowsocks-server ]; then
        echo "Shadowsocks install success!";
        chmod +x /usr/bin/shadowsocks-server;
        chmod +x /etc/init.d/shadowsocks;

        if check_sys packageManager yum; then
            chkconfig --add shadowsocks;
            chkconfig shadowsocks on;
        elif check_sys packageManager apt; then
            update-rc.d -f shadowsocks defaults;
        fi;

        /etc/init.d/shadowsocks start;
        if [ $? -eq 0 ]; then
            echo "Shadowsocks start success!";
        else
            echo "Shadowsocks start failed!";
        fi;
    else
        echo;
        echo "Shadowsocks install failed!";
        exit 1;
    fi;

    clear;
    echo;
	echo "[LNMP/Nginx] Amysql Host - AMH 4.5";
	echo "AMH Module Shadowsocks";
	echo "http://www.Sxsay.com";
    echo "Congratulations, Shadowsocks install completed!";
    echo -e "Your Server IP: $(get_ip) ";
    echo -e "Your Server Port: ${shadowsocksport} ";
    echo -e "Your Password: ${shadowsockspwd} ";
    echo -e "Your Local Port: 1080 ";
    echo -e "Your Encryption Method: aes-256-cfb ";
    echo ;
	echo "Client Downloads:";
	echo "https://github.com/shadowsocks/shadowsocks-windows/releases";
	echo "";
    echo "Welcome to visit:https://www.sxsay.com/705.html";
    echo "Enjoy it!";
    echo;
fi;
