/usr/local/bin/php
<?php

/*
This script is to enforce a level of password difficulty that users must use.
You can change the minimum length if you wish, the default is 6.
The requirement for special characters is disabled by default.

To disable any function, simply add // in front of its call below.
To enable any disabled function, remove the // from in front of its call.
Do this at the FUNCTION CALL section of the script:

*/


$min_length = 6;
$pass = getenv("password");
$random_password_length = getenv("random_password_length");

if ($random_password_length < $min_length)
{
	$min_length = $random_password_length;
}


//FUNCTION CALL section

check_length($pass);
enforce_mixed_case($pass);
enforce_numbers($pass);
//enforce_shift_chars($pass);

//FUNCTION CALL section, end

//passes the test
echo "Password OK\n";

exit(0);


function enforce_shift_chars($str)
{
	if (!has_shift_chars($str))
	{
		echo "Password must have at least one special character such as !@#%$ etc..\n";
		exit(3);
	}
}

function enforce_numbers($str)
{
	if (!has_numbers($str))
	{
		echo "Password must have numbers\n";
		exit(2);
	}
}

function enforce_mixed_case($str)
{
	if (!has_caps($str) || !has_lower_case($str))
	{
		echo "Password must have both upper and lower case characters\n";
		exit(2);
	}
}

function check_length($str)
{
	global $min_length;
	if (strlen($str) < $min_length)
	{
		echo "Password is too short.  Use at least $min_length characters\n";
		exit(1);
	}
}

function has_shift_chars($str)
{
	//return ereg("[\~\!\@\#\$\%\^\&\*\(\)\-\=\_\+\{\}\:\;\|\<\>\,\.\?\/]+", $str);
	return preg_match("/[\~\!\@\#\$\%\^\&\*\(\)\-\=\_\+\{\}\:\;\|\<\>\,\.\?\/]+/", $str);
}

function has_numbers($str)
{
	//return ereg("[0-9]+", $str);
	return preg_match("/[0-9]+/", $str);
}

function has_caps($str)
{
	//return ereg("[A-Z]+", $str);
	return preg_match("/[A-Z]+/", $str);
}

function has_lower_case($str)
{
	//return ereg("[a-z]+", $str);
	return preg_match("/[a-z]+/", $str);
}

exit(0);

?>
