/usr/local/bin/php
<?php

$use_pasv = true;

$ftp_server = getenv("ftp_ip");
$ftp_user_name = getenv("ftp_username");
$ftp_user_pass = getenv("ftp_password");
$ftp_remote_path = getenv("ftp_path");
$ftp_port = getenv("ftp_port");
$ftp_remote_file = getenv("ftp_remote_file");
$ftp_local_file = getenv("ftp_local_file");

$conn_id = ftp_connect($ftp_server, $ftp_port);
if (!$conn_id)
{
	echo "Unable to connect to ${ftp_server}:${ftp_port}\n";
	exit(1);
}

$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 

if (!$login_result)
{
	echo "Inavalid login/password for $ftp_user_name on $ftp_server";
	ftp_close($conn_id);
	exit(2);
}

ftp_pasv($conn_id, $use_pasv);

if (!ftp_chdir($conn_id, $ftp_remote_path))
{
	echo "Invalid remote path '$ftp_remote_path'";
	ftp_close($conn_id);
	exit(3);
}

if (ftp_get($conn_id, $ftp_local_file, $ftp_remote_file, FTP_BINARY))
{
	ftp_close($conn_id);
	exit(0);
}
else
{
	$use_pasv = false;

	ftp_pasv($conn_id, $use_pasv);

	if (ftp_get($conn_id, $ftp_local_file, $ftp_remote_file, FTP_BINARY))
	{
		ftp_close($conn_id);
        	exit(0);
	}
	else
	{
		echo "Error while downloading $ftp_remote_file";
		ftp_close($conn_id);
		exit(4);
	}
}
   
?>
