/bin/sh
FTPPUT=/usr/bin/ncftpput
TOUCH=/bin/touch
PORT=${ftp_port}

if [ ! -e $TOUCH ] && [ -e /usr/bin/touch ]; then
	TOUCH=/usr/bin/touch
fi

if [ ! -e $FTPPUT ]; then
	echo "";
	echo "*** Backup not uploaded ***";
	echo "Please install $FTPPUT by running:";
	echo "";
	echo "cd /usr/local/directadmin/scripts";
	echo "./ncftp.sh";
	echo "";
	exit 10;
fi

if [ ! -e "${ftp_local_file}" ]; then
	echo "Cannot find backup file ${ftp_local_file} to upload";
	exit 11;
fi

CFG=${ftp_local_file}.cfg
/bin/rm -f $CFG
$TOUCH $CFG
/bin/chmod 600 $CFG
/bin/echo "host $ftp_ip" >> $CFG
/bin/echo "user $ftp_username" >> $CFG
/bin/echo "pass $ftp_password" >> $CFG

if [ ! -s ${CFG} ]; then
	echo "${CFG} is empty. ncftpput is not going to be happy about it.";
	ls -la ${CFG}
	ls -la ${ftp_local_file}
	df -h
fi

$FTPPUT -f $CFG -V -t 25 -P $PORT -m "$ftp_path" "$ftp_local_file" 2>&1
RET=$?

/bin/rm -f $CFG

exit $RET
