#!/bin/sh

LICENSE=/usr/local/directadmin/conf/license.key

INSECURE=0
if [ -s /root/.insecure_download ]; then
	INSECURE=`cat /root/.insecure_download`
fi

if [ $# -lt 2 ]; then
	echo "Usage:";
	echo "$0 <cid> <lid> [<ip>]";
	echo "";
	echo "definitons:";
	echo "  cid: Client ID";
	echo "  lid: License ID";
	echo "  ip:  your server IP (only needed when wrong ip is used to get license)";
	echo "example: $0 999 9876";
	exit 0;
fi

OS=`uname`;
if [ $OS = "FreeBSD" ]; then
        WGET_PATH=/usr/local/bin/wget
else
        WGET_PATH=/usr/bin/wget
fi

WGET_OPTION="";
COUNT=`$WGET_PATH --help | grep -c no-check-certificate`
if [ "$COUNT" -ne 0 ]; then
        WGET_OPTION="--no-check-certificate";
fi

#WGET_10=`$WGET_PATH -V 2>/dev/null | head -n1 | grep -c 1.10`
#WGET_OPTION="";
#if [ $WGET_10 -eq 1 ]; then
#        WGET_OPTION="--no-check-certificate";
#fi

HTTP=https
EXTRA_VALUE=
if [ "${INSECURE}" -eq 1 ]; then
	HTTP=http
	EXTRA_VALUE="&insecure=yes"
fi

if [ $# = 3 ]; then
	$WGET_PATH $WGET_OPTION ${HTTP}://www.directadmin.com/cgi-bin/licenseupdate?lid=${2}\&uid=${1}${EXTRA_VALUE} -O $LICENSE --bind-address=${3}
else
	$WGET_PATH $WGET_OPTION ${HTTP}://www.directadmin.com/cgi-bin/licenseupdate?lid=${2}\&uid=${1}${EXTRA_VALUE} -O $LICENSE
fi

if [ $? -ne 0 ]
then
	echo "Error downloading the license file";
	exit 1;
fi

COUNT=`cat $LICENSE | grep -c "* You are not allowed to run this program *"`;

if [ $COUNT -ne 0 ]
then
	echo "You are not authorized to download the license with that client id and license id (and/or ip). Please email sales@directadmin.com";
	exit 1;
fi

chmod 600 $LICENSE
chown diradmin:diradmin $LICENSE
exit 0;
