#!/bin/bash

if [ $# -lt "1" ]
then
        echo "Usage: $0 <hostname> (<ip>)";
        exit 1;
fi

IP="127.0.0.1";
SETUP=/usr/local/directadmin/scripts/setup.txt
ETH_DEV=eth0
if [ -e $SETUP ]
then
	IP=`cat $SETUP | grep ip= | cut -d= -f2`;
else
	IP=`/sbin/ifconfig $ETH_DEV | grep 'inet addr:' | cut -d: -f2 | cut -d\  -f1`;
fi

if [ $# -gt "1" ]
then
	IP=$2;
fi

OLDHOST=`hostname`

/bin/hostname -v $1;

#remove any previous hostnames.
cat /etc/hosts | grep -v $1 | grep -v '#' > /etc/hosts.tmp

#start the file over
echo "# Do not remove the following line, or various programs" > /etc/hosts
echo "# that require network functionality will fail." >> /etc/hosts

COUNT=`cat /etc/hosts.tmp | grep -c localhost`
if [ $COUNT -lt "1" ]
then
	echo -e "127.0.0.1\t\tlocalhost localhost.localdomain" >> /etc/hosts
fi

cat /etc/hosts.tmp >> /etc/hosts

echo -e "${IP}\t\t${1}" >> /etc/hosts

chmod 644 /etc/hosts


if [ -e /etc/debian_version ]; then
	echo $1 > /etc/hostname
else
	STR="/usr/bin/perl -pi -e 's/HOSTNAME=(.*)/HOSTNAME=${1}/' /etc/sysconfig/network;";
	eval $STR;
fi


#for exim.
if [ -e /etc/virtual/domains ]
then
	COUNT=`cat /etc/virtual/domains | grep -c $1`;
	if [ "$COUNT" -lt 1 ]
	then
		echo $1 >> /etc/virtual/domains;
	fi
fi

#this is for exim 4 as it wants the dir for the filters

if [ ! -e /etc/virtual ]
then
	/bin/mkdir -p /etc/virtual
	/bin/chown -f mail:mail /etc/virtual
	/bin/chmod -f 755 /etc/virtual
fi

DIR=/etc/virtual/${1}
/bin/mkdir -p $DIR 1>/dev/null 2>/dev/null
/bin/chown -f mail:mail $DIR 1>/dev/null 2>/dev/null
/bin/chmod -f 711 $DIR 1>/dev/null 2>/dev/null


#mysql pid file.
PIDF=/var/lib/mysql/${OLDHOST}.pid
if [ -e $PIDF ]; then
	mv $PIDF /var/lib/mysql/${1}.pid
fi

PIDF=/home/mysql/${OLDHOST}.pid
if [ -e $PIDF ]; then
        mv $PIDF /home/mysql/${1}.pid
fi

exit 0;
