#!/bin/sh

#script to change ips on a DA server.
#usage:
# $0 <oldip> <newip>

LOG=/var/log/directadmin/ipswap.log

MYUID=`/usr/bin/id -u`
if [ "$MYUID" != 0 ]; then
	echo "You require Root Access to run this script";
	exit 0;
fi

if [ $# != 2 ] && [ $# != 3 ]; then
	echo "Usage:";
	echo "$0 <oldip> <newip> [<file>]";
	echo "you gave #$#: $0 $1 $2 $3";
	exit 0;
fi

OLD_IP=$1
NEW_IP=$2

log()
{
	echo -e "$1";
	echo -e "$1" >> $LOG;
}

swapfile()
{
	if [ ! -e $1 ]; then
		log "Cannot Find $1 to change the IPs. Skipping...";
		return;
	fi
	
	TEMP="perl -pi -e 's/(^|[\s.=\/:])${OLD_IP}([\s.>:])/\${1}${NEW_IP}\${2}/g' $1"
        eval $TEMP;

	log "$1\t: $OLD_IP -> $NEW_IP";
}

if [ $# = 3 ]; then

	swapfile $3;
	exit 0;
fi

IPFILE_OLD=/usr/local/directadmin/data/admin/ips/$OLD_IP
IPFILE_NEW=/usr/local/directadmin/data/admin/ips/$NEW_IP
if [ ! -e $IPFILE_OLD ]; then
	echo -n "$IPFILE_OLD does not exist.  Do you want to continue anyway? (y/n) : ";
	read YESNO;
	if [ "$YESNO" != "y" ]; then
		exit 0;
	fi
else
	mv -f $IPFILE_OLD $IPFILE_NEW
fi

swapfile /etc/httpd/conf/httpd.conf
swapfile /etc/httpd/conf/extra/httpd-vhosts.conf
swapfile /etc/httpd/conf/ips.conf
swapfile /etc/proftpd.conf
swapfile /etc/proftpd.vhosts.conf
swapfile /etc/hosts
swapfile /usr/local/directadmin/scripts/setup.txt
swapfile /usr/local/directadmin/data/admin/ip.list
swapfile /usr/local/directadmin/data/admin/show_all_users.cache

ULDDU=/usr/local/directadmin/data/users

for i in `ls $ULDDU`; do
{

	if [ ! -d $ULDDU/$i ]; then
		continue;
	fi
	
	swapfile $ULDDU/$i/user.conf
	swapfile $ULDDU/$i/httpd.conf
	
	if [ -e $ULDDU/$i/ip.list ]; then
		swapfile $ULDDU/$i/ip.list
	fi

	swapfile $ULDDU/$i/user_ip.list	

	for j in `ls $ULDDU/$i/domains/*.conf; ls $ULDDU/$i/domains/*.ftp; ls $ULDDU/$i/domains/*.ip_list`; do
	{
		swapfile $j
	};
	done;
};
done;

OS=`uname`
if [ $OS = "FreeBSD" ]; then
	DB_PATH=/etc/namedb
else
	if [ -e /etc/debian_version ]; then
		DB_PATH=/etc/bind
	else
		DB_PATH=/var/named
	fi
fi

for i in `ls $DB_PATH/*.db`; do
{
	swapfile $i
};
done;

#this is needed to update the serial in the db files.
echo "action=rewrite&value=named" >> /usr/local/directadmin/data/task.queue
echo "action=cache&value=showallusers" >> /usr/local/directadmin/data/task.queue
echo "action=httpd&value=restart" >> /usr/local/directadmin/data/task.queue

log "\n*** Done swapping $OLD_IP to $NEW_IP ***\n";
