#!/bin/bash

#Mysql installer script

#have to change the name of the startup script so that dataskq can find it
#(has to have same name as the process)

CMD_LINE=0;
if [ $# -gt 3 ]; then
	CMD_LINE=$4
fi

setStartupScript() {
	if [ -e /etc/rc.d/init.d/mysql ]
	then
		/sbin/chkconfig --del mysql
		mv -f /etc/rc.d/init.d/mysql /etc/rc.d/init.d/mysqld
		/sbin/chkconfig --add mysqld
	fi
}

setRootPass() {

	#/usr/bin/mysqladmin --user=root password $1 1> /dev/null 2> /dev/null

        /usr/bin/mysqladmin --user=root password $1 1> /dev/null 2> /dev/null
        echo "UPDATE mysql.user SET password=PASSWORD('${1}') WHERE user='root';"> mysql.temp;
	echo "UPDATE mysql.user SET password=PASSWORD('${1}') WHERE password='';">> mysql.temp;
	echo "DROP DATABASE IF EXISTS test;" >> mysql.temp
        echo "FLUSH PRIVILEGES;" >> mysql.temp;
        /usr/bin/mysql mysql --user=root --password=${1} < mysql.temp;
        rm -f mysql.temp;
}

setDAuser() {

	FILE="/usr/local/directadmin/conf/mysql.conf"

	echo "user=${2}" > $FILE
	echo "passwd=${3}" >> $FILE

	chown -f diradmin.diradmin $FILE;
	chmod -f 400 $FILE;

	#ok, now we'll create a temp file and run mysql that way.

	echo "GRANT CREATE, DROP ON *.* TO ${2}@localhost IDENTIFIED BY '${3}' WITH GRANT OPTION;" > mysql.temp;
	echo "GRANT ALL PRIVILEGES ON *.* TO ${2}@localhost IDENTIFIED BY '${3}' WITH GRANT OPTION;" >> mysql.temp;

	#echo "Enter the password for the root user of MySQL: ";

	/usr/bin/mysql --user=root --password=${1} < mysql.temp;

	rm -f mysql.temp;
}

if [ $# -lt "3" ]
then
	echo "Usage: $0 mysqlrootpass da_dbuser da_pass";
	echo "*** do not use spaces in your passwords ***";
	exit 1;
fi

#stop taskq from trying
SERVICES=/usr/local/directadmin/data/admin/services.status
if [ -e $SERVICES ]
then
	/usr/bin/perl -pi -e 's/mysqld=ON/mysqld=OFF/' ${SERVICES};
fi

/sbin/service mysqld stop 2> /dev/null 1> /dev/null
/sbin/service mysql stop 2> /dev/null 1> /dev/null
/usr/bin/killall mysqld 2> /dev/null 1> /dev/null

#removed this because it's in the setup.sh now.
#if [ -e /etc/my.cnf ]; then
#	echo "Moving /etc/my.cnf to my.cnf.moved";
#	mv -f /etc/my.cnf /etc/my.cnf.moved
#fi

if [ -e /root/.my.cnf ]; then
	echo "Moving /root/.my.cnf to .my.cnf.moved";
	mv -f /root/.my.cnf /root/.my.cnf.moved
fi

rpm -e --nodeps MySQL-Max 2> /dev/null 1> /dev/null
rpm -e --nodeps mysql-devel 2> /dev/null 1> /dev/null
rpm -e --nodeps mysql-client 2> /dev/null 1> /dev/null
rpm -e --nodeps mysql-libs 2> /dev/null 1> /dev/null
rpm -e --nodeps mysqlclient9 2> /dev/null 1> /dev/null
rpm -e --nodeps mysql-server 2> /dev/null 1> /dev/null
rpm -e --nodeps mysql 2> /dev/null 1> /dev/null
rpm -e --nodeps MySQL-shared 2> /dev/null 1> /dev/null  #added july 3 2006 for mysql 5 shared rpms
rpm -e --nodeps mysql-libs php-mysql 2> /dev/null 1> /dev/null #added Dec 5, 2007 for fedora 7.

#Added June 15th, 2011
if [ -e /usr/bin/mysql ]; then
	for i in `rpm -qa | grep -i "^mysql"`; do { rpm -ev $i --nodeps; }; done;
fi

SQLDIR=/var/lib/mysql
if [ -e ${SQLDIR} ]
then
	if [ $CMD_LINE -eq 1 ]; then
		mv ${SQLDIR} ${SQLDIR}.backup;
		rm -rf ${SQLDIR};
	else
	echo "";
	echo "*****************************************************";
	echo "*****************************************************";
	echo "";
	echo "It seems as though mysql has already been installed.";
	echo "The directory ${SQLDIR} has been found.  For the best results, its recommended that this be deleted.";
	echo "All database data will be lost if you delete it";
	echo "";
	echo -n "Do you want to delete it? (y is recommended)? (y,n) : ";
	read -n 1 yesno;
	echo "";
	if [ "$yesno" != "n" ]
	then
		mv ${SQLDIR} ${SQLDIR}.backup;
		rm -rf ${SQLDIR};
	fi
	fi
fi

#july 10, 2008: changed ivh to Uvh.

rpm -Uvh --nodeps --force /usr/local/directadmin/scripts/packages/MySQL-server*.rpm
rpm -Uvh --nodeps --force /usr/local/directadmin/scripts/packages/MySQL-client*.rpm
rpm -Uvh --nodeps --force /usr/local/directadmin/scripts/packages/MySQL-devel*.rpm
rpm -Uvh --nodeps --force /usr/local/directadmin/scripts/packages/MySQL-shared*.rpm >/dev/null 2>/dev/null
#the shared rpm might not exist.  Shhh, it might want to throw errors, we'll hide them.

#because we can't really edit the rpms, we just change the shell after the fact.
/usr/sbin/usermod -s /bin/false mysql

setStartupScript

/sbin/service mysqld start

echo "Waiting for mysqld to start....";
sleep 7


echo "Setting MySQL Root Password...";
setRootPass $1;
echo "Setting DirectAdmin user and password...";
setDAuser $1 $2 $3;

echo "Updating privilege tables...";
#/usr/local/directadmin/scripts/fix_mysql_privs.sh

if [ -e /usr/lib64 ]; then
	if [ ! -e /usr/lib/mysql ]; then
		echo "Linking 64 bit mysql libraries: /usr/lib64/libmysqlclient -> /usr/lib/mysql/* ...";
		cd /usr/lib
		mkdir mysql
		cd mysql
		ln -s /usr/lib64/libmysqlclient* .
	fi
fi

exit 0;
