#!/bin/bash

DA_PATH=/usr/local/directadmin
DA_SCRIPTS=${DA_PATH}/scripts
DA_TQ=${DA_PATH}/data/task.queue

#added new options to templates
#echo 'action=rewrite&value=httpd' >> $DA_TQ

echo "action=cache&value=showallusers" >> /usr/local/directadmin/data/task.queue
echo "action=cache&value=safemode" >> $DA_TQ
echo "action=convert&value=cronbackups" >> $DA_TQ
echo "action=convert&value=suspendedmysql" >> $DA_TQ
echo "action=syscheck" >> $DA_TQ

#get rid of the old mysql 3 to 4.0 conversion script: (it breaks 4.1+ systems)
FILE=$DA_SCRIPTS/mysql_fix_privilege_tables
if [ -e $FILE ]; then
	rm -f $FILE;
fi

if [ ! -d /usr/local/sysbk ]; then
	cd $DA_SCRIPTS
	./sysbk.sh
fi

if [ -e /etc/init.d/da-popb4smtp ]; then
	if [ -e /etc/debian_version ]; then
		/etc/init.d/da-popb4smtp restart
	else
		/sbin/service da-popb4smtp restart
	fi
fi

#grep -H "usertype=reseller" /usr/local/directadmin/data/users/*/user.conf | cut -d/ -f7 > /usr/local/directadmin/data/admin/reseller.list
#chown diradmin:diradmin /usr/local/directadmin/data/admin/reseller.list
#chmod 600 /usr/local/directadmin/data/admin/reseller.list

echo "action=addoptions" >> $DA_TQ
rm -f /usr/local/directadmin/data/skins/*/ssi_test.html 2>/dev/null
perl -pi -e 's/trusted_users = mail:majordomo:apache$/trusted_users = mail:majordomo:apache:diradmin/' /etc/exim.conf

COUNT=`grep uid_exempt /etc/exim.pl | grep -c yes`
FILE=/etc/exim.pl.1.24.0.back
if [ $COUNT -eq 0 ]; then
	if [ ! -e $FILE ]; then
		cp -f /etc/exim.pl $FILE
		wget -q -O /etc/exim.pl.new http://files.directadmin.com/services/exim.pl
		RET=$?
		if [ $RET -eq 0 ]; then
			mv -f /etc/exim.pl.new /etc/exim.pl
			chmod 755 /etc/exim.pl
			echo "action=restart&value=exim" >> $DA_TQ
		fi
	fi
fi

if [ -e /etc/logrotate.d ]; then
	if [ ! -e /etc/logrotate.d/directadmin ] && [ -e $DA_SCRIPTS/directadmin.rotate ]; then
		cp $DA_SCRIPTS/directadmin.rotate /etc/logrotate.d/directadmin
	fi
fi

chmod 750 /etc/virtual/majordomo

${DA_SCRIPTS}/cron_deny.sh

perl -pi -e "s/userlog \"%u %b\"/userlog \"%u %b %m\"/" /etc/proftpd.conf
echo "action=proftpd&value=restart" >> /usr/local/directadmin/data/task.queue

if [ -e /usr/share/spamassassin/72_active.cf ]; then
	perl -pi -e 's#header   FH_DATE_PAST_20XX.*#header   FH_DATE_PAST_20XX      Date =~ /20[2-9][0-9]/ [if-unset: 2006]#' /usr/share/spamassassin/72_active.cf
fi

if [ -e /etc/exim.key ]; then
        chown mail:mail /etc/exim.key
        chmod 644 /etc/exim.key
fi

UKN=/etc/virtual/limit_unknown
if [ ! -e $UKN ]; then
	echo 0 > $UKN;
	chown mail:mail $UKN
	chown mail:mail /etc/virtual/limit
fi

#debian if MySQL 5.5.11+
#april 21, 2011
if [ -e /etc/debian_version ]; then
			if [ -e /usr/local/directadmin/directadmin ]; then
				COUNT=`ldd /usr/local/directadmin/directadmin | grep -c libmysqlclient.so.16`
				if [ "${COUNT}" -eq 1 ]; then
					if [ ! -e /usr/local/mysql/lib/libmysqlclient.so.16 ] && [ -e /usr/local/mysql/lib/libmysqlclient.so.18 ]; then
						echo "*** Linking libmysqlclient.so.16 to libmysqlclient.so.18";
						ln -s libmysqlclient.so.18 /usr/local/mysql/lib/libmysqlclient.so.16
						ldconfig
					fi
				fi
				COUNT=`ldd /usr/local/directadmin/directadmin | grep -c libmysqlclient.so.18`
				if [ "${COUNT}" -eq 1 ]; then
					if [ ! -e /usr/local/mysql/lib/libmysqlclient.so.18 ] && [ -e /usr/local/mysql/lib/libmysqlclient.so.16 ]; then
						echo "*** Linking libmysqlclient.so.18 to libmysqlclient.so.16";
						ln -s libmysqlclient.so.16 /usr/local/mysql/lib/libmysqlclient.so.18
						ldconfig
					fi
				fi
			fi
fi

exit 0;
