#!/bin/bash
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:~/bin
function check_sys(){
    local checkType=$1;
    local value=$2;

    local release='';
    local systemPackage='';

    if [[ -f /etc/redhat-release ]]; then
        release="centos";
        systemPackage="yum";
    elif cat /etc/issue | grep -Eqi "debian"; then
        release="debian"
        systemPackage="apt";
    elif cat /etc/issue | grep -Eqi "ubuntu"; then
        release="ubuntu"
        systemPackage="apt";
    elif cat /etc/issue | grep -Eqi "centos|red hat|redhat"; then
        release="centos"
        systemPackage="yum";
    elif cat /proc/version | grep -Eqi "debian"; then
        release="debian";
        systemPackage="apt";
    elif cat /proc/version | grep -Eqi "ubuntu"; then
        release="ubuntu";
        systemPackage="apt";
    elif cat /proc/version | grep -Eqi "centos|red hat|redhat"; then
        release="centos";
        systemPackage="yum";
    fi;

    if [[ ${checkType} == "sysRelease" ]]; then
        if [ "$value" == "$release" ]; then
            return 0;
        else
            return 1;
        fi;
    elif [[ ${checkType} == "packageManager" ]]; then
        if [ "$value" == "$systemPackage" ]; then
            return 0;
        else
            return 1;
        fi;
    fi;
}
  answer="y";
    if [ "${answer}" == "y" ] || [ "${answer}" == "Y" ]; then
        ps -ef | grep -v grep | grep -i "shadowsocks-server" > /dev/null 2>&1;
        if [ $? -eq 0 ]; then
            /etc/init.d/shadowsocks stop;
        fi;
        if check_sys packageManager yum; then
            chkconfig --del shadowsocks;
        elif check_sys packageManager apt; then
            update-rc.d -f shadowsocks remove;
        fi;
        # delete config file
        rm -rf /etc/shadowsocks;
        # delete shadowsocks
        rm -f /etc/init.d/shadowsocks;
        rm -f /usr/bin/shadowsocks-server;
		/sbin/iptables-restore < /etc/amh-iptables;
		/sbin/iptables -D INPUT -p tcp --dport 1080 -j ACCEPT;
		/sbin/iptables -D INPUT -p tcp --dport 6868 -j ACCEPT;
		/sbin/iptables-save > /etc/amh-iptables;
        echo "Shadowsocks uninstall success!";
    else
        echo;
        echo "Uninstall cancelled, nothing to do...";
        echo;
    fi;